/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.targlets.core;

import java.io.File;
import java.io.IOException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.impl.BinaryResourceImpl;
import org.eclipse.oomph.resources.ResourcesUtil;
import org.eclipse.oomph.resources.backend.BackendContainer;
import org.eclipse.oomph.resources.backend.BackendResource;
import org.eclipse.oomph.targlets.core.Messages;
import org.eclipse.oomph.targlets.internal.core.TargletsCorePlugin;
import org.eclipse.osgi.util.NLS;

public final class WorkspaceIUInfo {
    private URI backendContainerURI;
    private String projectName;

    public WorkspaceIUInfo(BackendContainer backendContainer, String projectName) {
        this.backendContainerURI = backendContainer.getAbsoluteURI();
        this.projectName = projectName;
    }

    public WorkspaceIUInfo(BinaryResourceImpl.EObjectInputStream stream) throws IOException {
        this.backendContainerURI = stream.readURI();
        this.projectName = stream.readString();
    }

    public void write(BinaryResourceImpl.EObjectOutputStream stream) throws IOException {
        stream.writeURI(this.backendContainerURI);
        stream.writeString(this.projectName);
    }

    public BackendContainer getBackendContainer() {
        return (BackendContainer)BackendResource.get((URI)this.backendContainerURI);
    }

    public String getProjectName() {
        return this.projectName;
    }

    public File getLocation() {
        BackendContainer backendContainer = this.getBackendContainer();
        if (backendContainer.isLocal()) {
            return new File(backendContainer.getLocation().toString());
        }
        String workspaceFolder = ResourcesPlugin.getWorkspace().getRoot().getLocation().toString();
        String projectFolderName = backendContainer.getName();
        return new File(workspaceFolder, projectFolderName);
    }

    public ResourcesUtil.ImportResult importIntoWorkspace(IProgressMonitor monitor) {
        try {
            File location = this.getLocation();
            IWorkspace workspace = ResourcesPlugin.getWorkspace();
            IWorkspaceRoot root = workspace.getRoot();
            IProject project = root.getProject(this.projectName);
            if (project.exists()) {
                File existingLocation = new File(project.getLocation().toOSString()).getCanonicalFile();
                if (!existingLocation.equals(location)) {
                    TargletsCorePlugin.INSTANCE.log(NLS.bind((String)Messages.WorkspaceIUInfo_ProjectExists_message, (Object)this.projectName, (Object)existingLocation));
                    return ResourcesUtil.ImportResult.EXISTED_DIFFERENT_LOCATION;
                }
                return ResourcesUtil.ImportResult.EXISTED;
            }
            monitor.setTaskName(NLS.bind((String)Messages.WorkspaceIUInfo_Importing_task, (Object)this.projectName));
            BackendContainer backendContainer = this.getBackendContainer();
            backendContainer.importIntoWorkspace(project, monitor);
            if (!project.isOpen()) {
                project.open(monitor);
            }
            return ResourcesUtil.ImportResult.IMPORTED;
        }
        catch (Exception ex) {
            TargletsCorePlugin.INSTANCE.log(ex);
            monitor.subTask(NLS.bind((String)Messages.WorkspaceIUInfo_ImportFailed_message, (Object)this));
            return ResourcesUtil.ImportResult.ERROR;
        }
    }

    public int hashCode() {
        return this.backendContainerURI.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        WorkspaceIUInfo other = (WorkspaceIUInfo)obj;
        return this.backendContainerURI == other.backendContainerURI;
    }

    public String toString() {
        return this.backendContainerURI + "[" + this.projectName + "]";
    }
}

