/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.api.tools.ui.internal.markers;

import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.pde.api.tools.internal.ApiBaselineManager;
import org.eclipse.pde.api.tools.internal.problems.ApiProblemFactory;
import org.eclipse.pde.api.tools.internal.provisional.IApiFilterStore;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiComponent;
import org.eclipse.pde.api.tools.internal.provisional.problems.IApiProblemFilter;
import org.eclipse.pde.api.tools.internal.util.Util;
import org.eclipse.pde.api.tools.ui.internal.markers.ConfigureProblemSeverityForAPIToolsResolution;
import org.eclipse.pde.api.tools.ui.internal.markers.DefaultApiProfileResolution;
import org.eclipse.pde.api.tools.ui.internal.markers.DuplicateAnnotationResolution;
import org.eclipse.pde.api.tools.ui.internal.markers.DuplicateTagResolution;
import org.eclipse.pde.api.tools.ui.internal.markers.FilterProblemResolution;
import org.eclipse.pde.api.tools.ui.internal.markers.FilterProblemWithCommentResolution;
import org.eclipse.pde.api.tools.ui.internal.markers.MarkerMessages;
import org.eclipse.pde.api.tools.ui.internal.markers.OpenPropertyPageResolution;
import org.eclipse.pde.api.tools.ui.internal.markers.ProblemExplainIncompatibilityResolution;
import org.eclipse.pde.api.tools.ui.internal.markers.RemoveFilterProblemResolution;
import org.eclipse.pde.api.tools.ui.internal.markers.SinceTagAfterVersionUpdateResolution;
import org.eclipse.pde.api.tools.ui.internal.markers.SinceTagResolution;
import org.eclipse.pde.api.tools.ui.internal.markers.UnsupportedAnnotationResolution;
import org.eclipse.pde.api.tools.ui.internal.markers.UnsupportedTagResolution;
import org.eclipse.pde.api.tools.ui.internal.markers.VersionNumberingResolution;
import org.eclipse.ui.IMarkerResolution;
import org.eclipse.ui.IMarkerResolutionGenerator2;

public class ApiMarkerResolutionGenerator
implements IMarkerResolutionGenerator2 {
    private final IMarkerResolution[] NO_RESOLUTIONS = new IMarkerResolution[0];
    private DefaultApiProfileResolution profileResolution = new DefaultApiProfileResolution();

    public IMarkerResolution[] getResolutions(IMarker marker) {
        if (!this.hasResolutions(marker)) {
            return this.NO_RESOLUTIONS;
        }
        switch (marker.getAttribute("apiMarkerID", -1)) {
            case 3: {
                return new IMarkerResolution[]{new ConfigureProblemSeverityForAPIToolsResolution(marker), new FilterProblemResolution(marker), new FilterProblemWithCommentResolution(marker)};
            }
            case 2: {
                if (ApiMarkerResolutionGenerator.hasExplainProblemResolution(marker)) {
                    return new IMarkerResolution[]{new ProblemExplainIncompatibilityResolution(marker), new FilterProblemResolution(marker), new FilterProblemWithCommentResolution(marker), new ConfigureProblemSeverityForAPIToolsResolution(marker)};
                }
                return new IMarkerResolution[]{new ConfigureProblemSeverityForAPIToolsResolution(marker), new FilterProblemResolution(marker), new FilterProblemWithCommentResolution(marker)};
            }
            case 1: {
                return new IMarkerResolution[]{this.profileResolution, new ConfigureProblemSeverityForAPIToolsResolution(marker)};
            }
            case 5: {
                IMarkerResolution[] iMarkerResolutionArray;
                IMarker markerVersion = this.getVersionProblems(marker);
                if (markerVersion != null) {
                    IMarkerResolution[] iMarkerResolutionArray2 = new IMarkerResolution[5];
                    iMarkerResolutionArray2[0] = new ConfigureProblemSeverityForAPIToolsResolution(marker);
                    iMarkerResolutionArray2[1] = new SinceTagAfterVersionUpdateResolution(markerVersion, marker);
                    iMarkerResolutionArray2[2] = new SinceTagResolution(marker);
                    iMarkerResolutionArray2[3] = new FilterProblemResolution(marker);
                    iMarkerResolutionArray = iMarkerResolutionArray2;
                    iMarkerResolutionArray2[4] = new FilterProblemWithCommentResolution(marker);
                } else {
                    IMarkerResolution[] iMarkerResolutionArray3 = new IMarkerResolution[4];
                    iMarkerResolutionArray3[0] = new ConfigureProblemSeverityForAPIToolsResolution(marker);
                    iMarkerResolutionArray3[1] = new SinceTagResolution(marker);
                    iMarkerResolutionArray3[2] = new FilterProblemResolution(marker);
                    iMarkerResolutionArray = iMarkerResolutionArray3;
                    iMarkerResolutionArray3[3] = new FilterProblemWithCommentResolution(marker);
                }
                IMarkerResolution[] res = iMarkerResolutionArray;
                return res;
            }
            case 4: {
                return new IMarkerResolution[]{new ConfigureProblemSeverityForAPIToolsResolution(marker), new VersionNumberingResolution(marker), new FilterProblemResolution(marker), new FilterProblemWithCommentResolution(marker)};
            }
            case 6: {
                return new IMarkerResolution[]{new VersionNumberingResolution(marker), new UnsupportedTagResolution(marker), new ConfigureProblemSeverityForAPIToolsResolution(marker)};
            }
            case 7: {
                return new IMarkerResolution[]{new DuplicateTagResolution(marker)};
            }
            case 11: {
                return new IMarkerResolution[]{new VersionNumberingResolution(marker), new UnsupportedAnnotationResolution(marker), new ConfigureProblemSeverityForAPIToolsResolution(marker)};
            }
            case 10: {
                return new IMarkerResolution[]{new DuplicateAnnotationResolution(marker)};
            }
            case 8: {
                return new IMarkerResolution[]{new ConfigureProblemSeverityForAPIToolsResolution(marker)};
            }
            case 9: {
                IApiProblemFilter filter = ApiMarkerResolutionGenerator.resolveFilter(marker);
                if (filter != null) {
                    return new IMarkerResolution[]{new ConfigureProblemSeverityForAPIToolsResolution(marker), new RemoveFilterProblemResolution(filter, marker), new OpenPropertyPageResolution(MarkerMessages.ApiMarkerResolutionGenerator_api_problem_filters, "org.eclipse.pde.api.tools.ui.apitools.filterspage", (IAdaptable)marker.getResource().getProject())};
                }
                return new IMarkerResolution[]{new OpenPropertyPageResolution(MarkerMessages.ApiMarkerResolutionGenerator_api_problem_filters, "org.eclipse.pde.api.tools.ui.apitools.filterspage", (IAdaptable)marker.getResource().getProject())};
            }
        }
        return this.NO_RESOLUTIONS;
    }

    static IApiProblemFilter resolveFilter(IMarker marker) {
        try {
            String filterhandle = marker.getAttribute("filterhandle", null);
            String[] values = filterhandle.split("%]");
            IProject project = marker.getResource().getProject();
            IApiComponent component = ApiBaselineManager.getManager().getWorkspaceBaseline().getApiComponent(project);
            if (component != null) {
                IApiProblemFilter[] filters;
                IApiFilterStore store = component.getFilterStore();
                IPath path = IPath.fromOSString((String)values[1]);
                IResource resource = project.findMember(path);
                if (resource == null) {
                    resource = project.getFile(path);
                }
                int hashcode = ApiProblemFactory.getProblemHashcode((String)filterhandle);
                IApiProblemFilter[] iApiProblemFilterArray = filters = store.getFilters(resource);
                int n = filters.length;
                int n2 = 0;
                while (n2 < n) {
                    IApiProblemFilter filter = iApiProblemFilterArray[n2];
                    if (filter.getUnderlyingProblem().hashCode() == hashcode) {
                        return filter;
                    }
                    ++n2;
                }
            }
        }
        catch (CoreException coreException) {}
        return null;
    }

    public boolean hasResolutions(IMarker marker) {
        return Util.isApiProblemMarker((IMarker)marker);
    }

    public static boolean hasExplainProblemResolution(IMarker marker) {
        int id = ApiProblemFactory.getProblemId((IMarker)marker);
        return id > -1 && (id == ApiProblemFactory.createProblemId((int)0x10000000, (int)4, (int)1, (int)16) || id == ApiProblemFactory.createProblemId((int)0x10000000, (int)8, (int)1, (int)16) || id == ApiProblemFactory.createProblemId((int)0x10000000, (int)8, (int)1, (int)73));
    }

    private IMarker getVersionProblems(IMarker marker) {
        IProject project = null;
        IProject project2 = null;
        IResource resource = marker.getResource();
        if (resource != null) {
            project = resource.getProject();
        }
        IMarker markerVersion = null;
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        try {
            IMarker[] findMarkers;
            IMarker[] iMarkerArray = findMarkers = root.findMarkers("org.eclipse.pde.api.tools.version_numbering", false, 2);
            int n = findMarkers.length;
            int n2 = 0;
            while (n2 < n) {
                IMarker iMarker = iMarkerArray[n2];
                IResource resource2 = iMarker.getResource();
                if (resource2 != null) {
                    project2 = resource2.getProject();
                    if (project != null && project2 != null && project.equals((Object)project2)) {
                        markerVersion = iMarker;
                        break;
                    }
                }
                ++n2;
            }
        }
        catch (CoreException coreException) {}
        return markerVersion;
    }
}

