/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.ctx.capability.ui.views;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.util.EContentAdapter;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.rcptt.core.model.IQ7NamedElement;
import org.eclipse.rcptt.core.scenario.CapabilityContext;
import org.eclipse.rcptt.core.scenario.CapabilityContextItem;
import org.eclipse.rcptt.core.scenario.ScenarioPackage;
import org.eclipse.rcptt.ctx.capability.CapabilityManager;
import org.eclipse.rcptt.ctx.capability.ui.views.CapabilityDialog;
import org.eclipse.rcptt.ctx.capability.ui.views.CapabiltyContextTable;
import org.eclipse.rcptt.ctx.capability.ui.views.Messages;
import org.eclipse.rcptt.internal.ui.Images;
import org.eclipse.rcptt.ui.controls.AbstractEmbeddedComposite;
import org.eclipse.rcptt.ui.controls.IEmbeddedComposite;
import org.eclipse.rcptt.ui.controls.SectionWithToolbar;
import org.eclipse.rcptt.ui.editors.NamedElementEditorActions;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

public class CapabilityContextTables
extends AbstractEmbeddedComposite
implements NamedElementEditorActions.INamedElementActions {
    private static final int SECTION_STYLE = 322;
    private final Map<CapabiltyContextTable, Section> contextToSection = new HashMap<CapabiltyContextTable, Section>();
    private final Adapter adapter = new Adapter();
    private final FormToolkit toolkit;
    private final CapabilityContext context;
    private final IQ7NamedElement namedElement;
    private Composite composite;
    private Action addTool;
    private CapabiltyContextTable activeTable;

    public CapabilityContextTables(IQ7NamedElement namedElement, CapabilityContext context, FormToolkit toolkit) {
        this.namedElement = namedElement;
        this.context = context;
        this.toolkit = toolkit;
    }

    public String getName() {
        return Messages.CapabilityContextTables_SectionName;
    }

    public Image getImage() {
        return Images.getImage((String)"icons/context.gif");
    }

    public Control getControl() {
        return this.composite;
    }

    public void dispose() {
        this.context.eAdapters().remove((Object)this.adapter);
        super.dispose();
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        this.composite = new Composite(parent, 0);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.composite);
        GridLayoutFactory.fillDefaults().margins(5, 5).spacing(0, 0).equalWidth(true).applyTo(this.composite);
        this.context.eAdapters().add((Object)this.adapter);
        this.updateTables();
    }

    protected void fillActions(IToolBarManager manager) {
        this.addTool = new Action(){

            public void run() {
                CapabilityContextTables.this.handleAddCapability();
            }
        };
        this.addTool.setText(Messages.CapabilityContextTables_AddActionText);
        this.addTool.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_OBJ_ADD"));
        manager.add((IAction)this.addTool);
        this.updateActionState();
    }

    protected void handleAddCapability() {
        CapabilityDialog dialog = new CapabilityDialog(this.getControl().getShell(), this.context);
        if (dialog.open() == 0) {
            CapabilityManager.getManager().addCapability(this.context, dialog.getResult());
        }
    }

    public void undo() {
        if (this.activeTable != null) {
            this.activeTable.undo();
        }
    }

    public void redo() {
        if (this.activeTable != null) {
            this.activeTable.redo();
        }
    }

    public boolean canUndo() {
        return this.activeTable != null && this.activeTable.canUndo();
    }

    public boolean canRedo() {
        return this.activeTable != null && this.activeTable.canRedo();
    }

    public void copy() {
        if (this.activeTable != null) {
            this.activeTable.copy();
        }
    }

    public void paste() {
        if (this.activeTable != null) {
            this.activeTable.paste();
        }
    }

    public void cut() {
        if (this.activeTable != null) {
            this.activeTable.cut();
        }
    }

    public boolean canCopy() {
        return this.activeTable != null && this.activeTable.canCopy();
    }

    public boolean canPaste() {
        return this.activeTable != null && this.activeTable.canPaste();
    }

    public boolean canCut() {
        return this.activeTable != null && this.activeTable.canCut();
    }

    private void fillUIContextItems() {
        this.contextToSection.clear();
        for (CapabilityContextItem item : this.context.getItems()) {
            final CapabiltyContextTable table = new CapabiltyContextTable(this.namedElement, item);
            SectionWithToolbar section = new SectionWithToolbar((IEmbeddedComposite)table, 322);
            Section control = section.create(this.composite, this.toolkit);
            this.contextToSection.put(table, control);
            table.getControl().addFocusListener(new FocusListener(){

                public void focusLost(FocusEvent e) {
                }

                public void focusGained(FocusEvent e) {
                    CapabilityContextTables.this.activeTable = table;
                }
            });
        }
    }

    private void updateSectionName() {
        for (Map.Entry<CapabiltyContextTable, Section> entry : this.contextToSection.entrySet()) {
            entry.getValue().setText(entry.getKey().getName());
        }
    }

    private void updateActionState() {
        this.addTool.setEnabled(CapabilityManager.getManager().getAvaliableCapabiltiies(this.context).length != 0);
    }

    private void updateTables() {
        try {
            this.composite.setRedraw(false);
            Control[] children = this.composite.getChildren();
            int i = children.length - 1;
            while (i >= 0) {
                children[i].dispose();
                --i;
            }
            this.fillUIContextItems();
        }
        finally {
            this.composite.setRedraw(true);
            this.composite.layout();
        }
    }

    private class Adapter
    extends EContentAdapter {
        private Adapter() {
        }

        public void notifyChanged(Notification notification) {
            super.notifyChanged(notification);
            Object feature = notification.getFeature();
            if (feature == ScenarioPackage.Literals.CAPABILITY_CONTEXT__ITEMS) {
                CapabilityContextTables.this.updateTables();
                CapabilityContextTables.this.updateActionState();
            } else if (feature == ScenarioPackage.Literals.CAPABILITY_CONTEXT_ITEM__CAPABILITY) {
                CapabilityContextTables.this.updateSectionName();
                CapabilityContextTables.this.updateActionState();
            }
        }
    }
}

