/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.ui.actions;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.rse.core.IRSESystemType;
import org.eclipse.rse.core.filters.ISystemFilterPoolReference;
import org.eclipse.rse.core.filters.ISystemFilterReference;
import org.eclipse.rse.core.filters.ISystemFilterStringReference;
import org.eclipse.rse.core.model.IHost;
import org.eclipse.rse.core.subsystems.ISubSystem;
import org.eclipse.rse.internal.ui.SystemResources;
import org.eclipse.rse.ui.RSEUIPlugin;
import org.eclipse.rse.ui.actions.SystemBaseWizardAction;
import org.eclipse.rse.ui.wizards.newconnection.RSEDefaultNewConnectionWizard;
import org.eclipse.rse.ui.wizards.newconnection.RSEMainNewConnectionWizard;
import org.eclipse.swt.widgets.Shell;

public class SystemNewConnectionAction
extends SystemBaseWizardAction {
    private boolean fromPopupMenu = true;
    private ISelectionProvider sp;
    private IRSESystemType[] restrictSystemTypesTo;
    private ISelection selectedContext;
    private IHost connectionContext;

    public SystemNewConnectionAction(Shell shell, boolean fromPopupMenu, ISelectionProvider sp) {
        this(shell, fromPopupMenu, true, sp);
    }

    public SystemNewConnectionAction(Shell shell, boolean fromPopupMenu, boolean wantIcon, ISelectionProvider sp) {
        this(shell, SystemResources.ACTION_NEWCONN_LABEL, SystemResources.ACTION_NEWCONN_TOOLTIP, fromPopupMenu, wantIcon, sp);
    }

    public SystemNewConnectionAction(Shell shell, String label, String tooltip, boolean fromPopupMenu, boolean wantIcon, ISelectionProvider sp) {
        super(label, tooltip, wantIcon ? RSEUIPlugin.getDefault().getImageDescriptor("org.eclipse.rse.ui.newconnection_wizIcon") : null, shell);
        this.setContextMenuGroup("group.new");
        this.fromPopupMenu = fromPopupMenu;
        this.sp = sp;
        this.setHelp("org.eclipse.rse.ui.actn0000");
    }

    protected IWizard createWizard() {
        this.setValue(null);
        RSEMainNewConnectionWizard newConnWizard = new RSEMainNewConnectionWizard();
        if (!this.fromPopupMenu && this.sp != null) {
            this.setSelection(this.sp.getSelection());
        }
        if (this.restrictSystemTypesTo != null) {
            newConnWizard.restrictToSystemTypes(this.restrictSystemTypesTo);
        }
        newConnWizard.setSelectedContext(this.selectedContext);
        newConnWizard.setConnectionContext(this.connectionContext);
        if (newConnWizard.isRestrictedToSingleSystemType()) {
            IWizard wizard = newConnWizard.getSelectedWizard();
            if (wizard instanceof ISelectionChangedListener) {
                ((ISelectionChangedListener)wizard).selectionChanged(new SelectionChangedEvent((ISelectionProvider)newConnWizard, newConnWizard.getSelection()));
            }
            return wizard;
        }
        return newConnWizard;
    }

    protected WizardDialog doCreateWizardDialog(Shell shell, IWizard wizard) {
        return new WizardDialog(this.getShell(), wizard);
    }

    public void restrictSystemTypes(IRSESystemType[] systemTypes) {
        this.restrictSystemTypesTo = systemTypes;
    }

    protected void postProcessWizard(IWizard wizard) {
        if (wizard instanceof RSEMainNewConnectionWizard) {
            wizard = ((RSEMainNewConnectionWizard)wizard).getSelectedWizard();
        }
        if (wizard instanceof RSEDefaultNewConnectionWizard) {
            this.setValue(((RSEDefaultNewConnectionWizard)wizard).getCreatedHost());
        }
    }

    protected Object getDialogValue(Dialog dlg) {
        Object value = super.getDialogValue(dlg);
        if (value == null && this.getValue() != null) {
            value = this.getValue();
        }
        return value;
    }

    public boolean updateSelection(IStructuredSelection selection) {
        boolean enabled = super.updateSelection(selection);
        this.selectedContext = selection;
        if (enabled) {
            Object firstSelection = this.getFirstSelection();
            IHost conn = null;
            if (firstSelection != null) {
                if (firstSelection instanceof IHost) {
                    conn = (IHost)firstSelection;
                } else if (firstSelection instanceof ISubSystem) {
                    conn = ((ISubSystem)firstSelection).getHost();
                } else if (firstSelection instanceof ISystemFilterPoolReference) {
                    ISystemFilterPoolReference sfpr = (ISystemFilterPoolReference)firstSelection;
                    ISubSystem ss = (ISubSystem)sfpr.getProvider();
                    conn = ss.getHost();
                } else if (firstSelection instanceof ISystemFilterReference) {
                    ISystemFilterReference sfr = (ISystemFilterReference)firstSelection;
                    ISubSystem ss = (ISubSystem)sfr.getProvider();
                    conn = ss.getHost();
                } else if (firstSelection instanceof ISystemFilterStringReference) {
                    ISystemFilterStringReference sfsr = (ISystemFilterStringReference)firstSelection;
                    ISubSystem ss = (ISubSystem)sfsr.getProvider();
                    conn = ss.getHost();
                }
            }
            this.connectionContext = conn;
        }
        return enabled;
    }
}

