/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.processes.core.model;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.core.runtime.Assert;
import org.eclipse.tcf.protocol.Protocol;
import org.eclipse.tcf.te.tcf.locator.interfaces.nodes.IPeerNode;
import org.eclipse.tcf.te.tcf.processes.core.model.interfaces.runtime.IRuntimeModel;
import org.eclipse.tcf.te.tcf.processes.core.model.runtime.RuntimeModel;

public class ModelManager {
    static final Map<String, IRuntimeModel> runtimeModels = new HashMap<String, IRuntimeModel>();

    public static IRuntimeModel getRuntimeModel(final IPeerNode peerNode) {
        Assert.isNotNull((Object)peerNode);
        final AtomicReference runtimeModel = new AtomicReference();
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                Assert.isTrue((boolean)Protocol.isDispatchThread());
                String id = peerNode.getPeerId();
                IRuntimeModel candidate = runtimeModels.get(id);
                if (candidate == null && (candidate = ModelManager.initializeRuntimeModel(peerNode)) != null) {
                    runtimeModels.put(id, candidate);
                }
                runtimeModel.set(candidate);
            }
        };
        if (Protocol.isDispatchThread()) {
            runnable.run();
        } else {
            Protocol.invokeAndWait((Runnable)runnable);
        }
        return (IRuntimeModel)runtimeModel.get();
    }

    protected static IRuntimeModel initializeRuntimeModel(IPeerNode peerNode) {
        Assert.isTrue((boolean)Protocol.isDispatchThread());
        RuntimeModel runtimeModel = new RuntimeModel(peerNode);
        return runtimeModel;
    }

    public static void disposeRuntimeModel(final IPeerNode peerNode) {
        Assert.isNotNull((Object)peerNode);
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                Assert.isTrue((boolean)Protocol.isDispatchThread());
                String id = peerNode.getPeerId();
                IRuntimeModel candidate = runtimeModels.remove(id);
                if (candidate != null) {
                    candidate.dispose();
                }
            }
        };
        if (Protocol.isDispatchThread()) {
            runnable.run();
        } else {
            Protocol.invokeAndWait((Runnable)runnable);
        }
    }
}

