/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.xml.model.generic;

import java.util.List;
import org.eclipse.wb.internal.core.model.generic.SimpleContainer;
import org.eclipse.wb.internal.core.xml.model.IRootProcessor;
import org.eclipse.wb.internal.core.xml.model.XmlObjectInfo;
import org.eclipse.wb.internal.core.xml.model.broadcast.XmlObjectClipboardCopy;
import org.eclipse.wb.internal.core.xml.model.clipboard.ClipboardCommand;
import org.eclipse.wb.internal.core.xml.model.clipboard.XmlObjectMemento;
import org.eclipse.wb.internal.core.xml.model.generic.SimpleContainerFactory;

public final class SimpleContainerClipboardSupport
implements IRootProcessor {
    public static final IRootProcessor INSTANCE = new SimpleContainerClipboardSupport();

    private SimpleContainerClipboardSupport() {
    }

    @Override
    public void process(XmlObjectInfo root) throws Exception {
        root.addBroadcastListener(new XmlObjectClipboardCopy(){

            @Override
            public void invoke(XmlObjectInfo object, List<ClipboardCommand> commands) throws Exception {
                List<SimpleContainer> containers = SimpleContainerClipboardSupport.getSimpleContainers(object);
                int i = 0;
                while (i < containers.size()) {
                    SimpleContainer container = containers.get(i);
                    Object child = container.getChild();
                    if (child instanceof XmlObjectInfo) {
                        ClipboardCommand command = SimpleContainerClipboardSupport.createCommand(i, (XmlObjectInfo)((Object)child));
                        commands.add(command);
                    }
                    ++i;
                }
            }
        });
    }

    private static List<SimpleContainer> getSimpleContainers(XmlObjectInfo object) {
        return new SimpleContainerFactory(object, true).get();
    }

    private static ClipboardCommand createCommand(final int containerIndex, XmlObjectInfo child) throws Exception {
        final XmlObjectMemento memento = XmlObjectMemento.createMemento(child);
        ClipboardCommand command = new ClipboardCommand(){
            private static final long serialVersionUID = 0L;

            @Override
            public void execute(XmlObjectInfo newContainer) throws Exception {
                XmlObjectInfo newChild = memento.create(newContainer);
                SimpleContainerClipboardSupport.getSimpleContainers(newContainer).get(containerIndex).command_CREATE((Object)newChild);
                memento.apply();
            }
        };
        return command;
    }
}

