/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.core.controls;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TypedEvent;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.SWTEventListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.TypedListener;
import org.eclipse.wb.internal.core.model.property.editor.TextControlActionsManager;
import org.eclipse.wb.internal.core.utils.check.Assert;

public class CComboBox
extends Composite {
    private Text m_text;
    private Button m_button;
    private Canvas m_canvas;
    private Shell m_popup;
    private TableViewer m_table;
    private boolean m_fullDropdownTableWidth = false;
    private boolean m_wasFocused;
    ArrayList<ComboBoxItem> m_items = Lists.newArrayList();
    private int m_selectionIndex = -1;

    public CComboBox(Composite parent, int style) {
        super(parent, style);
        this.createContents(this);
        this.m_wasFocused = this.isComboFocused();
        final Listener displayFocusInHook = new Listener(){

            public void handleEvent(Event event) {
                boolean focused = CComboBox.this.isComboFocused();
                if (CComboBox.this.m_wasFocused && !focused) {
                    CComboBox.this.comboDropDown(false);
                }
                if (event.widget != CComboBox.this) {
                    if (!CComboBox.this.m_wasFocused && focused) {
                        event.widget = CComboBox.this;
                        CComboBox.this.notifyListeners(15, event);
                    }
                    if (CComboBox.this.m_wasFocused && !focused) {
                        event.widget = CComboBox.this;
                        CComboBox.this.notifyListeners(16, event);
                    }
                }
                CComboBox.this.m_wasFocused = focused;
            }
        };
        final Listener displayFocusOutHook = new Listener(){

            public void handleEvent(Event event) {
                CComboBox.this.m_wasFocused = CComboBox.this.isComboFocused();
            }
        };
        Display display = this.getDisplay();
        display.addFilter(15, displayFocusInHook);
        display.addFilter(16, displayFocusOutHook);
        this.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                CComboBox.this.resizeInner();
            }
        });
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                Display display = CComboBox.this.getDisplay();
                display.removeFilter(15, displayFocusInHook);
                display.removeFilter(16, displayFocusOutHook);
                CComboBox.this.disposeInner();
            }
        });
    }

    protected void createContents(Composite parent) {
        this.createText(parent);
        this.createButton(parent);
        this.createImage(parent);
        this.createPopup(parent);
    }

    protected void createText(Composite parent) {
        this.m_text = new Text(parent, 0);
        new TextControlActionsManager(this.m_text);
        this.m_text.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                switch (e.keyCode) {
                    case 27: {
                        if (CComboBox.this.isDroppedDown()) {
                            CComboBox.this.comboDropDown(false);
                            e.doit = false;
                            break;
                        }
                        CComboBox.this.notifyListeners(1, CComboBox.convert2event((TypedEvent)e));
                        break;
                    }
                    case 0x1000001: {
                        if (CComboBox.this.isDroppedDown()) {
                            Table table;
                            int index = (table = CComboBox.this.m_table.getTable()).getSelectionIndex() - 1;
                            table.setSelection(index < 0 ? table.getItemCount() - 1 : index);
                            e.doit = false;
                            break;
                        }
                        CComboBox.this.notifyListeners(1, CComboBox.convert2event((TypedEvent)e));
                        break;
                    }
                    case 0x1000002: {
                        if (CComboBox.this.isDroppedDown()) {
                            Table table;
                            int index = (table = CComboBox.this.m_table.getTable()).getSelectionIndex() + 1;
                            table.setSelection(index == table.getItemCount() ? 0 : index);
                            e.doit = false;
                            break;
                        }
                        if ((e.stateMask & 0x10000) != 0) {
                            CComboBox.this.comboDropDown(true);
                            e.doit = false;
                            CComboBox.this.setFocus2Text(false);
                            break;
                        }
                        CComboBox.this.notifyListeners(1, CComboBox.convert2event((TypedEvent)e));
                        break;
                    }
                    case 13: {
                        Table table = CComboBox.this.m_table.getTable();
                        if (CComboBox.this.isDroppedDown() && table.getSelectionIndex() != -1) {
                            table.notifyListeners(13, CComboBox.convert2event((TypedEvent)e));
                            break;
                        }
                        CComboBox.this.m_text.selectAll();
                        CComboBox.this.setSelectionText(CComboBox.this.getEditText());
                        CComboBox.this.notifyListeners(13, CComboBox.convert2event((TypedEvent)e));
                    }
                }
            }
        });
        this.m_text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (CComboBox.this.isDroppedDown()) {
                    CComboBox.this.m_table.refresh();
                } else if (CComboBox.this.m_text.isFocusControl()) {
                    CComboBox.this.comboDropDown(true);
                    CComboBox.this.setFocus2Text(false);
                }
            }
        });
    }

    protected void createButton(Composite parent) {
        this.m_button = new Button(parent, 1028);
        this.m_button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CComboBox.this.comboDropDown(!CComboBox.this.isDroppedDown());
                CComboBox.this.setFocus2Text(true);
            }
        });
    }

    protected void createImage(Composite parent) {
        this.m_canvas = new Canvas(parent, 2048);
        this.m_canvas.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                Image selectionImage = CComboBox.this.getSelectionImage();
                if (selectionImage != null) {
                    e.gc.drawImage(selectionImage, 0, 0);
                } else {
                    e.gc.fillRectangle(CComboBox.this.m_canvas.getClientArea());
                }
            }
        });
    }

    protected void createPopup(Composite parent) {
        this.m_popup = new Shell(this.getShell(), 2048);
        this.m_popup.setLayout((Layout)new FillLayout());
        this.createTable((Composite)this.m_popup);
    }

    protected void createTable(Composite parent) {
        this.m_table = new TableViewer(parent, 65536);
        new TableViewerColumn(this.m_table, 16384);
        this.m_table.getTable().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int selectionIndex = CComboBox.this.m_table.getTable().getSelectionIndex();
                CComboBox.this.setSelectionIndex(selectionIndex);
                CComboBox.this.comboDropDown(false);
                CComboBox.this.notifyListeners(13, CComboBox.convert2event((TypedEvent)e));
            }
        });
        this.m_table.setContentProvider(this.getContentProvider());
        this.m_table.setLabelProvider(this.getLabelProvider());
        this.m_table.addFilter(this.getFilterProvider());
    }

    protected void resizeInner() {
        Rectangle clientArea = this.getClientArea();
        int rightOccupied = 0;
        int leftOccupied = 0;
        this.m_button.setBounds(clientArea.width - clientArea.height, 0, clientArea.height, clientArea.height);
        rightOccupied = clientArea.height;
        Image selectionImage = this.getSelectionImage();
        if (selectionImage != null) {
            this.m_canvas.setSize(clientArea.height, clientArea.height);
            leftOccupied = clientArea.height;
        } else {
            this.m_canvas.setSize(1, clientArea.height);
            leftOccupied = 1;
        }
        this.m_text.setBounds(leftOccupied, 0, clientArea.width - rightOccupied - leftOccupied, clientArea.height);
    }

    protected void disposeInner() {
        if (!this.m_popup.isDisposed()) {
            this.m_popup.dispose();
        }
    }

    protected IContentProvider getContentProvider() {
        return new IStructuredContentProvider(){

            public Object[] getElements(Object inputElement) {
                return CComboBox.this.m_items.toArray(new ComboBoxItem[CComboBox.this.m_items.size()]);
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        };
    }

    protected IBaseLabelProvider getLabelProvider() {
        return new LabelProvider(){

            public Image getImage(Object element) {
                ComboBoxItem item = (ComboBoxItem)element;
                return item.m_image;
            }

            public String getText(Object element) {
                ComboBoxItem item = (ComboBoxItem)element;
                return item.m_label;
            }
        };
    }

    protected ViewerFilter getFilterProvider() {
        return new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                String lookingString = CComboBox.this.m_text.getText().toLowerCase();
                if (CComboBox.this.isDroppedDown() && lookingString.length() > 0) {
                    ComboBoxItem item = (ComboBoxItem)element;
                    return item.m_label.toLowerCase().indexOf(lookingString) != -1;
                }
                return true;
            }
        };
    }

    public void addItem(String label, Image image) {
        Assert.isTrue(!this.isDroppedDown());
        this.m_items.add(new ComboBoxItem(label, image));
    }

    public void addItem(String label) {
        this.addItem(label, null);
    }

    public void removeAll() {
        this.m_items.clear();
    }

    public int getItemCount() {
        return this.m_items.size();
    }

    public String getItemLabel(int index) {
        return this.m_items.get((int)index).m_label;
    }

    public boolean isComboFocused() {
        return this.isFocusControl() || this.m_text.isFocusControl() || this.m_button.isFocusControl() || this.m_canvas.isFocusControl() || this.m_popup.isFocusControl() || this.m_table.getTable().isFocusControl();
    }

    public String getEditText() {
        return this.m_text.getText();
    }

    public void setEditText(String text) {
        this.m_text.setText(text == null ? "" : text);
        this.m_text.selectAll();
    }

    public void setEditSelection(int start, int end) {
        this.m_text.setSelection(start, end);
    }

    public void setReadOnly(boolean value) {
        this.m_text.setEditable(!value);
        this.m_button.setEnabled(!value);
    }

    public boolean isFullDropdownTableWidth() {
        return this.m_fullDropdownTableWidth;
    }

    public void setFullDropdownTableWidth(boolean value) {
        Assert.isTrue(!this.isDroppedDown());
        this.m_fullDropdownTableWidth = value;
    }

    public int getSelectionIndex() {
        return this.m_selectionIndex;
    }

    public void setSelectionIndex(int index) {
        this.m_selectionIndex = index;
        if (this.isDroppedDown()) {
            this.m_table.getTable().setSelection(this.m_selectionIndex);
        }
        this.setEditText(this.getSelectionText());
    }

    private String getSelectionText() {
        if (this.m_selectionIndex != -1 && this.isDroppedDown()) {
            Object itemData = this.m_table.getTable().getItem(this.m_selectionIndex).getData();
            return ((ComboBoxItem)itemData).m_label;
        }
        return null;
    }

    private Image getSelectionImage() {
        return this.m_selectionIndex != -1 ? this.m_items.get((int)this.m_selectionIndex).m_image : null;
    }

    public void setSelectionText(String label) {
        TableItem[] items = this.m_table.getTable().getItems();
        int i = 0;
        while (i < items.length) {
            TableItem item = items[i];
            if (item.getText().equals(label)) {
                this.setSelectionIndex(i);
                return;
            }
            ++i;
        }
        this.setSelectionIndex(-1);
        this.setEditText(label);
    }

    public void addSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error((int)4);
        }
        TypedListener typedListener = new TypedListener((SWTEventListener)listener);
        this.addListener(13, (Listener)typedListener);
        this.addListener(14, (Listener)typedListener);
    }

    public boolean isDroppedDown() {
        return this.m_popup.isVisible();
    }

    public void comboDropDown(boolean dropdown) {
        if (dropdown == this.isDroppedDown()) {
            return;
        }
        if (dropdown) {
            this.m_table.setInput(this.m_items);
            Table table = this.m_table.getTable();
            TableColumn column = table.getColumn(0);
            column.pack();
            table.pack();
            this.m_popup.pack();
            Rectangle tableBounds = table.getBounds();
            tableBounds.height = Math.min(tableBounds.height, table.getItemHeight() * 15);
            table.setBounds(tableBounds);
            Point comboLocation = this.toDisplay(new Point(0, 0));
            Point comboSize = this.getSize();
            Display display = this.getDisplay();
            Rectangle clientArea = display.getClientArea();
            int remainingDisplayHeight = clientArea.height - comboLocation.y - comboSize.y - 10;
            int preferredHeight = Math.min(tableBounds.height, remainingDisplayHeight);
            int remainingDisplayWidth = clientArea.width - comboLocation.x - 10;
            int preferredWidth = this.isFullDropdownTableWidth() ? Math.min(tableBounds.width, remainingDisplayWidth) : comboSize.x;
            Rectangle popupBounds = new Rectangle(comboLocation.x, comboLocation.y + comboSize.y, preferredWidth, preferredHeight);
            Rectangle trimBounds = this.m_popup.computeTrim(popupBounds.x, popupBounds.y, popupBounds.width, popupBounds.height);
            this.m_popup.setBounds(popupBounds.x, popupBounds.y, 2 * popupBounds.width - trimBounds.width, 2 * popupBounds.height - trimBounds.height);
            column.setWidth(table.getClientArea().width);
            this.m_popup.setVisible(true);
            table.setSelection(this.getSelectionIndex());
        } else {
            this.m_popup.setVisible(false);
        }
    }

    protected final void setFocus2Text(boolean selectAll) {
        this.getDisplay().asyncExec(new Runnable(selectAll){
            final boolean m_selectAll;
            {
                this.m_selectAll = bl;
            }

            @Override
            public void run() {
                if (!CComboBox.this.m_text.isDisposed()) {
                    CComboBox.this.m_text.setFocus();
                    if (this.m_selectAll) {
                        CComboBox.this.m_text.selectAll();
                    }
                }
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    protected static Event convert2event(TypedEvent tEvent) {
        TypedEvent typedEvent;
        Event event = new Event();
        event.widget = tEvent.widget;
        event.display = tEvent.display;
        event.widget = tEvent.widget;
        event.time = tEvent.time;
        event.data = tEvent.data;
        TypedEvent typedEvent2 = tEvent;
        if (typedEvent2 instanceof KeyEvent) {
            void kEvent;
            KeyEvent keyEvent = (KeyEvent)typedEvent2;
            KeyEvent cfr_ignored_0 = (KeyEvent)typedEvent2;
            event.character = kEvent.character;
            event.keyCode = kEvent.keyCode;
            event.stateMask = kEvent.stateMask;
            event.doit = kEvent.doit;
        }
        if ((typedEvent = tEvent) instanceof SelectionEvent) {
            void sEvent;
            SelectionEvent selectionEvent = (SelectionEvent)typedEvent;
            SelectionEvent cfr_ignored_1 = (SelectionEvent)typedEvent;
            event.item = sEvent.item;
            event.x = sEvent.x;
            event.y = sEvent.y;
            event.width = sEvent.width;
            event.height = sEvent.height;
            event.detail = sEvent.detail;
            event.stateMask = sEvent.stateMask;
            event.text = sEvent.text;
            event.doit = sEvent.doit;
        }
        return event;
    }

    protected static class ComboBoxItem {
        public final String m_label;
        public final Image m_image;

        public ComboBoxItem(String label, Image image) {
            this.m_label = label;
            this.m_image = image;
        }
    }
}

