/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.rcp.databinding.xwt.ui.providers;

import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.viewers.DecorationOverlayIcon;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.wb.internal.core.utils.execution.ExecutionUtils;
import org.eclipse.wb.internal.rcp.databinding.xwt.model.BindingInfo;

public class BindingLabelProvider
extends LabelProvider
implements ITableLabelProvider {
    private final ResourceManager m_resourceManager = new LocalResourceManager(JFaceResources.getResources());

    public String getColumnText(Object element, int column) {
        return BindingLabelProvider.getText(element, column);
    }

    public static String getText(Object element, int column) {
        return (String)ExecutionUtils.runObjectLog(() -> {
            BindingInfo binding = (BindingInfo)((Object)((Object)element));
            switch (column) {
                case 1: {
                    return binding.getTargetPresentationText();
                }
                case 2: {
                    return binding.getModelPresentationText();
                }
                case 3: {
                    return BindingInfo.MODES[binding.getMode()];
                }
            }
            return null;
        }, (Object)"<exception, see log>");
    }

    public Image getColumnImage(Object element, int column) {
        if (column == 0) {
            return this.m_resourceManager.createImageWithDefault(BindingLabelProvider.getIcon(element));
        }
        return null;
    }

    public static ImageDescriptor getIcon(Object element) {
        ImageDescriptor imageDescriptor = org.eclipse.wb.internal.rcp.databinding.ui.providers.BindingLabelProvider.BIND_VALUE_IMAGE;
        if (BindingLabelProvider.isDelayBinding(element)) {
            imageDescriptor = new DecorationOverlayIcon(imageDescriptor, org.eclipse.wb.internal.rcp.databinding.ui.providers.BindingLabelProvider.CLOCK_DECORATION_IMAGE, 3);
        }
        return imageDescriptor;
    }

    private static boolean isDelayBinding(Object element) {
        return false;
    }

    public void dispose() {
        super.dispose();
        this.m_resourceManager.dispose();
    }
}

