/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.cdt.ui;

import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.IElementChangedListener;
import org.eclipse.cdt.internal.ui.editor.CEditor;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.mylyn.context.core.AbstractContextListener;
import org.eclipse.mylyn.context.core.ContextCore;
import org.eclipse.mylyn.context.ui.IContextUiStartup;
import org.eclipse.mylyn.internal.cdt.ui.CDTEditorMonitor;
import org.eclipse.mylyn.internal.cdt.ui.InterestUpdateDeltaListener;
import org.eclipse.mylyn.internal.cdt.ui.LandmarkMarkerManager;
import org.eclipse.mylyn.internal.cdt.ui.Messages;
import org.eclipse.mylyn.internal.cdt.ui.contentassist.CDTContentAssistUtils;
import org.eclipse.mylyn.internal.cdt.ui.editor.ActiveFoldingEditorTracker;
import org.eclipse.mylyn.internal.cdt.ui.editor.ActiveFoldingListener;
import org.eclipse.mylyn.monitor.ui.MonitorUi;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.ui.progress.UIJob;
import org.osgi.framework.BundleContext;

public class CDTUIBridgePlugin
extends AbstractUIPlugin
implements IContextUiStartup {
    public static final String ID_PLUGIN = "org.eclipse.cdt.mylyn.ui";
    public static final String AUTO_FOLDING_ENABLED = "org.eclipse.mylyn.context.ui.editor.folding.enabled";
    private static final String MYLYN_RUN_COUNT = "org.eclipse.mylyn.cdt.ui.run.count.3_3_0";
    private static CDTUIBridgePlugin INSTANCE;
    private final LandmarkMarkerManager landmarkMarkerManager = new LandmarkMarkerManager();
    private CDTEditorMonitor cEditingMonitor;
    private final InterestUpdateDeltaListener cElementChangeListener = new InterestUpdateDeltaListener();
    private ActiveFoldingEditorTracker activeFoldingEditorTracker;

    public void start(BundleContext context) throws Exception {
        super.start(context);
        INSTANCE = this;
        this.initializeContentAssist();
    }

    public void lazyStartup() {
        this.installFoldingEditorTracker(PlatformUI.getWorkbench());
        ContextCore.getContextManager().addListener((AbstractContextListener)this.landmarkMarkerManager);
        this.cEditingMonitor = new CDTEditorMonitor();
        MonitorUi.getSelectionMonitors().add(this.cEditingMonitor);
        CoreModel.getDefault().addElementChangedListener((IElementChangedListener)this.cElementChangeListener);
    }

    private void lazyStop() {
        ContextCore.getContextManager().removeListener((AbstractContextListener)this.landmarkMarkerManager);
        MonitorUi.getSelectionMonitors().remove((Object)this.cEditingMonitor);
        CoreModel.getDefault().removeElementChangedListener((IElementChangedListener)this.cElementChangeListener);
        this.uninstallFoldingEditorTracker(PlatformUI.getWorkbench());
    }

    public void stop(BundleContext context) throws Exception {
        this.lazyStop();
        super.stop(context);
        INSTANCE = null;
    }

    private void initializeContentAssist() {
        int count = this.getPreferenceStore().getInt(MYLYN_RUN_COUNT);
        if (count < 1) {
            this.getPreferenceStore().setValue(MYLYN_RUN_COUNT, count + 1);
            new UIJob(Messages.CDTUIBridgePlugin_Initializing_Content_Assist){

                public IStatus runInUIThread(IProgressMonitor monitor) {
                    CDTContentAssistUtils.installContentAssist(CUIPlugin.getDefault().getPreferenceStore(), true);
                    return Status.OK_STATUS;
                }
            }.schedule();
        }
        CDTContentAssistUtils.updateDefaultPreference(CUIPlugin.getDefault().getPreferenceStore());
    }

    private void uninstallFoldingEditorTracker(IWorkbench workbench) {
        if (this.activeFoldingEditorTracker != null) {
            this.activeFoldingEditorTracker.dispose(workbench);
            this.activeFoldingEditorTracker = null;
        }
    }

    /*
     * WARNING - void declaration
     */
    private void installFoldingEditorTracker(IWorkbench workbench) {
        this.activeFoldingEditorTracker = new ActiveFoldingEditorTracker();
        this.activeFoldingEditorTracker.install(workbench);
        IWorkbenchWindow[] iWorkbenchWindowArray = PlatformUI.getWorkbench().getWorkbenchWindows();
        int n = iWorkbenchWindowArray.length;
        int n2 = 0;
        while (n2 < n) {
            IWorkbenchWindow w = iWorkbenchWindowArray[n2];
            IWorkbenchPage page = w.getActivePage();
            if (page != null) {
                IEditorReference[] references;
                IEditorReference[] iEditorReferenceArray = references = page.getEditorReferences();
                int n3 = references.length;
                int n4 = 0;
                while (n4 < n3) {
                    IEditorPart iEditorPart;
                    IEditorReference reference = iEditorReferenceArray[n4];
                    IEditorPart part = reference.getEditor(false);
                    if (part != null && (iEditorPart = part) instanceof CEditor) {
                        void editor;
                        CEditor cfr_ignored_0 = (CEditor)iEditorPart;
                        CEditor cfr_ignored_1 = (CEditor)iEditorPart;
                        this.activeFoldingEditorTracker.registerEditor((CEditor)editor);
                        ActiveFoldingListener.resetProjection((CEditor)editor);
                    }
                    ++n4;
                }
            }
            ++n2;
        }
    }

    public static CDTUIBridgePlugin getDefault() {
        return INSTANCE;
    }
}

