/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.includebrowser;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashSet;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.index.IIndex;
import org.eclipse.cdt.core.index.IIndexFile;
import org.eclipse.cdt.core.index.IIndexFileLocation;
import org.eclipse.cdt.core.index.IIndexInclude;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.internal.ui.includebrowser.IBFile;
import org.eclipse.cdt.internal.ui.includebrowser.IBNode;
import org.eclipse.cdt.internal.ui.viewsupport.AsyncTreeContentProvider;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.swt.widgets.Display;

public class IBContentProvider
extends AsyncTreeContentProvider {
    private static final IProgressMonitor NPM = new NullProgressMonitor();
    private boolean fComputeIncludedBy = true;

    public IBContentProvider(Display disp) {
        super(disp);
    }

    @Override
    public Object getParent(Object element) {
        if (element instanceof IBNode) {
            IBNode node = (IBNode)element;
            return node.getParent();
        }
        return super.getParent(element);
    }

    @Override
    protected Object[] syncronouslyComputeChildren(Object parentElement) {
        IBNode node;
        if (parentElement instanceof ITranslationUnit) {
            ITranslationUnit tu = (ITranslationUnit)parentElement;
            return new Object[]{new IBNode(null, new IBFile(tu), null, 0, 0, 0L)};
        }
        if (parentElement instanceof IBNode && ((node = (IBNode)parentElement).isRecursive() || node.getRepresentedIFL() == null)) {
            return NO_CHILDREN;
        }
        return null;
    }

    @Override
    protected Object[] asyncronouslyComputeChildren(Object parentElement, IProgressMonitor monitor) {
        block16: {
            if (parentElement instanceof IBNode) {
                IIndex index;
                IBNode node = (IBNode)parentElement;
                IIndexFileLocation ifl = node.getRepresentedIFL();
                ICProject project = node.getCProject();
                if (ifl == null) {
                    return NO_CHILDREN;
                }
                try {
                    ICProject[] scope = CoreModel.getDefault().getCModel().getCProjects();
                    index = CCorePlugin.getIndexManager().getIndex(scope, 256);
                    index.acquireReadLock();
                }
                catch (CoreException e) {
                    CUIPlugin.log(e);
                    return NO_CHILDREN;
                }
                catch (InterruptedException e) {
                    return NO_CHILDREN;
                }
                try {
                    IIndexInclude[] includes;
                    IBFile directiveFile = null;
                    IBFile targetFile = null;
                    if (this.fComputeIncludedBy) {
                        includes = this.findIncludedBy(index, ifl, NPM);
                    } else {
                        includes = this.findIncludesTo(index, ifl, NPM);
                        directiveFile = node.getRepresentedFile();
                    }
                    if (includes.length <= 0) break block16;
                    LinkedHashSet<IBNode> result = new LinkedHashSet<IBNode>(includes.length);
                    IIndexInclude[] iIndexIncludeArray = includes;
                    int n = includes.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IIndexInclude include = iIndexIncludeArray[n2];
                        try {
                            if (this.fComputeIncludedBy) {
                                directiveFile = targetFile = new IBFile(project, include.getIncludedByLocation());
                            } else {
                                IIndexFileLocation includesPath = include.getIncludesLocation();
                                targetFile = includesPath == null ? new IBFile(include.getFullName()) : new IBFile(project, includesPath);
                            }
                            IBNode newnode = new IBNode(node, targetFile, directiveFile, include.getNameOffset(), include.getNameLength(), include.getIncludedBy().getTimestamp());
                            newnode.setIsActiveCode(include.isActive());
                            newnode.setIsSystemInclude(include.isSystemInclude());
                            if (!result.contains(newnode) || newnode.isActiveCode()) {
                                result.add(newnode);
                            }
                        }
                        catch (CoreException e) {
                            CUIPlugin.log(e);
                        }
                        ++n2;
                    }
                    Object[] objectArray = result.toArray();
                    return objectArray;
                }
                finally {
                    index.releaseReadLock();
                }
            }
        }
        return NO_CHILDREN;
    }

    public void setComputeIncludedBy(boolean value) {
        this.fComputeIncludedBy = value;
    }

    public boolean getComputeIncludedBy() {
        return this.fComputeIncludedBy;
    }

    private IIndexInclude[] findIncludedBy(IIndex index, IIndexFileLocation ifl, IProgressMonitor pm) {
        try {
            if (ifl != null) {
                IIndexFile[] files = index.getFiles(ifl);
                if (files.length == 1) {
                    return index.findIncludedBy(files[0]);
                }
                if (files.length > 0) {
                    ArrayList<IIndexInclude> list = new ArrayList<IIndexInclude>();
                    HashSet<IIndexFileLocation> handled = new HashSet<IIndexFileLocation>();
                    IIndexFile[] iIndexFileArray = files;
                    int n = files.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IIndexInclude[] includes;
                        IIndexFile file = iIndexFileArray[n2];
                        IIndexInclude[] iIndexIncludeArray = includes = index.findIncludedBy(file);
                        int n3 = includes.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            IIndexInclude indexInclude = iIndexIncludeArray[n4];
                            if (handled.add(indexInclude.getIncludedByLocation())) {
                                list.add(indexInclude);
                            }
                            ++n4;
                        }
                        ++n2;
                    }
                    return list.toArray(new IIndexInclude[list.size()]);
                }
            }
        }
        catch (CoreException e) {
            CUIPlugin.log(e);
        }
        return IIndexInclude.EMPTY_INCLUDES_ARRAY;
    }

    public IIndexInclude[] findIncludesTo(IIndex index, IIndexFileLocation ifl, IProgressMonitor pm) {
        try {
            if (ifl != null) {
                IIndexFile[] files = index.getFiles(ifl);
                if (files.length == 1) {
                    return index.findIncludes(files[0]);
                }
                if (files.length > 0) {
                    ArrayList<IIndexInclude> list = new ArrayList<IIndexInclude>();
                    HashSet<IIndexFileLocation> handled = new HashSet<IIndexFileLocation>();
                    IIndexFile[] iIndexFileArray = files;
                    int n = files.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IIndexInclude[] includes;
                        IIndexFile file = iIndexFileArray[n2];
                        IIndexInclude[] iIndexIncludeArray = includes = index.findIncludes(file);
                        int n3 = includes.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            IIndexInclude indexInclude = iIndexIncludeArray[n4];
                            if (handled.add(indexInclude.getIncludesLocation())) {
                                list.add(indexInclude);
                            }
                            ++n4;
                        }
                        ++n2;
                    }
                    return list.toArray(new IIndexInclude[list.size()]);
                }
            }
        }
        catch (CoreException e) {
            CUIPlugin.log(e);
        }
        return IIndexInclude.EMPTY_INCLUDES_ARRAY;
    }
}

