/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.validators.internal.externalchecker.core;

import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.dltk.core.environment.IEnvironment;
import org.eclipse.dltk.validators.core.IValidatorOutput;
import org.eclipse.dltk.validators.core.IValidatorReporter;
import org.eclipse.dltk.validators.core.ResourceValidatorWorker;
import org.eclipse.dltk.validators.internal.externalchecker.core.ExternalChecker;
import org.eclipse.dltk.validators.internal.externalchecker.core.ExternalCheckerDelegate;
import org.eclipse.dltk.validators.internal.externalchecker.core.Messages;

public class ExternalResourceWorker
extends ResourceValidatorWorker {
    private ExternalCheckerDelegate delegate;

    public ExternalResourceWorker(IEnvironment environment, ExternalChecker externalChecker) {
        this.delegate = new ExternalCheckerDelegate(environment, externalChecker);
    }

    protected boolean isValidResource(IResource resource) {
        return this.delegate.isValidExtension(resource.getFileExtension());
    }

    protected void runValidator(IResource resource, IValidatorOutput console, IValidatorReporter reporter, IProgressMonitor monitor) throws CoreException {
        this.delegate.runValidator(resource, console, problem -> {
            IMarker iMarker = reporter.report(resource, problem);
        });
    }

    protected IValidatorReporter createValidatorReporter() {
        return this.delegate.createValidatorReporter();
    }

    protected String getTaskName() {
        return Messages.ExternalChecker_checkingWithExternalExecutable;
    }

    protected String getMarkerId() {
        return this.delegate.getMarkerId();
    }

    protected String getNullResourceMessage() {
        return Messages.ExternalChecker_resourceIsNull;
    }

    protected String getPluginId() {
        return "org.eclipse.dltk.validators.externalchecker";
    }
}

