/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.astview.views;

import java.util.List;
import org.eclipse.jdt.astview.views.ASTAttribute;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.StructuralPropertyDescriptor;
import org.eclipse.swt.graphics.Image;

public class NodeProperty
extends ASTAttribute {
    private ASTNode fParent;
    private StructuralPropertyDescriptor fProperty;

    public NodeProperty(ASTNode parent, StructuralPropertyDescriptor property) {
        this.fParent = parent;
        this.fProperty = property;
    }

    @Override
    public Object getParent() {
        return this.fParent;
    }

    @Override
    public Object[] getChildren() {
        Object child = this.getNode();
        if (child instanceof List) {
            return ((List)child).toArray();
        }
        if (child instanceof ASTNode) {
            return new Object[]{child};
        }
        return EMPTY;
    }

    @Override
    public String getLabel() {
        StringBuilder buf = new StringBuilder();
        buf.append(this.getPropertyName());
        if (this.fProperty.isSimpleProperty()) {
            buf.append(": ");
            Object node = this.getNode();
            if (node != null) {
                buf.append('\'');
                buf.append(this.getNode().toString());
                buf.append('\'');
            } else {
                buf.append("null");
            }
        } else if (this.fProperty.isChildListProperty()) {
            List node = (List)this.getNode();
            buf.append(" (").append(node.size()).append(')');
        } else if (this.getNode() == null) {
            buf.append(": null");
        }
        return buf.toString();
    }

    @Override
    public Image getImage() {
        return null;
    }

    public Object getNode() {
        return this.fParent.getStructuralProperty(this.fProperty);
    }

    public String getPropertyName() {
        return NodeProperty.toConstantName(this.fProperty.getId());
    }

    private static String toConstantName(String string) {
        StringBuilder buf = new StringBuilder();
        int i = 0;
        while (i < string.length()) {
            char ch = string.charAt(i);
            if (i != 0 && Character.isUpperCase(ch)) {
                buf.append('_');
            }
            buf.append(Character.toUpperCase(ch));
            ++i;
        }
        return buf.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !o.getClass().equals(this.getClass())) {
            return false;
        }
        NodeProperty castedObj = (NodeProperty)o;
        return this.fParent.equals((Object)castedObj.fParent) && this.fProperty == castedObj.fProperty;
    }

    public int hashCode() {
        return this.fParent.hashCode() * 31 + this.fProperty.hashCode();
    }

    public String toString() {
        return this.getLabel();
    }
}

