/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.javadocs.ui;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.filesystem.IFileSystem;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.help.IToc;
import org.eclipse.help.ITopic;
import org.eclipse.help.IUAElement;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.linuxtools.internal.javadocs.ui.JavaDocPlugin;
import org.eclipse.linuxtools.internal.javadocs.ui.JavaDocTopic;

public class JavaDocToc
implements IToc {
    public String getLabel() {
        return "Javadoc documents";
    }

    public String getHref() {
        return "org.eclipse.linuxtools.javadocs/";
    }

    public boolean isEnabled(IEvaluationContext context) {
        return true;
    }

    public IUAElement[] getChildren() {
        return this.getTopics();
    }

    public ITopic[] getTopics() {
        try {
            ArrayList<JavaDocTopic> topics = new ArrayList<JavaDocTopic>();
            IPreferenceStore ps = JavaDocPlugin.getDefault().getPreferenceStore();
            Path javadocLocation = new Path(ps.getString("org.eclipse.linuxtools.javadocs.directory"));
            IFileSystem fs = EFS.getLocalFileSystem();
            IFileStore htmlDir = fs.getStore((IPath)javadocLocation);
            IFileStore[] files = htmlDir.childStores(0, null);
            Arrays.sort(files, new Comparator<IFileStore>(){

                @Override
                public int compare(IFileStore arg0, IFileStore arg1) {
                    return arg0.getName().compareToIgnoreCase(arg1.getName());
                }
            });
            for (IFileStore file : files) {
                String name = file.fetchInfo().getName();
                if (!fs.getStore(javadocLocation.append(name)).fetchInfo().exists() || !fs.getStore(javadocLocation.append(name + "/index.html")).fetchInfo().exists()) continue;
                JavaDocTopic topic = new JavaDocTopic(name);
                topics.add(topic);
            }
            ITopic[] retval = new ITopic[topics.size()];
            return topics.toArray(retval);
        }
        catch (CoreException coreException) {
            return null;
        }
    }

    public ITopic getTopic(String href) {
        ITopic[] topicList;
        if (href == null) {
            return null;
        }
        for (ITopic iTopic : topicList = this.getTopics()) {
            if (!iTopic.getHref().equals(href.substring(1)) && !iTopic.getHref().equals(href)) continue;
            return iTopic;
        }
        return null;
    }
}

