/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.core.ui.internal.preferences;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.apache.maven.building.Problem;
import org.apache.maven.cli.MavenCli;
import org.apache.maven.cli.configuration.SettingsXmlConfigurationProcessor;
import org.apache.maven.repository.RepositorySystem;
import org.apache.maven.settings.Settings;
import org.apache.maven.settings.building.SettingsProblem;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.m2e.core.MavenPlugin;
import org.eclipse.m2e.core.embedder.IComponentLookup;
import org.eclipse.m2e.core.embedder.IMaven;
import org.eclipse.m2e.core.embedder.IMavenConfiguration;
import org.eclipse.m2e.core.internal.IMavenToolbox;
import org.eclipse.m2e.core.project.IMavenProjectFacade;
import org.eclipse.m2e.core.project.MavenUpdateRequest;
import org.eclipse.m2e.core.ui.internal.Messages;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.FileStoreEditorInput;
import org.eclipse.ui.ide.IDE;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MavenSettingsPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private static final Logger log = LoggerFactory.getLogger(MavenSettingsPreferencePage.class);
    final IMavenConfiguration mavenConfiguration;
    final IMaven maven;
    Text globalSettingsText;
    Text userSettingsText;
    Text localRepositoryText;
    boolean dirty = false;
    private Link globalSettingsLink;
    private Link userSettingsLink;
    private Link userToolchainsLink;
    private Text userToolchainsText;

    public MavenSettingsPreferencePage() {
        this.setTitle(Messages.MavenSettingsPreferencePage_title);
        this.mavenConfiguration = MavenPlugin.getMavenConfiguration();
        this.maven = MavenPlugin.getMaven();
    }

    public void init(IWorkbench workbench) {
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.updateLocalRepository();
        }
    }

    protected void updateSettings(boolean updateMavenDependencies) {
        List projects;
        this.updateLocalRepository();
        String userSettings = this.getUserSettings();
        String userToolchains = this.getUserToolchains();
        String globalSettings = this.getGlobalSettings();
        if (Objects.equals(globalSettings, this.mavenConfiguration.getGlobalSettingsFile()) && Objects.equals(userSettings, this.mavenConfiguration.getUserSettingsFile()) && Objects.equals(userToolchains, this.mavenConfiguration.getUserToolchainsFile())) {
            return;
        }
        Boolean[] updateProjects = new Boolean[]{updateMavenDependencies};
        if (updateMavenDependencies && (projects = MavenPlugin.getMavenProjectRegistry().getProjects()) != null && !projects.isEmpty()) {
            updateProjects[0] = MessageDialog.openQuestion((Shell)this.getShell(), (String)Messages.MavenPreferencePage_updateProjectRequired_title, (String)Messages.MavenProjectPreferencePage_dialog_message);
        }
        Job.create((String)Messages.MavenSettingsPreferencePage_job_updating, monitor -> {
            try {
                List projects;
                this.mavenConfiguration.setGlobalSettingsFile(globalSettings);
                this.mavenConfiguration.setUserSettingsFile(userSettings);
                this.mavenConfiguration.setUserToolchainsFile(userToolchains);
                if (Boolean.TRUE.equals(updateProjects[0]) && (projects = MavenPlugin.getMavenProjectRegistry().getProjects()) != null && !projects.isEmpty()) {
                    MavenPlugin.getMaven().reloadSettings();
                    ArrayList<IProject> allProjects = new ArrayList<IProject>();
                    SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)projects.size());
                    for (IMavenProjectFacade project : projects) {
                        subMonitor.split(1).beginTask(NLS.bind((String)Messages.MavenSettingsPreferencePage_task_updating, (Object)project.getProject().getName()), 1);
                        allProjects.add(project.getProject());
                    }
                    MavenPlugin.getMavenProjectRegistry().refresh(new MavenUpdateRequest(allProjects, this.mavenConfiguration.isOffline(), true));
                    subMonitor.done();
                }
                return Status.OK_STATUS;
            }
            catch (CoreException e) {
                log.error(e.getMessage(), (Throwable)e);
                return e.getStatus();
            }
        }).schedule();
    }

    protected void performDefaults() {
        this.globalSettingsText.setText("");
        this.userSettingsText.setText("");
        this.checkSettings();
        this.updateLocalRepository();
        super.performDefaults();
    }

    public boolean performOk() {
        this.updateSettings(true);
        return true;
    }

    protected Control createContents(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(2, false));
        this.globalSettingsLink = this.createLink(composite, Messages.MavenSettingsPreferencePage_globalSettingslink2, Messages.MavenSettingsPreferencePage_globalSettingslink_tooltip, this::getGlobalSettings, null);
        this.globalSettingsText = this.createFileSelectionWidgets(composite, this.mavenConfiguration.getGlobalSettingsFile(), null);
        this.userSettingsLink = this.createLink(composite, Messages.MavenSettingsPreferencePage_userSettingslink2, Messages.MavenSettingsPreferencePage_userSettingslink_tooltip, this::getUserSettings, SettingsXmlConfigurationProcessor.DEFAULT_USER_SETTINGS_FILE);
        this.userSettingsText = this.createFileSelectionWidgets(composite, this.mavenConfiguration.getUserSettingsFile(), SettingsXmlConfigurationProcessor.DEFAULT_USER_SETTINGS_FILE);
        this.userToolchainsLink = this.createLink(composite, Messages.MavenSettingsPreferencePage_userToolchainslink2, Messages.MavenSettingsPreferencePage_userToolchainslink_tooltip, this::getUserToolchains, MavenCli.DEFAULT_USER_TOOLCHAINS_FILE);
        this.userToolchainsText = this.createFileSelectionWidgets(composite, this.mavenConfiguration.getUserToolchainsFile(), MavenCli.DEFAULT_USER_TOOLCHAINS_FILE);
        Button updateSettings = new Button(composite, 0);
        updateSettings.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 2, 1));
        updateSettings.setText(Messages.MavenSettingsPreferencePage_btnUpdate);
        updateSettings.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> this.updateSettings(true)));
        Label localRepositoryLabel = new Label(composite, 0);
        GridData gd = new GridData(4, 0x1000000, true, false, 2, 1);
        gd.verticalIndent = 25;
        localRepositoryLabel.setLayoutData((Object)gd);
        localRepositoryLabel.setText(Messages.MavenSettingsPreferencePage_lblLocal);
        this.localRepositoryText = new Text(composite, 2056);
        this.localRepositoryText.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.localRepositoryText.setData("name", (Object)"localRepositoryText");
        this.localRepositoryText.setEditable(false);
        this.checkSettings();
        this.updateLocalRepository();
        return composite;
    }

    private Link createLink(Composite composite, String text, String tooltip, Supplier<String> selectedFile, File defaultFile) {
        Link link = new Link(composite, 0);
        link.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        link.setText(text);
        link.setToolTipText(tooltip);
        link.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            File file2 = Optional.ofNullable((String)selectedFile.get()).map(File::new).orElse(defaultFile);
            if (file2 != null) {
                this.openEditor(file2);
            }
        }));
        return link;
    }

    private Text createFileSelectionWidgets(Composite composite, String selectedFile, File defaultFile) {
        Text fileText = new Text(composite, 2048);
        fileText.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        if (defaultFile != null) {
            fileText.setMessage(defaultFile.getAbsolutePath());
        }
        if (selectedFile != null) {
            fileText.setText(selectedFile);
        }
        fileText.addModifyListener(modifyevent -> {
            this.updateLocalRepository();
            this.checkSettings();
        });
        Button browseButton = new Button(composite, 0);
        browseButton.setLayoutData((Object)new GridData(4, 131072, false, false, 1, 1));
        browseButton.setText(Messages.MavenSettingsPreferencePage_settingsBrowseButton_text);
        browseButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> this.browseSettingsAction(fileText)));
        return fileText;
    }

    private void updateLink(Link link, String path, File defaultFile, String activeText, String inactiveText) {
        File file = path != null ? new File(path) : defaultFile;
        boolean active = file != null && file.canRead();
        link.setText(active ? activeText : inactiveText);
    }

    protected void updateLocalRepository() {
        String globalSettings = this.getGlobalSettings();
        String userSettings = this.getUserSettings();
        try {
            Settings settings = this.maven.buildSettings(globalSettings, userSettings);
            String localRepository = settings.getLocalRepository();
            if (localRepository == null) {
                localRepository = RepositorySystem.defaultUserLocalRepository.getAbsolutePath();
            }
            if (!this.localRepositoryText.isDisposed()) {
                this.localRepositoryText.setText(localRepository == null ? "" : localRepository);
            }
        }
        catch (CoreException e) {
            this.setMessage(e.getMessage(), 3);
        }
    }

    protected void checkSettings() {
        this.setErrorMessage(null);
        this.setMessage(null);
        String globalSettings = this.getGlobalSettings();
        this.updateLink(this.globalSettingsLink, globalSettings, null, Messages.MavenSettingsPreferencePage_globalSettingslink2, Messages.MavenSettingsPreferencePage_globalSettingslink1);
        String userSettings = this.getUserSettings();
        this.updateLink(this.userSettingsLink, userSettings, SettingsXmlConfigurationProcessor.DEFAULT_USER_SETTINGS_FILE, Messages.MavenSettingsPreferencePage_userSettingslink2, Messages.MavenSettingsPreferencePage_userSettingslink1);
        String userToolchains = this.getUserToolchains();
        this.updateLink(this.userToolchainsLink, userToolchains, MavenCli.DEFAULT_USER_TOOLCHAINS_FILE, Messages.MavenSettingsPreferencePage_userToolchainslink2, Messages.MavenSettingsPreferencePage_userToolchainslink1);
        this.setMessage(null);
        this.checkSettings(globalSettings, Messages.MavenSettingsPreferencePage_error_globalSettingsMissing, l -> this.maven.validateSettings(l).stream().map(SettingsProblem::getMessage), Messages.MavenSettingsPreferencePage_error_globalSettingsParse);
        this.checkSettings(userSettings, Messages.MavenSettingsPreferencePage_error_userSettingsMissing, l -> this.maven.validateSettings(l).stream().map(SettingsProblem::getMessage), Messages.MavenSettingsPreferencePage_error_userSettingsParse);
        this.checkSettings(userToolchains, Messages.MavenSettingsPreferencePage_error_userToolchainsMissing, l -> IMavenToolbox.of((IComponentLookup)this.maven).validateToolchains(l).stream().map(Problem::getMessage), Messages.MavenSettingsPreferencePage_error_userToolchainsParse);
    }

    private void checkSettings(String location, String errorMissing, Function<String, Stream<String>> validator, String errorParse) {
        if (location != null) {
            String newMessage;
            String string = newMessage = !new File(location).canRead() ? errorMissing : (String)validator.apply(location).findFirst().map(msg -> NLS.bind((String)errorParse, (Object)msg)).orElse(null);
            if (newMessage != null) {
                String prefix = this.getMessage() != null ? String.valueOf(this.getMessage()) + " and " : "";
                this.setMessage(String.valueOf(prefix) + newMessage, 2);
            }
        }
    }

    void openEditor(File file) {
        IWorkbench workbench = PlatformUI.getWorkbench();
        IWorkbenchWindow window = workbench.getActiveWorkbenchWindow();
        IWorkbenchPage page = window.getActivePage();
        IEditorDescriptor desc = workbench.getEditorRegistry().getDefaultEditor("settings.xml");
        FileStoreEditorInput input = new FileStoreEditorInput(EFS.getLocalFileSystem().fromLocalFile(file));
        try {
            IEditorPart editor = IDE.openEditor((IWorkbenchPage)page, (IEditorInput)input, (String)desc.getId());
            if (editor == null) {
                return;
            }
            editor.addPropertyListener((source, propId) -> {
                if (!editor.isDirty()) {
                    log.info("Refreshing settings {}", (Object)file);
                }
            });
        }
        catch (PartInitException ex) {
            log.error(ex.getMessage(), (Throwable)ex);
        }
    }

    private String getUserSettings() {
        return this.getSettings(this.userSettingsText);
    }

    private String getUserToolchains() {
        return this.getSettings(this.userToolchainsText);
    }

    private String getGlobalSettings() {
        return this.getSettings(this.globalSettingsText);
    }

    private String getSettings(Text settings) {
        String location = settings.getText().trim();
        return location.length() > 0 ? location : null;
    }

    protected void browseSettingsAction(Text settings) {
        String file;
        FileDialog dialog = new FileDialog(this.getShell(), 4096);
        if (settings.getText().trim().length() > 0) {
            dialog.setFileName(settings.getText());
        }
        if ((file = dialog.open()) != null && !file.isBlank()) {
            settings.setText(file.strip());
            this.updateLocalRepository();
            this.checkSettings();
        }
    }
}

