/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.editor.pom;

import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.maven.model.io.xpp3.MavenXpp3Writer;
import org.apache.maven.project.MavenProject;
import org.eclipse.aether.graph.DependencyNode;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.m2e.core.MavenPlugin;
import org.eclipse.m2e.core.embedder.ArtifactKey;
import org.eclipse.m2e.core.internal.MavenPluginActivator;
import org.eclipse.m2e.core.internal.jobs.MavenJob;
import org.eclipse.m2e.core.project.IMavenProjectChangedListener;
import org.eclipse.m2e.core.project.IMavenProjectFacade;
import org.eclipse.m2e.core.project.IMavenProjectRegistry;
import org.eclipse.m2e.core.project.MavenProjectChangedEvent;
import org.eclipse.m2e.core.ui.internal.M2EUIPluginActivator;
import org.eclipse.m2e.core.ui.internal.actions.SelectionUtil;
import org.eclipse.m2e.core.ui.internal.actions.StaticMavenStorageEditorInput;
import org.eclipse.m2e.editor.MavenEditorPlugin;
import org.eclipse.m2e.editor.internal.Messages;
import org.eclipse.m2e.editor.pom.DependenciesPage;
import org.eclipse.m2e.editor.pom.DependencyTreePage;
import org.eclipse.m2e.editor.pom.IPomFileChangedListener;
import org.eclipse.m2e.editor.pom.MavenPomEditorContributor;
import org.eclipse.m2e.editor.pom.MavenPomEditorPage;
import org.eclipse.m2e.editor.pom.MavenPomEditorPageFactory;
import org.eclipse.m2e.editor.pom.OverviewPage;
import org.eclipse.search.ui.text.ISearchEditorAccess;
import org.eclipse.search.ui.text.Match;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorActionBarContributor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IPartService;
import org.eclipse.ui.IShowEditorInput;
import org.eclipse.ui.IWindowListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.editors.text.TextFileDocumentProvider;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.IFormPage;
import org.eclipse.ui.ide.IGotoMarker;
import org.eclipse.ui.internal.genericeditor.ExtensionBasedTextEditor;
import org.eclipse.ui.part.MultiPageEditorActionBarContributor;
import org.eclipse.ui.part.MultiPageEditorPart;
import org.eclipse.ui.part.MultiPageEditorSite;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.IElementStateListener;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.core.internal.util.DocumentInputStream;
import org.eclipse.wst.xml.core.internal.emf2xml.EMF2DOMSSEAdapter;
import org.eclipse.wst.xml.core.internal.provisional.contenttype.ContentTypeIdForXML;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMElement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Node;

public class MavenPomEditor
extends FormEditor
implements IResourceChangeListener,
IShowEditorInput,
IGotoMarker,
ISearchEditorAccess,
IMavenProjectChangedListener {
    private static final Logger log = LoggerFactory.getLogger(MavenPomEditor.class);
    public static final String POM_XML = "pom.xml";
    public static final String EDITOR_ID = "org.eclipse.m2e.editor.MavenPomEditor";
    private static final String EXTENSION_FACTORIES = "org.eclipse.m2e.editor.pageFactories";
    private static final String ELEMENT_PAGE = "factory";
    public static final String EFFECTIVE_POM = Messages.MavenPomEditor_effective_pom;
    OverviewPage overviewPage;
    DependenciesPage dependenciesPage;
    DependencyTreePage dependencyTreePage;
    ITextEditor sourcePage;
    ITextEditor effectivePomSourcePage;
    private final List<MavenPomEditorPage> mavenpomEditorPages = new ArrayList<MavenPomEditorPage>();
    private final Map<String, DependencyNode> rootNodes = new HashMap<String, DependencyNode>();
    IStructuredModel structuredModel;
    private MavenProject mavenProject;
    private int sourcePageIndex;
    IModelManager modelManager;
    IFile pomFile;
    MavenPomActivationListener activationListener;
    List<IPomFileChangedListener> fileChangeListeners = new ArrayList<IPomFileChangedListener>();
    private boolean resourceChangeEventSkip = false;
    private StaticMavenStorageEditorInput effectivePomEditorInput;
    private boolean disposed = false;
    private IDocumentListener documentListener;
    private IDocument sourceDocument;
    private boolean checkedWritableStatus;
    private boolean readOnly;
    private IDocumentProvider documentProvider;
    private IElementStateListener closeEditorOnDocumentDeletion;

    public MavenPomEditor() {
        this.modelManager = StructuredModelManager.getModelManager();
    }

    public IDocument getDocument() {
        if (this.structuredModel == null) {
            return null;
        }
        return this.structuredModel.getStructuredDocument();
    }

    public IStructuredModel getModel() {
        return this.structuredModel;
    }

    public void resourceChanged(IResourceChangeEvent event) {
        Object visitor;
        if (this.pomFile == null) {
            return;
        }
        if (event.getType() == 2 || event.getType() == 4) {
            this.pomFile.getProject().equals((Object)event.getResource());
            return;
        }
        try {
            class RemovedResourceDeltaVisitor
            implements IResourceDeltaVisitor {
                boolean removed = false;

                RemovedResourceDeltaVisitor() {
                }

                public boolean visit(IResourceDelta delta) {
                    if (delta.getResource() == MavenPomEditor.this.pomFile && (delta.getKind() & 2) != 0) {
                        this.removed = true;
                        return false;
                    }
                    return true;
                }
            }
            visitor = new RemovedResourceDeltaVisitor();
            event.getDelta().accept((IResourceDeltaVisitor)visitor);
            if (visitor.removed) {
                Display.getDefault().asyncExec(() -> this.close(true));
            }
        }
        catch (CoreException ex) {
            log.error(ex.getMessage(), (Throwable)ex);
        }
        try {
            class ChangedResourceDeltaVisitor
            implements IResourceDeltaVisitor {
                ChangedResourceDeltaVisitor() {
                }

                public boolean visit(IResourceDelta delta) {
                    if (delta.getResource().equals((Object)MavenPomEditor.this.pomFile) && (delta.getKind() & 4) != 0 && delta.getResource().exists()) {
                        int flags = delta.getFlags();
                        if ((flags & 0x100) != 0 || (flags & 0x40000) != 0) {
                            this.handleContentChanged();
                            return false;
                        }
                        if ((flags & 0x20000) != 0) {
                            this.handleMarkersChanged();
                            return false;
                        }
                    }
                    return true;
                }

                private void handleContentChanged() {
                    MavenPomEditor.this.reloadMavenProjectCache();
                    if (!MavenPomEditor.this.resourceChangeEventSkip) {
                        Display.getDefault().asyncExec(() -> MavenPomEditor.this.reload());
                    }
                }

                private void handleMarkersChanged() {
                    try {
                        String msg;
                        IMarker[] markers = MavenPomEditor.this.pomFile.findMarkers("org.eclipse.m2e.core.maven2Problem", true, 0);
                        String string = msg = markers != null && markers.length > 0 ? markers[0].getAttribute("message", "Unknown error") : null;
                        int severity = markers != null && markers.length > 0 ? (markers[0].getAttribute("severity", 2) == 1 ? 2 : 3) : 0;
                        Display.getDefault().asyncExec(() -> {
                            for (MavenPomEditorPage page : MavenPomEditor.this.getMavenPomEditorPages()) {
                                page.setErrorMessage(msg, msg == null ? 0 : severity);
                            }
                        });
                    }
                    catch (CoreException ex) {
                        log.error("Error updating pom file markers.", (Throwable)ex);
                    }
                }
            }
            visitor = new ChangedResourceDeltaVisitor();
            event.getDelta().accept((IResourceDeltaVisitor)visitor);
        }
        catch (CoreException ex) {
            log.error(ex.getMessage(), (Throwable)ex);
        }
    }

    public void reload() {
        int active = this.getActivePage();
        if (active > -1 && active < this.getMavenPomEditorPages().size()) {
            MavenPomEditorPage page = this.getMavenPomEditorPages().get(active);
            page.loadData();
        }
        if (this.isEffectiveActive()) {
            this.loadEffectivePOM();
        }
    }

    private boolean isEffectiveActive() {
        int active = this.getActivePage();
        if (active < 0) {
            return false;
        }
        String name = this.getPageText(active);
        return EFFECTIVE_POM.equals(name);
    }

    protected void addPages() {
        this.overviewPage = new OverviewPage(this);
        this.addPomPage((IFormPage)this.overviewPage);
        this.dependenciesPage = new DependenciesPage(this);
        this.addPomPage((IFormPage)this.dependenciesPage);
        this.dependencyTreePage = new DependencyTreePage(this);
        this.addPomPage((IFormPage)this.dependencyTreePage);
        this.addEditorPageExtensions();
        this.addFallbackEditors();
        this.setModel();
        this.addDocumentListener();
        this.selectActivePage();
    }

    private void addFallbackEditors() {
        if (this.effectivePomSourcePage == null) {
            this.effectivePomSourcePage = new ExtensionBasedTextEditor();
            try {
                int effectPomIndex = this.addPage((IEditorPart)this.effectivePomSourcePage, this.getEffectivePomEditorInput());
                this.setPageText(effectPomIndex, EFFECTIVE_POM);
                this.setEffectivePomSourcePage(this.effectivePomSourcePage);
            }
            catch (PartInitException ex) {
                log.error(ex.getMessage(), (Throwable)ex);
            }
        }
        if (this.sourcePage == null) {
            this.sourcePage = new ExtensionBasedTextEditor();
            try {
                int dex = this.addPage((IEditorPart)this.sourcePage, this.getEditorInput());
                this.setPageText(dex, POM_XML);
                this.setSourcePage(this.sourcePage);
                this.initializeSourceDocument();
            }
            catch (PartInitException ex) {
                log.error(ex.getMessage(), (Throwable)ex);
            }
        }
    }

    private void setModel() {
        if (this.sourceDocument == null) {
            this.initializeSourceDocument();
        }
        if (this.sourceDocument instanceof IStructuredDocument var1_2) {
            this.structuredModel = this.modelManager.getModelForEdit((IStructuredDocument)structuredSelection);
        } else {
            try {
                Throwable throwable = null;
                Object var5_6 = null;
                try (DocumentInputStream docStream = new DocumentInputStream(this.sourceDocument);){
                    this.structuredModel = this.modelManager.getModelForRead(this.getEditorInput().getName(), (InputStream)docStream, null);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException ex) {
                log.error(ex.getMessage(), (Throwable)ex);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private void initializeSourceDocument() {
        this.documentProvider = this.sourcePage.getDocumentProvider();
        if (this.documentProvider == null) {
            return;
        }
        this.sourceDocument = this.documentProvider.getDocument((Object)this.getEditorInput());
        IDocumentProvider iDocumentProvider = this.documentProvider;
        if (iDocumentProvider instanceof TextFileDocumentProvider var1_2) {
            try {
                void textDocumentProvider;
                textDocumentProvider.synchronize((Object)this.getEditorInput());
            }
            catch (CoreException ex) {
                log.error(ex.getMessage(), (Throwable)ex);
            }
        }
        this.closeEditorOnDocumentDeletion = new IElementStateListener(){

            public void elementMoved(Object originalElement, Object movedElement) {
            }

            public void elementDirtyStateChanged(Object element, boolean isDirty) {
            }

            public void elementDeleted(Object element) {
                if (Objects.equals(element, MavenPomEditor.this.getEditorInput())) {
                    Display.getDefault().asyncExec(() -> MavenPomEditor.this.close(false));
                }
            }

            public void elementContentReplaced(Object element) {
            }

            public void elementContentAboutToBeReplaced(Object element) {
            }
        };
        this.documentProvider.addElementStateListener(this.closeEditorOnDocumentDeletion);
    }

    protected void selectActivePage() {
        boolean showXML = M2EUIPluginActivator.getDefault().getPreferenceStore().getBoolean("eclipse.m2.defaultPomEditorPage");
        if (showXML) {
            this.setActivePage(this.sourcePageIndex);
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void pageChange(int newPageIndex) {
        IEditorActionBarContributor contributor;
        String name = this.getPageText(newPageIndex);
        if (EFFECTIVE_POM.equals(name)) {
            this.loadEffectivePOM();
        }
        try {
            super.pageChange(newPageIndex);
        }
        catch (NullPointerException e) {
            MavenEditorPlugin.getDefault().getLog().log(Status.error((String)"", (Throwable)e));
            this.close(false);
        }
        IEditorActionBarContributor iEditorActionBarContributor = contributor = this.getEditorSite().getActionBarContributor();
        if (iEditorActionBarContributor instanceof MultiPageEditorActionBarContributor var4_6) {
            void multiPageContributor;
            IFormPage activeEditor = this.getActivePageInstance();
            multiPageContributor.setActivePage((IEditorPart)activeEditor);
        }
    }

    private void addEditorPageExtensions() {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint indexesExtensionPoint = registry.getExtensionPoint(EXTENSION_FACTORIES);
        if (indexesExtensionPoint != null) {
            IExtension[] indexesExtensions;
            IExtension[] iExtensionArray = indexesExtensions = indexesExtensionPoint.getExtensions();
            int n = indexesExtensions.length;
            int n2 = 0;
            while (n2 < n) {
                IExtension extension = iExtensionArray[n2];
                IConfigurationElement[] iConfigurationElementArray = extension.getConfigurationElements();
                int n3 = iConfigurationElementArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    IConfigurationElement element = iConfigurationElementArray[n4];
                    if (ELEMENT_PAGE.equals(element.getName())) {
                        try {
                            MavenPomEditorPageFactory factory = (MavenPomEditorPageFactory)element.createExecutableExtension("class");
                            factory.addPages(this);
                        }
                        catch (CoreException ex) {
                            log.error(ex.getMessage(), (Throwable)ex);
                        }
                    }
                    ++n4;
                }
                ++n2;
            }
        }
    }

    private void addDocumentListener() {
        this.sourceDocument = this.getDocument();
        this.documentListener = new IDocumentListener(){

            public void documentAboutToBeChanged(DocumentEvent event) {
            }

            public void documentChanged(DocumentEvent event) {
                try {
                    if (MavenPomEditor.this.pomFile != null) {
                        MavenPomEditor.this.pomFile.refreshLocal(2, null);
                    }
                }
                catch (CoreException e) {
                    log.error(e.getMessage(), (Throwable)e);
                }
                if (MavenPomEditor.this.isCheckedWritableStatus() && MavenPomEditor.this.isReadOnly()) {
                    MavenPomEditor.this.setCheckedWritableStatus(false);
                }
            }
        };
        this.sourceDocument.addDocumentListener(this.documentListener);
    }

    protected IEditorSite createSite(IEditorPart editor) {
        Object site = null;
        site = editor == this.sourcePage ? new MultiPageEditorSite((MultiPageEditorPart)this, editor){

            public IEditorActionBarContributor getActionBarContributor() {
                IEditorActionBarContributor contributor = super.getActionBarContributor();
                IEditorActionBarContributor multiContributor = MavenPomEditor.this.getEditorSite().getActionBarContributor();
                if (multiContributor instanceof MavenPomEditorContributor var3_4) {
                    contributor = pomEditorContributor.sourceViewerActionContributor;
                }
                return contributor;
            }

            public String getId() {
                return String.valueOf(ContentTypeIdForXML.ContentTypeID_XML) + ".source";
            }
        } : super.createSite(editor);
        return site;
    }

    public void loadEffectivePOM() {
        if (this.disposed) {
            return;
        }
        String content = Messages.MavenPomEditor_loading;
        IDocument doc = this.getEffectivePomSourcePage().getDocumentProvider().getDocument((Object)this.getEffectivePomEditorInput());
        doc.set(content);
        LoadEffectivePomJob job = new LoadEffectivePomJob(Messages.MavenPomEditor_loading);
        job.schedule();
    }

    public IEditorInput getEffectivePomEditorInput() {
        if (this.effectivePomEditorInput == null) {
            String content = Messages.MavenPomEditor_loading;
            String name = String.valueOf(Messages.MavenPomEditor_effective) + this.getPartName();
            this.effectivePomEditorInput = new StaticMavenStorageEditorInput(name, name, null, content.getBytes(StandardCharsets.UTF_8));
        }
        return this.effectivePomEditorInput;
    }

    public boolean isReadOnly() {
        return !(this.getEditorInput() instanceof IFileEditorInput);
    }

    private int addPomPage(IFormPage page) {
        try {
            if (page instanceof MavenPomEditorPage var2_3) {
                this.mavenpomEditorPages.add((MavenPomEditorPage)pomPage);
            }
            if (page instanceof IPomFileChangedListener var5_6) {
                this.fileChangeListeners.add((IPomFileChangedListener)listener);
            }
            return this.addPage(page);
        }
        catch (PartInitException ex) {
            log.error(ex.getMessage(), (Throwable)ex);
            return -1;
        }
    }

    public synchronized DependencyNode readDependencyTree(boolean force, String classpath, IProgressMonitor monitor) throws CoreException {
        if (force || !this.rootNodes.containsKey(classpath)) {
            monitor.setTaskName(Messages.MavenPomEditor_task_reading);
            MavenProject mavenProject = this.readMavenProject(force, monitor);
            if (mavenProject == null) {
                log.error("Unable to read maven project. Dependencies not updated.");
                return null;
            }
            IMavenProjectFacade facade = null;
            if (this.pomFile != null && IPath.fromOSString((String)POM_XML).equals((Object)this.pomFile.getProjectRelativePath())) {
                facade = MavenPlugin.getMavenProjectRegistry().getProject(this.pomFile.getProject());
            }
            DependencyNode root = MavenPlugin.getMavenModelManager().readDependencyTree(facade, mavenProject, classpath, monitor);
            root.setData((Object)"LEVEL", (Object)"ROOT");
            for (DependencyNode nd : root.getChildren()) {
                nd.setData((Object)"LEVEL", (Object)"DIRECT");
            }
            this.rootNodes.put(classpath, root);
        }
        return this.rootNodes.get(classpath);
    }

    public MavenProject getMavenProject() {
        return this.mavenProject;
    }

    public MavenProject readMavenProject(boolean force, IProgressMonitor monitor) throws CoreException {
        if (force || this.mavenProject == null) {
            IEditorInput input = this.getEditorInput();
            if (input instanceof IFileEditorInput var4_5) {
                this.pomFile = fileInput.getFile();
                this.pomFile.refreshLocal(1, null);
            }
            if ((prj = SelectionUtil.getMavenProject((IEditorInput)input, (IProgressMonitor)monitor)) != null) {
                this.mavenProject = prj;
            }
        }
        return this.mavenProject;
    }

    public void dispose() {
        this.disposed = true;
        if (this.sourceDocument != null) {
            if (this.closeEditorOnDocumentDeletion != null && this.documentProvider != null) {
                this.documentProvider.removeElementStateListener(this.closeEditorOnDocumentDeletion);
            }
            if (this.documentListener != null) {
                this.sourceDocument.removeDocumentListener(this.documentListener);
            }
        }
        this.sourceDocument = null;
        this.sourcePage.dispose();
        MavenPluginActivator.getDefault().getMavenProjectManager().removeMavenProjectChangedListener((IMavenProjectChangedListener)this);
        if (this.structuredModel != null) {
            this.structuredModel.releaseFromEdit();
        }
        if (this.activationListener != null) {
            this.activationListener.dispose();
            this.activationListener = null;
        }
        ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
        super.dispose();
    }

    public void doSave(IProgressMonitor monitor) {
        this.resourceChangeEventSkip = true;
        try {
            this.sourcePage.doSave(monitor);
        }
        finally {
            this.resourceChangeEventSkip = false;
        }
    }

    public void doSaveAs() {
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public void init(IEditorSite site, IEditorInput editorInput) throws PartInitException {
        this.setPartName(editorInput.getToolTipText());
        super.init(site, editorInput);
        if (editorInput instanceof IFileEditorInput) {
            ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this);
        }
        this.reloadMavenProjectCache();
        IMavenProjectRegistry projectRegistry = MavenPluginActivator.getDefault().getMavenProjectManager();
        projectRegistry.addMavenProjectChangedListener((IMavenProjectChangedListener)this);
        this.activationListener = new MavenPomActivationListener(site.getWorkbenchWindow().getPartService());
    }

    public void showInSourceEditor(EObject o) {
        IDOMElement element = this.getElement(o);
        if (element != null) {
            int start = element.getStartOffset();
            int lenght = element.getLength();
            this.setActivePage(this.sourcePageIndex);
            this.sourcePage.selectAndReveal(start, lenght);
        }
    }

    public IDOMElement getElement(EObject o) {
        for (Adapter adapter : o.eAdapters()) {
            if (!(adapter instanceof EMF2DOMSSEAdapter var4_4)) continue;
            Node node = a.getNode();
            if (!(node instanceof IDOMElement var7_7)) break;
            return element;
        }
        return null;
    }

    public void showEditorInput(IEditorInput editorInput) {
    }

    public void gotoMarker(IMarker marker) {
        this.setActivePage(this.sourcePageIndex);
        IGotoMarker adapter = (IGotoMarker)this.sourcePage.getAdapter(IGotoMarker.class);
        adapter.gotoMarker(marker);
    }

    public IDocument getDocument(Match match) {
        return this.sourcePage.getDocumentProvider().getDocument((Object)this.getEditorInput());
    }

    public IAnnotationModel getAnnotationModel(Match match) {
        return this.sourcePage.getDocumentProvider().getAnnotationModel((Object)this.getEditorInput());
    }

    public boolean isDirty() {
        return this.sourcePage.isDirty();
    }

    public List<MavenPomEditorPage> getMavenPomEditorPages() {
        return this.mavenpomEditorPages;
    }

    public void showDependencyHierarchy(ArtifactKey artifactKey) {
        this.setActivePage(this.dependencyTreePage.getId());
        this.dependencyTreePage.selectDepedency(artifactKey);
    }

    protected boolean checkReadOnly() {
        IStatus validateEdit;
        if (this.isCheckedWritableStatus()) {
            return this.readOnly;
        }
        this.setCheckedWritableStatus(true);
        this.readOnly = this.getPomFile() != null && this.getPomFile().isReadOnly() ? (!(validateEdit = ResourcesPlugin.getWorkspace().validateEdit(new IFile[]{this.getPomFile()}, (Object)this.getEditorSite().getShell())).isOK() ? true : this.isReadOnly()) : this.isReadOnly();
        return this.readOnly;
    }

    public ITextEditor getSourcePage() {
        return this.sourcePage;
    }

    public IFormPage setActivePage(String pageId) {
        if (pageId == null) {
            this.setActivePage(this.sourcePageIndex);
        }
        return super.setActivePage(pageId);
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (MavenProject.class.equals(adapter)) {
            return adapter.cast(this.getMavenProject());
        }
        Object result = super.getAdapter(adapter);
        if (result != null && Display.getCurrent() == null) {
            return (T)result;
        }
        return adapter.cast(this.sourcePage.getAdapter(adapter));
    }

    public IFile getPomFile() {
        return this.pomFile;
    }

    private void reloadMavenProjectCache() {
        Job jb = new Job("reload maven project"){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    MavenPomEditor.this.readMavenProject(true, monitor);
                }
                catch (CoreException e) {
                    log.error("failed to load maven project for " + MavenPomEditor.this.getEditorInput(), (Throwable)e);
                }
                return Status.OK_STATUS;
            }
        };
        jb.setSystem(true);
        jb.schedule();
    }

    public void mavenProjectChanged(List<MavenProjectChangedEvent> events, IProgressMonitor monitor) {
        IEditorInput input = this.getEditorInput();
        if (input instanceof IFileEditorInput var4_5) {
            for (MavenProjectChangedEvent event : events) {
                if (!fileinput.getFile().equals((Object)event.getSource()) || (facade = event.getMavenProject()) == null || (mp = facade.getMavenProject()) == null) continue;
                this.mavenProject = mp;
                if (this.getContainer() == null || this.getContainer().isDisposed()) continue;
                this.getContainer().getDisplay().asyncExec(() -> {
                    for (MavenPomEditorPage page : this.getMavenPomEditorPages()) {
                        page.mavenProjectHasChanged();
                    }
                });
            }
        }
    }

    public void setPageText(int pageIndex, String text) {
        super.setPageText(pageIndex, text);
    }

    public boolean isCheckedWritableStatus() {
        return this.checkedWritableStatus;
    }

    public void setCheckedWritableStatus(boolean checkedWritableStatus) {
        this.checkedWritableStatus = checkedWritableStatus;
    }

    public ITextEditor getEffectivePomSourcePage() {
        return this.effectivePomSourcePage;
    }

    public void setSourcePage(ITextEditor sourcePage) {
        this.sourcePage = sourcePage;
        this.sourcePageIndex = this.pages.indexOf(sourcePage);
    }

    public void setEffectivePomSourcePage(ITextEditor effectivePomSourcePage) {
        this.effectivePomSourcePage = effectivePomSourcePage;
    }

    public void close(boolean save) {
        if (this.disposed) {
            return;
        }
        super.close(save);
    }

    class LoadEffectivePomJob
    extends MavenJob {
        public LoadEffectivePomJob(String name) {
            super(name);
        }

        private void showEffectivePomError(String name) {
            if (MavenPomEditor.this.disposed) {
                return;
            }
            String error = Messages.MavenPomEditor_error_loading_effective_pom;
            IDocument doc = MavenPomEditor.this.getEffectivePomSourcePage().getDocumentProvider().getDocument((Object)MavenPomEditor.this.getEffectivePomEditorInput());
            if (Display.getCurrent() != null) {
                doc.set(error);
            } else {
                MavenPomEditor.this.getSite().getShell().getDisplay().asyncExec(() -> doc.set(error));
            }
        }

        protected IStatus run(IProgressMonitor monitor) {
            try {
                StringWriter sw = new StringWriter();
                String name = String.valueOf(MavenPomEditor.this.getPartName()) + Messages.MavenPomEditor_effective;
                MavenProject mavenProject = SelectionUtil.getMavenProject((IEditorInput)MavenPomEditor.this.getEditorInput(), (IProgressMonitor)monitor);
                if (mavenProject == null) {
                    this.showEffectivePomError(name);
                    return Status.CANCEL_STATUS;
                }
                new MavenXpp3Writer().write((Writer)sw, mavenProject.getModel());
                String content = sw.toString();
                if (MavenPomEditor.this.disposed) {
                    return Status.OK_STATUS;
                }
                IDocument doc = MavenPomEditor.this.getEffectivePomSourcePage().getDocumentProvider().getDocument((Object)MavenPomEditor.this.getEffectivePomEditorInput());
                MavenPomEditor.this.getSite().getShell().getDisplay().syncExec(() -> doc.set(content));
                return Status.OK_STATUS;
            }
            catch (CoreException ce) {
                return Status.error((String)Messages.MavenPomEditor_error_failed_effective, (Throwable)ce);
            }
            catch (IOException ie) {
                return Status.error((String)Messages.MavenPomEditor_error_failed_effective, (Throwable)ie);
            }
        }
    }

    class MavenPomActivationListener
    implements IPartListener,
    IWindowListener {
        private IWorkbenchPart activePart;
        private boolean isHandlingActivation = false;

        public MavenPomActivationListener(IPartService partService) {
            partService.addPartListener((IPartListener)this);
            PlatformUI.getWorkbench().addWindowListener((IWindowListener)this);
        }

        public void dispose() {
            MavenPomEditor.this.getSite().getWorkbenchWindow().getPartService().removePartListener((IPartListener)this);
            PlatformUI.getWorkbench().removeWindowListener((IWindowListener)this);
        }

        public void partActivated(IWorkbenchPart part) {
            this.activePart = part;
            this.handleActivation();
            MavenPomEditor.this.checkReadOnly();
        }

        public void partBroughtToTop(IWorkbenchPart part) {
        }

        public void partClosed(IWorkbenchPart part) {
        }

        public void partDeactivated(IWorkbenchPart part) {
            this.activePart = null;
        }

        public void partOpened(IWorkbenchPart part) {
        }

        public void windowActivated(IWorkbenchWindow window) {
            if (window == MavenPomEditor.this.getEditorSite().getWorkbenchWindow()) {
                window.getShell().getDisplay().asyncExec(() -> this.handleActivation());
            }
        }

        public void windowDeactivated(IWorkbenchWindow window) {
        }

        public void windowClosed(IWorkbenchWindow window) {
        }

        public void windowOpened(IWorkbenchWindow window) {
        }

        void handleActivation() {
            if (this.isHandlingActivation) {
                return;
            }
            if (this.activePart == MavenPomEditor.this) {
                this.isHandlingActivation = true;
                try {
                    if (MavenPomEditor.this.sourcePage != null) {
                        MavenPomEditor.this.sourcePage.setFocus();
                    }
                }
                finally {
                    this.isHandlingActivation = false;
                }
            }
        }
    }
}

