/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.modisco.infra.browser.editor.ui.internal.editor;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.modisco.facet.custom.ui.CustomizedContentProviderUtils;
import org.eclipse.modisco.facet.util.core.DebugUtils;
import org.eclipse.modisco.infra.browser.editor.ui.internal.Activator;

public class TreeEditorSelectionProvider
implements ISelectionProvider {
    private static final boolean DEBUG = DebugUtils.getDebugStatus((Plugin)Activator.getDefault());
    private final ISelectionProvider wrappedSP;
    private final List<ISelectionChangedListener> listeners = new ArrayList<ISelectionChangedListener>();

    public TreeEditorSelectionProvider(ISelectionProvider wrappedSP) {
        this.wrappedSP = wrappedSP;
        this.wrappedSP.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                TreeEditorSelectionProvider.this.onSelectionChanged();
            }
        });
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.listeners.add(listener);
    }

    public ISelection getSelection() {
        ISelection wrappedSel = this.wrappedSP.getSelection();
        ISelection result = CustomizedContentProviderUtils.resolveSelection((ISelection)wrappedSel);
        if (DEBUG) {
            DebugUtils.debug((String)result.toString());
        }
        return result;
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.listeners.remove(listener);
    }

    public void setSelection(ISelection selection) {
    }

    protected void onSelectionChanged() {
        SelectionChangedEvent event = new SelectionChangedEvent((ISelectionProvider)this, this.getSelection());
        for (ISelectionChangedListener listener : this.listeners) {
            listener.selectionChanged(event);
        }
    }
}

