/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.builds.ui.actions;

import java.util.Map;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.mylyn.builds.core.IBuildElement;
import org.eclipse.mylyn.builds.core.IBuildPlan;
import org.eclipse.mylyn.builds.core.spi.RunBuildRequest;
import org.eclipse.mylyn.builds.internal.core.BuildPlan;
import org.eclipse.mylyn.builds.internal.core.operations.OperationChangeEvent;
import org.eclipse.mylyn.builds.internal.core.operations.OperationChangeListener;
import org.eclipse.mylyn.builds.internal.core.operations.RunBuildOperation;
import org.eclipse.mylyn.commons.workbench.WorkbenchUtil;
import org.eclipse.mylyn.internal.builds.ui.BuildImages;
import org.eclipse.mylyn.internal.builds.ui.BuildsUiInternal;
import org.eclipse.mylyn.internal.builds.ui.actions.Messages;
import org.eclipse.mylyn.internal.builds.ui.view.ParametersDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.actions.BaseSelectionListenerAction;

public class RunBuildAction
extends BaseSelectionListenerAction {
    public RunBuildAction() {
        super(Messages.RunBuildAction_runBuild);
        this.setToolTipText(Messages.RunBuildAction_runBuildToolTip);
        this.setImageDescriptor(BuildImages.RUN);
        this.setDisabledImageDescriptor(BuildImages.RUN_DISABLED);
    }

    protected boolean updateSelection(IStructuredSelection selection) {
        return selection.getFirstElement() instanceof IBuildPlan;
    }

    /*
     * WARNING - void declaration
     */
    public void run() {
        Object selection = this.getStructuredSelection().getFirstElement();
        Object object = selection;
        if (object instanceof IBuildPlan) {
            void plan;
            IBuildPlan iBuildPlan = (IBuildPlan)object;
            IBuildPlan cfr_ignored_0 = (IBuildPlan)object;
            RunBuildAction.askParametersAndRunBuild((IBuildPlan)plan);
        }
    }

    public static void askParametersAndRunBuild(final IBuildPlan plan) {
        BuildPlan copy = ((BuildPlan)plan).createWorkingCopy();
        Map<String, String> parameters = null;
        if (!copy.getParameterDefinitions().isEmpty()) {
            ParametersDialog dialog = new ParametersDialog(WorkbenchUtil.getShell(), copy);
            if (dialog.open() != 0) {
                return;
            }
            parameters = dialog.getParameters();
        }
        RunBuildRequest request = new RunBuildRequest((IBuildPlan)copy);
        request.setParameters(parameters);
        RunBuildOperation operation = BuildsUiInternal.getFactory().getRunBuildOperation(request);
        operation.addOperationChangeListener(new OperationChangeListener(){

            public void done(OperationChangeEvent event) {
                if (event.getStatus().isOK()) {
                    Display.getDefault().asyncExec(() -> BuildsUiInternal.getFactory().getRefreshOperation((IBuildElement)plan).execute());
                }
            }
        });
        operation.execute();
    }
}

