/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.builds.ui.commands;

import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.mylyn.builds.core.IBuild;
import org.eclipse.mylyn.builds.core.IBuildPlan;
import org.eclipse.mylyn.builds.core.IBuildServer;
import org.eclipse.mylyn.builds.core.spi.BuildServerBehaviour;
import org.eclipse.mylyn.builds.core.spi.GetBuildsRequest;
import org.eclipse.mylyn.builds.internal.core.BuildFactory;
import org.eclipse.mylyn.builds.ui.BuildsUi;
import org.eclipse.mylyn.commons.core.StatusHandler;
import org.eclipse.mylyn.commons.core.operations.IOperationMonitor;
import org.eclipse.mylyn.commons.workbench.browser.BrowserUtil;
import org.eclipse.mylyn.internal.builds.ui.BuildsUiInternal;
import org.eclipse.mylyn.internal.builds.ui.actions.ShowBuildOutputAction;
import org.eclipse.mylyn.internal.builds.ui.actions.ShowTestResultsAction;
import org.eclipse.mylyn.internal.builds.ui.commands.Messages;
import org.eclipse.mylyn.internal.builds.ui.view.NewBuildServerAction;
import org.eclipse.mylyn.internal.commons.core.operations.NullOperationMonitor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Event;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.BaseSelectionListenerAction;

public class BuildUrlCommandHandler
extends AbstractHandler {
    private static BuildCache buildCache = new BuildCache();
    private final BaseSelectionListenerAction action;
    private boolean needsDownload = true;

    public BuildUrlCommandHandler(BaseSelectionListenerAction action) {
        this.action = action;
    }

    protected void setNeedsDownload(boolean needsDownload) {
        this.needsDownload = needsDownload;
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        Object data;
        Object object;
        if (event.getTrigger() instanceof Event && (object = (data = ((Event)event.getTrigger()).widget.getData())) instanceof String) {
            String string = (String)object;
            String cfr_ignored_0 = (String)object;
            if (this.needsDownload) {
                IBuildServer buildServer = this.findServerForBuild((String)buildUrl);
                if (buildServer != null) {
                    this.downloadBuildAndRunAction(buildServer, (String)buildUrl);
                } else {
                    new NewBuildServerAction().run();
                }
            } else {
                this.action.selectionChanged((IStructuredSelection)new StructuredSelection((Object)buildUrl));
                this.action.run();
            }
        }
        return null;
    }

    private IBuildServer findServerForBuild(String buildUrl) {
        for (IBuildServer server : BuildsUiInternal.getModel().getServers()) {
            if (!buildUrl.startsWith(server.getUrl())) continue;
            return server;
        }
        return null;
    }

    protected void downloadBuildAndRunAction(final IBuildServer buildServer, final String buildUrl) {
        IBuild build = buildCache.get(this, buildUrl);
        if (build != null) {
            this.action.selectionChanged((IStructuredSelection)new StructuredSelection((Object)build));
            this.action.run();
            return;
        }
        Job job = new Job(NLS.bind((String)Messages.BuildUrlCommandHandler_Downloading_Build_X, (Object)buildUrl)){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    BuildServerBehaviour behaviour = BuildsUi.getConnector(buildServer.getConnectorKind()).getBehaviour(buildServer.getLocation());
                    String buildUrl2 = BuildUrlCommandHandler.this.removeEnd(buildUrl, "/");
                    String buildId = BuildUrlCommandHandler.this.substringAfterLast(buildUrl2, "/");
                    String planId = BuildUrlCommandHandler.this.substringAfterLast(BuildUrlCommandHandler.this.substringBeforeLast(buildUrl2, "/"), "/");
                    IBuildPlan plan = BuildFactory.eINSTANCE.createBuildPlan();
                    plan.setId(planId);
                    plan.setName(planId);
                    GetBuildsRequest request = new GetBuildsRequest(plan, Collections.singletonList(buildId), GetBuildsRequest.Scope.FULL);
                    List builds = behaviour.getBuilds(request, (IOperationMonitor)new NullOperationMonitor());
                    if (!builds.isEmpty()) {
                        IBuild populatedBuild = (IBuild)builds.get(0);
                        populatedBuild.setServer(buildServer);
                        populatedBuild.setPlan(plan);
                        buildCache.put(BuildUrlCommandHandler.this, populatedBuild);
                        BuildUrlCommandHandler.this.action.selectionChanged((IStructuredSelection)new StructuredSelection((Object)populatedBuild));
                        PlatformUI.getWorkbench().getDisplay().asyncExec(() -> BuildUrlCommandHandler.this.action.run());
                    }
                }
                catch (CoreException e) {
                    StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.builds.ui", e.getMessage(), (Throwable)e));
                }
                return Status.OK_STATUS;
            }
        };
        job.setUser(true);
        job.schedule();
    }

    protected String substringBeforeLast(String s, String last) {
        int i = s.lastIndexOf(last);
        if (i != -1) {
            return s.substring(0, i);
        }
        return s;
    }

    private String substringAfterLast(String s, String last) {
        int i = s.lastIndexOf(last);
        if (i != -1) {
            return s.substring(i + last.length());
        }
        return s;
    }

    private String removeEnd(String s, String end) {
        if (s.endsWith(end)) {
            return s.substring(0, s.length() - end.length());
        }
        return s;
    }

    private static class BuildCache {
        private WeakReference<IBuild> lastBuild = new WeakReference<Object>(null);
        private BuildUrlCommandHandler lastHandler;

        private BuildCache() {
        }

        public void put(BuildUrlCommandHandler handler, IBuild build) {
            this.lastBuild = new WeakReference<IBuild>(build);
            this.lastHandler = handler;
        }

        public IBuild get(BuildUrlCommandHandler handler, String buildUrl) {
            IBuild build;
            if (this.lastHandler != handler && (build = (IBuild)this.lastBuild.get()) != null && buildUrl.equals(build.getUrl())) {
                this.lastBuild.clear();
                return build;
            }
            return null;
        }
    }

    public static class OpenWithBrowserUrlHandler
    extends BuildUrlCommandHandler {
        public OpenWithBrowserUrlHandler() {
            super(new BaseSelectionListenerAction(Messages.BuildUrlCommandHandler_Open_with_Browser){

                public void run() {
                    Object selection = this.getStructuredSelection().getFirstElement();
                    if (selection instanceof String) {
                        BrowserUtil.openUrl((String)((String)selection), (int)131072);
                    }
                }
            });
            this.setNeedsDownload(false);
        }
    }

    public static class ShowBuildOutputUrlHandler
    extends BuildUrlCommandHandler {
        public ShowBuildOutputUrlHandler() {
            super(new ShowBuildOutputAction());
        }
    }

    public static class ShowTestResultsUrlHandler
    extends BuildUrlCommandHandler {
        public ShowTestResultsUrlHandler() {
            super(new ShowTestResultsAction());
        }
    }
}

