/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.gerrit.ui.providers;

import org.eclipse.compare.CompareConfiguration;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.mylyn.internal.gerrit.ui.GerritCompareUi;
import org.eclipse.mylyn.internal.gerrit.ui.GerritReviewBehavior;
import org.eclipse.mylyn.internal.reviews.ui.ActiveReviewManager;
import org.eclipse.mylyn.internal.reviews.ui.ReviewsUiPlugin;
import org.eclipse.mylyn.reviews.core.model.IComment;
import org.eclipse.mylyn.reviews.core.model.IFileItem;
import org.eclipse.mylyn.reviews.core.model.IFileVersion;
import org.eclipse.mylyn.reviews.ui.ReviewBehavior;
import org.eclipse.mylyn.tasks.ui.editors.TaskEditor;
import org.eclipse.mylyn.tasks.ui.editors.TaskEditorInput;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.navigator.CommonActionProvider;
import org.eclipse.ui.navigator.ICommonActionExtensionSite;
import org.eclipse.ui.navigator.ICommonViewerWorkbenchSite;

public class OpenCompareEditorProvider
extends CommonActionProvider {
    private Action openAction;

    public void init(ICommonActionExtensionSite site) {
        if (site.getViewSite() instanceof ICommonViewerWorkbenchSite) {
            ICommonViewerWorkbenchSite viewSite = (ICommonViewerWorkbenchSite)site.getViewSite();
            final ISelectionProvider selectionProvider = viewSite.getSelectionProvider();
            this.openAction = new Action(){

                /*
                 * WARNING - void declaration
                 */
                public void run() {
                    TaskEditor currentPart;
                    TaskEditor taskEditor;
                    ActiveReviewManager reviewManager;
                    IFileItem fileItem;
                    IStructuredSelection selection = (IStructuredSelection)selectionProvider.getSelection();
                    if (selection.size() == 1 && (fileItem = OpenCompareEditorProvider.getFileFor(selection.getFirstElement())) != null && (reviewManager = ReviewsUiPlugin.getDefault().getReviewManager()) != null && (taskEditor = (currentPart = reviewManager.getCurrentPart())) instanceof TaskEditor) {
                        void part;
                        TaskEditor taskEditor2 = taskEditor;
                        TaskEditorInput input = (TaskEditorInput)part.getEditorInput();
                        GerritReviewBehavior behavior = new GerritReviewBehavior(input.getTask());
                        CompareConfiguration configuration = new CompareConfiguration();
                        GerritCompareUi.openFileComparisonEditor(configuration, fileItem, (ReviewBehavior)behavior, selection);
                    }
                }

                public boolean isEnabled() {
                    return true;
                }
            };
        }
    }

    private static IFileItem getFileFor(Object element) {
        if (element instanceof IComment) {
            return OpenCompareEditorProvider.getFileFor(((IComment)element).getItem());
        }
        if (element instanceof IFileVersion) {
            return ((IFileVersion)element).getFile();
        }
        if (element instanceof IFileItem) {
            return (IFileItem)element;
        }
        return null;
    }

    public void fillActionBars(IActionBars actionBars) {
        if (this.openAction.isEnabled()) {
            actionBars.setGlobalActionHandler("org.eclipse.ui.navigator.Open", (IAction)this.openAction);
        }
    }
}

