/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.util;

import org.eclipse.core.expressions.PropertyTester;
import org.eclipse.mylyn.internal.tasks.core.AbstractTask;
import org.eclipse.mylyn.internal.tasks.ui.actions.ClearOutgoingAction;
import org.eclipse.mylyn.internal.tasks.ui.util.AttachmentUtil;
import org.eclipse.mylyn.internal.tasks.ui.util.TasksUiInternal;
import org.eclipse.mylyn.tasks.core.ITask;

public class TaskPropertyTester
extends PropertyTester {
    private static final String PROPERTY_CAN_GET_ATTACHMENT = "canGetAttachment";
    private static final String PROPERTY_CAN_GET_HISTORY = "canGetHistory";
    private static final String PROPERTY_CAN_POST_ATTACHMENT = "canPostAttachment";
    private static final String PROPERTY_CONNECTOR_KIND = "connectorKind";
    private static final String PROPERTY_HAS_ACTIVE_TIME = "hasActiveTime";
    private static final String PROPERTY_HAS_EDITS = "hasEdits";
    private static final String PROPERTY_HAS_LOCAL_CONTEXT = "hasLocalContext";
    private static final String PROPERTY_HAS_REPOSITORY_CONTEXT = "hasRepositoryContext";
    private static final String PROPERTY_IS_COMPLETED = "isCompleted";
    private static final String PROPERTY_IS_LOCAL = "isLocal";
    private static final String PROPERTY_LOCAL_COMPLETION_STATE = "hasLocalCompletionState";
    private static final String PROPERTY_IS_ARTIFACT = "isArtifact";

    private boolean equals(boolean value, Object expectedValue) {
        return Boolean.valueOf(value).equals(expectedValue);
    }

    /*
     * WARNING - void declaration
     */
    public boolean test(Object receiver, String property, Object[] args, Object expectedValue) {
        Object object = receiver;
        if (object instanceof ITask) {
            void task;
            ITask iTask = (ITask)object;
            ITask cfr_ignored_0 = (ITask)object;
            if (PROPERTY_CONNECTOR_KIND.equals(property)) {
                return task.getConnectorKind().equals(expectedValue);
            }
            if (PROPERTY_CAN_POST_ATTACHMENT.equals(property)) {
                return this.equals(AttachmentUtil.canUploadAttachment((ITask)task), expectedValue);
            }
            if (PROPERTY_CAN_GET_ATTACHMENT.equals(property)) {
                return this.equals(AttachmentUtil.canDownloadAttachment((ITask)task), expectedValue);
            }
            if (PROPERTY_CAN_GET_HISTORY.equals(property)) {
                return TasksUiInternal.canGetTaskHistory((ITask)task);
            }
            if (PROPERTY_HAS_ACTIVE_TIME.equals(property)) {
                return this.equals(TasksUiInternal.getActiveTime((ITask)task) > 0L, expectedValue);
            }
            if (PROPERTY_HAS_EDITS.equals(property)) {
                return this.equals(ClearOutgoingAction.hasOutgoingChanges((ITask)task), expectedValue);
            }
            if (PROPERTY_HAS_LOCAL_CONTEXT.equals(property)) {
                return this.equals(AttachmentUtil.hasLocalContext((ITask)task), expectedValue);
            }
            if (PROPERTY_HAS_REPOSITORY_CONTEXT.equals(property)) {
                return this.equals(AttachmentUtil.hasContextAttachment((ITask)task), expectedValue);
            }
            if (PROPERTY_IS_COMPLETED.equals(property)) {
                return this.equals(task.isCompleted(), expectedValue);
            }
            if (PROPERTY_IS_LOCAL.equals(property)) {
                return task instanceof AbstractTask && this.equals(((AbstractTask)task).isLocal(), expectedValue);
            }
            if (PROPERTY_LOCAL_COMPLETION_STATE.equals(property)) {
                return this.equals(TasksUiInternal.hasLocalCompletionState((ITask)task), expectedValue);
            }
            if (PROPERTY_IS_ARTIFACT.equals(property)) {
                String artifactFlag = task.getAttribute("org.eclipse.mylyn.is.artifact");
                return this.equals(Boolean.parseBoolean(artifactFlag), expectedValue);
            }
        }
        return false;
    }
}

