/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.wikitext.ui.editor;

import java.util.Stack;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IExecutionListener;
import org.eclipse.core.commands.NotHandledException;
import org.eclipse.jface.text.IFindReplaceTarget;
import org.eclipse.jface.text.IFindReplaceTargetExtension;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextListener;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.ITextViewerExtension;
import org.eclipse.jface.text.TextEvent;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.custom.VerifyKeyListener;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;

public class FindAndReplaceTarget
implements IFindReplaceTarget,
IFindReplaceTargetExtension,
VerifyKeyListener,
MouseListener,
FocusListener,
ISelectionChangedListener,
ITextListener,
IExecutionListener {
    private final ITextViewer textViewer;
    private final IFindReplaceTarget findReplaceTarget;
    private final IFindReplaceTargetExtension findReplaceTargetExtension;
    private boolean installed;
    private boolean searching;
    private final Stack<Result> state = new Stack();
    private String findString = "";
    private int index = 0;
    private boolean findHit = true;
    private String previousFindString = "";

    /*
     * WARNING - void declaration
     */
    public FindAndReplaceTarget(ITextViewer textViewer) {
        this.textViewer = textViewer;
        IFindReplaceTarget iFindReplaceTarget = this.findReplaceTarget = textViewer.getFindReplaceTarget();
        if (iFindReplaceTarget instanceof IFindReplaceTargetExtension) {
            void frte;
            IFindReplaceTargetExtension iFindReplaceTargetExtension = (IFindReplaceTargetExtension)iFindReplaceTarget;
            IFindReplaceTargetExtension cfr_ignored_0 = (IFindReplaceTargetExtension)iFindReplaceTarget;
            this.findReplaceTargetExtension = frte;
        } else {
            this.findReplaceTargetExtension = null;
        }
    }

    public boolean canPerformFind() {
        return this.findReplaceTarget.canPerformFind();
    }

    public int findAndSelect(int widgetOffset, String findString, boolean searchForward, boolean caseSensitive, boolean wholeWord) {
        return this.findReplaceTarget.findAndSelect(widgetOffset, findString, searchForward, caseSensitive, wholeWord);
    }

    public Point getSelection() {
        return this.findReplaceTarget.getSelection();
    }

    public String getSelectionText() {
        return this.findReplaceTarget.getSelectionText();
    }

    public boolean isEditable() {
        return this.findReplaceTarget.isEditable();
    }

    public void replaceSelection(String text) {
        this.findReplaceTarget.replaceSelection(text);
    }

    public void beginSession() {
        if (this.installed) {
            this.next();
            return;
        }
        this.clearState();
        this.index = 0;
        this.findHit = true;
        this.findString = "";
        StyledText textWidget = this.textViewer.getTextWidget();
        if (textWidget != null && !textWidget.isDisposed()) {
            this.index = textWidget.getCaretOffset();
            textWidget.setSelection(this.index);
        }
        this.install();
        if (this.findReplaceTargetExtension != null) {
            this.findReplaceTargetExtension.beginSession();
        }
    }

    private void next() {
        if (this.findHit) {
            this.saveState();
        }
        this.repeatSearch();
    }

    private void saveState() {
        Result newState = new Result(new Point(this.index, this.index + this.findString.length()), this.findString, this.index, this.findHit);
        this.state.push(newState);
    }

    private void clearState() {
        this.state.clear();
    }

    private void restoreState() {
        StyledText textWidget = this.textViewer.getTextWidget();
        if (textWidget == null || textWidget.isDisposed()) {
            return;
        }
        Result result = null;
        if (!this.state.isEmpty()) {
            result = this.state.pop();
        }
        if (result == null) {
            textWidget.getDisplay().beep();
            return;
        }
        this.findString = result.findString;
        this.index = result.index;
        this.findHit = result.findHit;
        textWidget.setSelection(result.selection);
        textWidget.showSelection();
    }

    private void addSearchCharacter(char character) {
        this.findString = String.valueOf(this.findString) + character;
        this.doFind();
    }

    private void repeatSearch() {
        if (this.findString.length() == 0) {
            this.findString = this.previousFindString;
        }
        if (this.findString.length() == 0) {
            this.findHit = true;
            return;
        }
        if (!this.findHit) {
            this.index = 0;
        } else {
            StyledText textWidget = this.textViewer.getTextWidget();
            this.index = textWidget.getCaretOffset();
        }
        this.doFind();
    }

    private void doFind() {
        boolean findHit;
        boolean hasUpperCase = false;
        int x = 0;
        while (x < this.findString.length()) {
            char c = this.findString.charAt(x);
            if (Character.isUpperCase(c) && Character.toLowerCase(c) != c) {
                hasUpperCase = true;
                break;
            }
            ++x;
        }
        this.searching = true;
        StyledText textWidget = this.textViewer.getTextWidget();
        textWidget.setRedraw(false);
        int foundIndex = this.findReplaceTarget.findAndSelect(this.index, this.findString, true, hasUpperCase, false);
        textWidget.setRedraw(true);
        boolean bl = findHit = foundIndex >= 0;
        if (findHit) {
            this.index = foundIndex;
        } else if (this.findHit) {
            textWidget.getDisplay().beep();
        }
        this.findHit = findHit;
        this.searching = false;
    }

    public void endSession() {
        if (this.findReplaceTargetExtension != null) {
            this.findReplaceTargetExtension.endSession();
        }
    }

    public IRegion getScope() {
        if (this.findReplaceTargetExtension != null) {
            return this.findReplaceTargetExtension.getScope();
        }
        return null;
    }

    public void setScope(IRegion scope) {
        if (this.findReplaceTargetExtension != null) {
            this.findReplaceTargetExtension.setScope(scope);
        }
    }

    public Point getLineSelection() {
        if (this.findReplaceTargetExtension != null) {
            return this.findReplaceTargetExtension.getLineSelection();
        }
        return null;
    }

    public void setSelection(int offset, int length) {
        if (this.findReplaceTargetExtension != null) {
            this.findReplaceTargetExtension.setSelection(offset, length);
        }
    }

    public void setScopeHighlightColor(Color color) {
        if (this.findReplaceTargetExtension != null) {
            this.findReplaceTargetExtension.setScopeHighlightColor(color);
        }
    }

    public void setReplaceAllMode(boolean replaceAll) {
        if (this.findReplaceTargetExtension != null) {
            this.findReplaceTargetExtension.setReplaceAllMode(replaceAll);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void install() {
        ITextViewer iTextViewer;
        if (this.installed) {
            return;
        }
        StyledText textWidget = this.textViewer.getTextWidget();
        if (textWidget == null) {
            return;
        }
        this.textViewer.addTextListener((ITextListener)this);
        textWidget.addMouseListener((MouseListener)this);
        textWidget.addFocusListener((FocusListener)this);
        ISelectionProvider selectionProvider = this.textViewer.getSelectionProvider();
        if (selectionProvider != null) {
            selectionProvider.addSelectionChangedListener((ISelectionChangedListener)this);
        }
        if ((iTextViewer = this.textViewer) instanceof ITextViewerExtension) {
            void tve;
            ITextViewerExtension iTextViewerExtension = (ITextViewerExtension)iTextViewer;
            ITextViewerExtension cfr_ignored_0 = (ITextViewerExtension)iTextViewer;
            tve.prependVerifyKeyListener((VerifyKeyListener)this);
        } else {
            textWidget.addVerifyKeyListener((VerifyKeyListener)this);
        }
        ICommandService commandService = (ICommandService)PlatformUI.getWorkbench().getAdapter(ICommandService.class);
        if (commandService != null) {
            commandService.addExecutionListener((IExecutionListener)this);
        }
        this.installed = true;
    }

    private void stop() {
        if (this.findString.length() > 0) {
            this.previousFindString = this.findString;
            this.findString = "";
        }
        this.index = 0;
        this.findHit = true;
        this.clearState();
        this.uninstall();
    }

    /*
     * WARNING - void declaration
     */
    private void uninstall() {
        ITextViewer iTextViewer;
        if (!this.installed) {
            return;
        }
        StyledText textWidget = this.textViewer.getTextWidget();
        if (textWidget == null) {
            return;
        }
        this.textViewer.removeTextListener((ITextListener)this);
        textWidget.removeMouseListener((MouseListener)this);
        textWidget.removeFocusListener((FocusListener)this);
        ISelectionProvider selectionProvider = this.textViewer.getSelectionProvider();
        if (selectionProvider != null) {
            selectionProvider.removeSelectionChangedListener((ISelectionChangedListener)this);
        }
        if ((iTextViewer = this.textViewer) instanceof ITextViewerExtension) {
            void tve;
            ITextViewerExtension iTextViewerExtension = (ITextViewerExtension)iTextViewer;
            ITextViewerExtension cfr_ignored_0 = (ITextViewerExtension)iTextViewer;
            tve.removeVerifyKeyListener((VerifyKeyListener)this);
        } else {
            textWidget.removeVerifyKeyListener((VerifyKeyListener)this);
        }
        ICommandService commandService = (ICommandService)PlatformUI.getWorkbench().getAdapter(ICommandService.class);
        if (commandService != null) {
            commandService.removeExecutionListener((IExecutionListener)this);
        }
        this.installed = false;
    }

    public void notHandled(String commandId, NotHandledException exception) {
    }

    public void postExecuteFailure(String commandId, ExecutionException exception) {
    }

    public void postExecuteSuccess(String commandId, Object returnValue) {
    }

    public void preExecute(String commandId, ExecutionEvent event) {
        if (!"org.eclipse.ui.edit.findIncremental".equals(commandId)) {
            this.stop();
        }
    }

    public void textChanged(TextEvent event) {
        if (event.getDocumentEvent() != null) {
            this.stop();
        }
    }

    public void focusGained(FocusEvent e) {
        this.stop();
    }

    public void focusLost(FocusEvent e) {
        this.stop();
    }

    public void mouseDoubleClick(MouseEvent e) {
        this.stop();
    }

    public void mouseDown(MouseEvent e) {
        this.stop();
    }

    public void mouseUp(MouseEvent e) {
        this.stop();
    }

    public void verifyKey(VerifyEvent event) {
        if (!event.doit) {
            return;
        }
        if (event.character == '\u0000') {
            switch (event.keyCode) {
                case 0x1000001: 
                case 0x1000003: 
                case 0x1000004: 
                case 0x1000005: 
                case 0x1000006: 
                case 0x1000007: 
                case 0x1000008: {
                    this.stop();
                    break;
                }
                case 0x1000002: {
                    this.next();
                    event.doit = false;
                }
            }
        } else {
            switch (event.character) {
                case '\r': 
                case '\u001b': {
                    this.stop();
                    event.doit = false;
                    break;
                }
                case '\b': 
                case '\u007f': {
                    this.restoreState();
                    event.doit = false;
                    break;
                }
                default: {
                    if (event.stateMask != 0 && event.stateMask != 131072) break;
                    this.saveState();
                    this.addSearchCharacter(event.character);
                    event.doit = false;
                }
            }
        }
    }

    public void selectionChanged(SelectionChangedEvent event) {
        if (!this.searching) {
            this.stop();
        }
    }

    private static final class Result {
        private final Point selection;
        private final String findString;
        private final int index;
        private final boolean findHit;

        public Result(Point selection, String findString, int index, boolean findHit) {
            this.findString = findString;
            this.index = index;
            this.selection = new Point(selection.x, selection.y);
            this.findHit = findHit;
        }

        public String toString() {
            return "Result [selection=" + String.valueOf(this.selection) + ", findString=" + this.findString + ", index=" + this.index + ", findHit=" + this.findHit + "]";
        }
    }
}

