/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.wikitext.parser.builder.event;

import java.util.Objects;
import org.eclipse.mylyn.wikitext.parser.Attributes;
import org.eclipse.mylyn.wikitext.parser.DocumentBuilder;
import org.eclipse.mylyn.wikitext.parser.builder.event.DocumentBuilderEvent;

public class LinkEvent
extends DocumentBuilderEvent {
    private final String hrefOrHashName;
    private final String text;
    private final Attributes attributes;

    public LinkEvent(Attributes attributes, String hrefOrHashName, String text) {
        this.attributes = Objects.requireNonNull(attributes, "Must provide attributes").clone();
        this.hrefOrHashName = Objects.requireNonNull(hrefOrHashName, "Must provide hrefOrHashName");
        this.text = Objects.requireNonNull(text, "Must provide text");
    }

    @Override
    public void invoke(DocumentBuilder builder) {
        builder.link(this.attributes, this.hrefOrHashName, this.text);
    }

    public int hashCode() {
        return Objects.hash(this.hrefOrHashName, this.text);
    }

    /*
     * WARNING - void declaration
     */
    public boolean equals(Object obj) {
        void other;
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        Object object = obj;
        if (!(object instanceof LinkEvent)) {
            return false;
        }
        LinkEvent linkEvent = (LinkEvent)object;
        LinkEvent cfr_ignored_0 = (LinkEvent)object;
        return Objects.equals(this.hrefOrHashName, other.hrefOrHashName) && Objects.equals(this.text, other.text);
    }

    public String toString() {
        return String.format("link(%s,\"%s\")", this.hrefOrHashName, this.text);
    }
}

