/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.internal.ui.container;

import org.eclipse.net4j.jvm.IJVMAcceptor;
import org.eclipse.net4j.util.ObjectUtil;
import org.eclipse.net4j.util.factory.ProductCreationException;
import org.eclipse.net4j.util.ui.container.ElementWizard;
import org.eclipse.net4j.util.ui.container.ElementWizardFactory;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Text;

public class JVMAcceptorWizard
extends ElementWizard
implements ModifyListener {
    private Text acceptorNameText;

    protected void create(Composite parent) {
        this.acceptorNameText = JVMAcceptorWizard.addText((Composite)parent, (String)"Acceptor Name:");
        this.acceptorNameText.addModifyListener((ModifyListener)this);
        String description = this.getDefaultDescription();
        if (description != null) {
            this.acceptorNameText.setText(description);
        }
    }

    public void modifyText(ModifyEvent e) {
        String acceptorName = this.acceptorNameText.getText();
        if (acceptorName.length() == 0) {
            this.setValidationError(this.acceptorNameText, "Acceptor name is empty.");
            return;
        }
        try {
            Object[] objectArray = this.getContainer().getElements("org.eclipse.net4j.acceptors", "jvm");
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                IJVMAcceptor acceptor;
                Object element = objectArray[n2];
                if (element instanceof IJVMAcceptor && ObjectUtil.equals((Object)(acceptor = (IJVMAcceptor)element).getName(), (Object)acceptorName)) {
                    this.setValidationError(this.acceptorNameText, "Duplicate acceptor name.");
                    return;
                }
                ++n2;
            }
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
        this.setResultDescription(acceptorName);
        this.setValidationError(this.acceptorNameText, null);
    }

    public static class Factory
    extends ElementWizardFactory {
        public Factory() {
            super("org.eclipse.net4j.acceptors", "jvm");
        }

        public JVMAcceptorWizard create(String description) throws ProductCreationException {
            return new JVMAcceptorWizard();
        }
    }
}

