/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.api.tools.internal;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.pde.core.IClasspathContributor;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.PluginRegistry;
import org.eclipse.pde.internal.core.ClasspathUtilCore;
import org.osgi.resource.Resource;

public class ApiAnnotationsClasspathContributor
implements IClasspathContributor {
    private static final Collection<String> API_TOOLS_ANNOTATIONS = List.of("org.eclipse.pde.api.tools.annotations");

    public List<IClasspathEntry> getInitialEntries(BundleDescription project) {
        IPluginModelBase projectModel = PluginRegistry.findModel((Resource)project);
        if (this.hasApiNature(projectModel)) {
            return ClasspathUtilCore.classpathEntries(ApiAnnotationsClasspathContributor.annotations().filter(model -> !model.equals(projectModel))).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    private boolean hasApiNature(IPluginModelBase model) {
        IResource resource;
        if (model != null && (resource = model.getUnderlyingResource()) != null) {
            try {
                return resource.getProject().hasNature("org.eclipse.pde.api.tools.apiAnalysisNature");
            }
            catch (CoreException coreException) {
                // empty catch block
            }
        }
        return false;
    }

    public static Stream<IPluginModelBase> annotations() {
        return API_TOOLS_ANNOTATIONS.stream().map(PluginRegistry::findModel).filter(Objects::nonNull).filter(IPluginModelBase::isEnabled);
    }

    public List<IClasspathEntry> getEntriesForDependency(BundleDescription project, BundleDescription addedDependency) {
        return Collections.emptyList();
    }
}

