/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.text;

import java.net.URL;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.pde.core.plugin.IPluginAttribute;
import org.eclipse.pde.core.plugin.IPluginElement;
import org.eclipse.pde.core.plugin.IPluginExtension;
import org.eclipse.pde.core.plugin.IPluginExtensionPoint;
import org.eclipse.pde.core.plugin.IPluginObject;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.ischema.ISchema;
import org.eclipse.pde.internal.core.ischema.ISchemaAttribute;
import org.eclipse.pde.internal.core.ischema.ISchemaElement;
import org.eclipse.pde.internal.core.ischema.ISchemaObject;
import org.eclipse.pde.internal.core.schema.SchemaAnnotationHandler;
import org.eclipse.pde.internal.core.text.IDocumentAttributeNode;
import org.eclipse.pde.internal.core.text.IDocumentElementNode;
import org.eclipse.pde.internal.core.text.IDocumentRange;
import org.eclipse.pde.internal.core.text.IDocumentTextNode;
import org.eclipse.pde.internal.core.util.SchemaUtil;
import org.eclipse.pde.internal.core.util.XMLComponentRegistry;
import org.eclipse.pde.internal.ui.editor.PDESourcePage;
import org.eclipse.pde.internal.ui.editor.text.PDETextHover;
import org.xml.sax.helpers.DefaultHandler;

public class PluginXMLTextHover
extends PDETextHover {
    private final PDESourcePage fSourcePage;

    public PluginXMLTextHover(PDESourcePage sourcePage) {
        this.fSourcePage = sourcePage;
    }

    public String getHoverInfo(ITextViewer textViewer, IRegion hoverRegion) {
        int offset = hoverRegion.getOffset();
        IDocumentRange range = this.fSourcePage.getRangeElement(offset, true);
        if (range instanceof IDocumentTextNode) {
            return this.checkTranslatedValue((IDocumentTextNode)range);
        }
        if (!(range instanceof IPluginObject)) {
            return null;
        }
        ISchema schema = this.getExtensionSchema((IPluginObject)range);
        if (schema != null) {
            ISchemaObject sObj = this.getSchemaObject(schema, (IPluginObject)range);
            if (sObj == null) {
                return null;
            }
            if (range instanceof IPluginAttribute && sObj instanceof ISchemaElement) {
                IDocumentAttributeNode da = (IDocumentAttributeNode)range;
                if (da.getNameOffset() <= offset && offset <= da.getNameOffset() + da.getNameLength() - 1) {
                    return this.getAttributeText((IPluginAttribute)range, (ISchemaElement)sObj);
                }
                if (da.getValueOffset() <= offset && offset <= da.getValueOffset() + da.getValueLength() - 1) {
                    return this.getAttributeValueText((IPluginAttribute)range, (ISchemaElement)sObj);
                }
            } else if (range instanceof IPluginElement) {
                IDocumentElementNode dn = (IDocumentElementNode)range;
                int dnOff = dn.getOffset();
                int dnLen = dn.getLength();
                String dnName = dn.getXMLTagName();
                if (dnOff + 1 <= offset && offset <= dnOff + dnName.length()) {
                    return this.getElementText((ISchemaElement)sObj);
                }
                try {
                    String nt = textViewer.getDocument().get(dnOff, dnLen);
                    if (nt.endsWith("</" + dnName + ">") && nt.length() - dnName.length() - 1 <= (offset -= dnOff) && offset <= nt.length() - 2) {
                        return this.getElementText((ISchemaElement)sObj);
                    }
                }
                catch (BadLocationException badLocationException) {}
            }
        } else if (range instanceof IDocumentAttributeNode && ((IDocumentAttributeNode)range).getEnclosingElement() instanceof IPluginExtensionPoint) {
            return this.getExtensionPointHoverInfo((IPluginObject)range, offset);
        }
        return null;
    }

    private String getExtensionPointHoverInfo(IPluginObject object, int offset) {
        IDocumentAttributeNode da = (IDocumentAttributeNode)object;
        if (da.getValueOffset() <= offset && offset <= da.getValueOffset() + da.getValueLength() - 1) {
            String value = da.getAttributeValue();
            if (da.getAttributeName().equals("name") && value.startsWith("%")) {
                return object.getResourceString(value);
            }
        }
        return null;
    }

    private ISchema getExtensionSchema(IPluginObject object) {
        IPluginObject extension = object;
        if (object instanceof IDocumentAttributeNode) {
            extension = (IPluginObject)((IDocumentAttributeNode)object).getEnclosingElement();
        }
        while (extension != null && !(extension instanceof IPluginExtension)) {
            extension = extension.getParent();
        }
        if (extension == null) {
            return null;
        }
        String point = ((IPluginExtension)extension).getPoint();
        return PDECore.getDefault().getSchemaRegistry().getSchema(point);
    }

    private ISchemaObject getSchemaObject(ISchema schema, IPluginObject object) {
        if (object instanceof IPluginElement) {
            return schema.findElement(((IPluginElement)object).getName());
        }
        if (object instanceof IPluginExtension) {
            return schema.findElement("extension");
        }
        if (object instanceof IDocumentAttributeNode) {
            return schema.findElement(((IDocumentAttributeNode)object).getEnclosingElement().getXMLTagName());
        }
        return null;
    }

    private String getAttributeText(IPluginAttribute attrib, ISchemaElement sEle) {
        ISchemaAttribute sAtt = sEle.getAttribute(attrib.getName());
        if (sAtt == null) {
            return null;
        }
        return sAtt.getDescription();
    }

    private String getAttributeValueText(IPluginAttribute attrib, ISchemaElement sEle) {
        if (sEle.getName().equals("extension") && attrib.getName().equals("point")) {
            return this.getSchemaDescription(attrib, sEle);
        }
        ISchemaAttribute sAtt = sEle.getAttribute(attrib.getName());
        if (sAtt == null) {
            return null;
        }
        String value = attrib.getValue();
        if (sAtt.isTranslatable() && value.startsWith("%")) {
            return attrib.getResourceString(value);
        }
        return null;
    }

    private String getSchemaDescription(IPluginAttribute attr, ISchemaElement sEle) {
        String description = XMLComponentRegistry.Instance().getDescription(attr.getValue(), 2);
        if (description == null) {
            URL url = sEle.getSchema().getURL();
            SchemaAnnotationHandler handler = new SchemaAnnotationHandler();
            SchemaUtil.parseURL((URL)url, (DefaultHandler)handler);
            description = handler.getDescription();
            XMLComponentRegistry.Instance().putDescription(attr.getValue(), description, 2);
        }
        return description;
    }

    private String getElementText(ISchemaElement sEle) {
        if (sEle == null) {
            return null;
        }
        return sEle.getDescription();
    }

    private String checkTranslatedValue(IDocumentTextNode node) {
        String value = node.getText();
        if (value.startsWith("%")) {
            return ((IPluginObject)node.getEnclosingElement()).getResourceString(value);
        }
        return null;
    }
}

