/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.composer.api.objects;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.php.composer.api.collection.JsonArray;
import org.eclipse.php.composer.api.entities.JsonEntity;
import org.eclipse.php.composer.api.entities.JsonValue;
import org.eclipse.php.composer.api.objects.JsonObject;

public class Script
extends JsonObject {
    private transient JsonArray handlers = new JsonArray();

    public Script() {
        this.listen();
        this.handlers.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                Script.this.firePropertyChange(String.valueOf(Script.this.getScript()) + "." + evt.getPropertyName(), evt.getOldValue(), evt.getNewValue());
            }
        });
    }

    public Script(String scriptname, HandlerValue handler) {
        this();
        this.setScript(scriptname);
        this.add(handler);
    }

    @Override
    protected Object buildJson() {
        try {
            Method mtd = JsonEntity.class.getDeclaredMethod("buildJson", new Class[0]);
            return mtd.invoke((Object)this.handlers, new Object[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    protected List<String> getOwnProperties() {
        String[] props = new String[]{"handlers"};
        ArrayList<String> list = new ArrayList<String>(Arrays.asList(props));
        list.addAll(super.getOwnProperties());
        return list;
    }

    public String getScript() {
        return this.getAsString("script");
    }

    public void setScript(String script) {
        this.set("script", script);
    }

    public HandlerValue get(int index) throws IndexOutOfBoundsException {
        return (HandlerValue)this.handlers.get(index);
    }

    public void add(HandlerValue handler) {
        this.handlers.add(handler);
        handler.setIndex(this.handlers.size() - 1);
    }

    public void add(int index, HandlerValue handler) throws IndexOutOfBoundsException {
        this.handlers.add(index, handler);
        handler.setIndex(index);
    }

    public void remove(int index) throws IndexOutOfBoundsException {
        this.handlers.remove(index);
        this.updateIndexes();
    }

    @Override
    public boolean has(String handler) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        this.handlers.clear();
    }

    public void addHandlers(JsonArray handlers) {
        if (handlers == this.handlers) {
            return;
        }
        for (Object handler : handlers) {
            this.add((HandlerValue)handler);
        }
    }

    public void addHandlers(Script script) {
        if (script == this) {
            return;
        }
        this.addHandlers(script.getHandlers());
    }

    private void updateIndexes() {
        int index = 0;
        for (Object handler : this.handlers) {
            ((HandlerValue)handler).setIndex(index++);
        }
    }

    public Object getHandlersJsonValue() {
        return this.getJsonValue(this.handlers);
    }

    public HandlerValue getFirst() {
        return (HandlerValue)this.handlers.get(0);
    }

    private JsonArray getHandlers() {
        return this.handlers;
    }

    public void remove(HandlerValue handler) {
        this.handlers.remove(handler);
        this.updateIndexes();
    }

    public void removeAll() {
        this.handlers.clear();
    }

    public HandlerValue[] toArray() {
        return this.handlers.toArray(new HandlerValue[0]);
    }

    @Override
    public int size() {
        return this.handlers.size();
    }

    public Script clone() {
        Script clone = new Script();
        this.cloneProperties(clone);
        clone.clear();
        for (Object value : this.handlers) {
            clone.add(((HandlerValue)value).clone());
        }
        return clone;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Script) {
            Script script = (Script)obj;
            return script == this || (this.getScript() == null ? script.getScript() == null : this.getScript().equals(script.getScript())) && this.getHandlers().equals(script.getHandlers());
        }
        return false;
    }

    public static class HandlerValue
    extends JsonValue {
        private transient int index = 0;

        public HandlerValue(String value) {
            super(value);
        }

        public void setIndex(int index) {
            this.index = index;
        }

        public void setValue(String value) {
            this.value = value;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof HandlerValue)) {
                return false;
            }
            HandlerValue other = (HandlerValue)obj;
            if (this.index != other.index) {
                return false;
            }
            String s1 = this.getAsString();
            String s2 = other.getAsString();
            if (s1 != null) {
                return s1.equals(s2);
            }
            return s1 == s2;
        }

        public HandlerValue clone() {
            HandlerValue clone = new HandlerValue(this.getAsString());
            clone.setIndex(this.index);
            return clone;
        }
    }
}

