/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.runtime.stepper;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.tcf.te.runtime.stepper.interfaces.IFullQualifiedId;

public class FullQualifiedId
implements IFullQualifiedId {
    private final List<IdData> ids = new ArrayList<IdData>();

    public FullQualifiedId(String type, String id, String secondaryId) {
        this.ids.add(new IdData(type, id, secondaryId));
    }

    private FullQualifiedId(IdData[] parentData, String type, String id, String secondaryId) {
        IdData[] idDataArray = parentData;
        int n = parentData.length;
        int n2 = 0;
        while (n2 < n) {
            IdData parent = idDataArray[n2];
            this.ids.add(new IdData(parent.type, parent.id, parent.secondaryId));
            ++n2;
        }
        if (id != null) {
            this.ids.add(new IdData(type, id, secondaryId));
        }
    }

    @Override
    public IFullQualifiedId createChildId(String type, String id, String secondaryId) {
        return new FullQualifiedId(this.ids.toArray(new IdData[this.ids.size()]), type, id, secondaryId);
    }

    @Override
    public String getType() {
        return this.getIdData().type;
    }

    @Override
    public String getId() {
        return this.getIdData().id;
    }

    @Override
    public String getSecondaryId() {
        return this.getIdData().secondaryId;
    }

    @Override
    public IFullQualifiedId getParentId() {
        if (this.ids.size() > 1) {
            return new FullQualifiedId(this.ids.subList(0, this.ids.size() - 1).toArray(new IdData[this.ids.size() - 1]), null, null, null);
        }
        return null;
    }

    public String toString() {
        Assert.isTrue((!this.ids.isEmpty() ? 1 : 0) != 0);
        String toString = this.getIdData().toString();
        if (this.ids.size() > 1) {
            int i = this.ids.size() - 1;
            while (i > 0) {
                toString = this.ids.get(i - 1).toString(toString);
                --i;
            }
        }
        return toString;
    }

    private IdData getIdData() {
        Assert.isTrue((!this.ids.isEmpty() ? 1 : 0) != 0);
        return this.ids.get(this.ids.size() - 1);
    }

    private class IdData {
        public String type = null;
        public String id = null;
        public String secondaryId = null;

        public IdData(String type, String id, String secondaryId) {
            Assert.isNotNull((Object)id);
            this.type = type;
            this.id = id;
            this.secondaryId = secondaryId;
        }

        public String toString(String children) {
            String typeStr = this.type != null && this.type.trim().length() > 0 ? this.type.trim() : "ID";
            StringBuilder toString = new StringBuilder();
            toString.append('<');
            toString.append(typeStr);
            toString.append(" id=\"");
            toString.append(this.id.trim());
            toString.append('\"');
            if (this.secondaryId != null && this.secondaryId.trim().length() > 0) {
                toString.append(" secondaryId=\"");
                toString.append(this.secondaryId.trim());
                toString.append('\"');
            }
            toString.append("/>");
            if (children != null && children.trim().length() > 0) {
                toString.append(children);
            }
            return toString.toString();
        }

        public String toString() {
            return this.toString(null);
        }
    }
}

