/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.filesystem.core.internal.url;

import java.io.IOException;
import java.io.InputStream;
import org.eclipse.tcf.protocol.IToken;
import org.eclipse.tcf.services.IFileSystem;
import org.eclipse.tcf.te.tcf.filesystem.core.internal.url.TcfURLConnection;
import org.eclipse.tcf.te.tcf.filesystem.core.nls.Messages;

public class TcfInputStream
extends InputStream {
    private static final int DEFAULT_CHUNK_SIZE = 5120;
    long position;
    byte[] buffer;
    int offset;
    boolean EOF;
    boolean closed;
    Exception ERROR;
    int chunk_size = 0;
    TcfURLConnection connection;

    public TcfInputStream(TcfURLConnection connection) {
        this(connection, 5120);
    }

    public TcfInputStream(TcfURLConnection connection, int chunk_size) {
        this.connection = connection;
        this.chunk_size = chunk_size;
    }

    @Override
    public int read() throws IOException {
        if (this.closed) {
            throw new IOException(Messages.TcfInputStream_StreamClosed);
        }
        if (this.ERROR != null) {
            IOException exception = new IOException(this.ERROR.toString());
            exception.initCause(this.ERROR);
            throw exception;
        }
        if (this.buffer == null) {
            if (this.EOF) {
                return -1;
            }
            this.readBlock();
            return this.read();
        }
        if (this.EOF) {
            if (this.offset == this.buffer.length) {
                return -1;
            }
            return 0xFF & this.buffer[this.offset++];
        }
        if (this.offset == this.buffer.length) {
            this.readBlock();
            return this.read();
        }
        return 0xFF & this.buffer[this.offset++];
    }

    private void readBlock() {
        this.connection.service.read(this.connection.handle, this.position, this.chunk_size, new IFileSystem.DoneRead(){

            public void doneRead(IToken token, IFileSystem.FileSystemException error, byte[] data, boolean eof) {
                if (error != null) {
                    TcfInputStream.this.ERROR = error;
                }
                if (data == null) {
                    TcfInputStream.this.ERROR = new IOException(Messages.TcfInputStream_NoDataAvailable);
                }
                TcfInputStream.this.EOF = eof;
                TcfInputStream.this.buffer = data;
                if (TcfInputStream.this.buffer != null) {
                    TcfInputStream.this.position += (long)TcfInputStream.this.buffer.length;
                }
                TcfInputStream.this.offset = 0;
            }
        });
    }

    @Override
    public void close() throws IOException {
        if (!this.closed) {
            this.connection.closeStream(this);
            this.closed = true;
        }
    }
}

