/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.analysis.profiling.core.callstack;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.analysis.profiling.core.callgraph.ICallGraphProvider;
import org.eclipse.tracecompass.analysis.profiling.core.callstack.CallStackHostUtils;
import org.eclipse.tracecompass.analysis.profiling.core.callstack.CallStackSeries;
import org.eclipse.tracecompass.analysis.profiling.core.callstack.IFlameChartProvider;
import org.eclipse.tracecompass.analysis.timing.core.segmentstore.IAnalysisProgressListener;
import org.eclipse.tracecompass.analysis.timing.core.segmentstore.ISegmentStoreProvider;
import org.eclipse.tracecompass.internal.analysis.profiling.core.callgraph.CallGraphAnalysis;
import org.eclipse.tracecompass.internal.analysis.profiling.core.callstack.SymbolAspect;
import org.eclipse.tracecompass.segmentstore.core.ISegment;
import org.eclipse.tracecompass.segmentstore.core.ISegmentStore;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystem;
import org.eclipse.tracecompass.tmf.core.event.aspect.ITmfEventAspect;
import org.eclipse.tracecompass.tmf.core.event.aspect.TmfCpuAspect;
import org.eclipse.tracecompass.tmf.core.event.aspect.TmfDeviceAspect;
import org.eclipse.tracecompass.tmf.core.exceptions.TmfAnalysisException;
import org.eclipse.tracecompass.tmf.core.segment.ISegmentAspect;
import org.eclipse.tracecompass.tmf.core.statesystem.TmfStateSystemAnalysisModule;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;

public abstract class CallStackAnalysis
extends TmfStateSystemAnalysisModule
implements IFlameChartProvider,
ICallGraphProvider {
    public static final String CALL_STACK = "CallStack";
    private static final String[] DEFAULT_PROCESSES_PATTERN = new String[]{"Processes", "*"};
    private static final String[] DEFAULT_THREADS_PATTERN = new String[]{"*"};
    private final CallGraphAnalysis fCallGraphAnalysis;
    private final ListenerList<IAnalysisProgressListener> fListeners = new ListenerList(1);
    private @Nullable CallStackSeries fCallStacks = null;
    private final List<String[]> fPatterns;
    private boolean fAutomaticCallgraph;

    protected CallStackAnalysis() {
        this.fCallGraphAnalysis = new CallGraphAnalysis(this);
        this.fPatterns = ImmutableList.of((Object)this.getProcessesPattern(), (Object)this.getThreadsPattern());
    }

    public String[] getProcessesPattern() {
        return DEFAULT_PROCESSES_PATTERN;
    }

    public @Nullable Long resolveDeviceId(int quark, long timestamp) {
        return null;
    }

    public @Nullable String resolveDeviceType(int quark, long timestamp) {
        ITmfTrace trace = this.getTrace();
        if (trace != null) {
            for (ITmfEventAspect aspect : trace.getEventAspects()) {
                if (!(aspect instanceof TmfCpuAspect)) continue;
                return ((TmfCpuAspect)aspect).getDeviceType();
            }
            for (ITmfEventAspect aspect : trace.getEventAspects()) {
                if (!(aspect instanceof TmfDeviceAspect)) continue;
                return ((TmfDeviceAspect)aspect).getDeviceType();
            }
        }
        return "unknown";
    }

    public String[] getThreadsPattern() {
        return DEFAULT_THREADS_PATTERN;
    }

    protected List<String[]> getPatterns() {
        return this.fPatterns;
    }

    protected boolean executeAnalysis(@Nullable IProgressMonitor monitor) {
        boolean result = super.executeAnalysis(monitor);
        if (!result) {
            return false;
        }
        if (this.fAutomaticCallgraph) {
            this.fCallGraphAnalysis.schedule();
        }
        return result;
    }

    public boolean setTrace(@NonNull ITmfTrace trace) throws TmfAnalysisException {
        boolean ret = super.setTrace(trace);
        if (!ret) {
            return ret;
        }
        ret = this.fCallGraphAnalysis.setTrace(trace);
        return ret;
    }

    public void dispose() {
        this.fCallGraphAnalysis.dispose();
        super.dispose();
    }

    @Override
    public @Nullable CallStackSeries getCallStackSeries() {
        CallStackSeries callstacks = this.fCallStacks;
        if (callstacks == null) {
            ITmfStateSystem ss = this.getStateSystem();
            ITmfTrace trace = this.getTrace();
            if (ss == null || trace == null) {
                return null;
            }
            this.fCallStacks = callstacks = new CallStackSeries(ss, this.getPatterns(), 0, "", this.getCallStackHostResolver(trace), this.getCallStackTidResolver());
        }
        return callstacks;
    }

    protected CallStackHostUtils.TraceHostIdResolver getCallStackHostResolver(ITmfTrace trace) {
        return new CallStackHostUtils.TraceHostIdResolver(trace);
    }

    protected @Nullable CallStackSeries.IThreadIdResolver getCallStackTidResolver() {
        return new CallStackSeries.AttributeValueThreadResolver(1);
    }

    public @Nullable ISegmentStore<ISegment> getSegmentStore() {
        CallStackSeries series = this.getCallStackSeries();
        if (series == null) {
            return null;
        }
        return series;
    }

    public void addListener(@NonNull IAnalysisProgressListener listener) {
        this.fListeners.add((Object)listener);
    }

    public void removeListener(@NonNull IAnalysisProgressListener listener) {
        this.fListeners.remove((Object)listener);
    }

    public Iterable<ISegmentAspect> getSegmentAspects() {
        return Collections.singletonList(SymbolAspect.SYMBOL_ASPECT);
    }

    protected Iterable<IAnalysisProgressListener> getListeners() {
        ArrayList<IAnalysisProgressListener> listeners = new ArrayList<IAnalysisProgressListener>();
        Object[] objectArray = this.fListeners.getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object listener = objectArray[n2];
            if (listener != null) {
                listeners.add((IAnalysisProgressListener)listener);
            }
            ++n2;
        }
        return listeners;
    }

    protected void sendUpdate(ISegmentStore<ISegment> store) {
        for (IAnalysisProgressListener listener : this.getListeners()) {
            listener.onComplete((ISegmentStoreProvider)this, store);
        }
    }

    public ICallGraphProvider getCallGraph() {
        return this.fCallGraphAnalysis;
    }

    @VisibleForTesting
    public void triggerAutomatically(boolean trigger) {
        this.fAutomaticCallgraph = trigger;
    }
}

