/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.cell.client;

import com.google.gwt.cell.client.AbstractEditableCell;
import com.google.gwt.cell.client.ValueUpdater;
import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.NativeEvent;
import com.google.gwt.event.logical.shared.CloseEvent;
import com.google.gwt.event.logical.shared.CloseHandler;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.i18n.client.DateTimeFormat;
import com.google.gwt.safehtml.shared.SafeHtmlBuilder;
import com.google.gwt.text.shared.SafeHtmlRenderer;
import com.google.gwt.text.shared.SimpleSafeHtmlRenderer;
import com.google.gwt.user.client.Event;
import com.google.gwt.user.client.ui.PopupPanel;
import com.google.gwt.user.datepicker.client.DatePicker;
import java.util.Date;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DatePickerCell
extends AbstractEditableCell<Date, Date> {
    private static final int ESCAPE = 27;
    private final DatePicker datePicker;
    private final DateTimeFormat format;
    private int offsetX = 10;
    private int offsetY = 10;
    private Object lastKey;
    private Element lastParent;
    private Date lastValue;
    private PopupPanel panel;
    private final SafeHtmlRenderer<String> renderer;
    private ValueUpdater<Date> valueUpdater;

    public DatePickerCell() {
        this(DateTimeFormat.getFullDateFormat(), SimpleSafeHtmlRenderer.getInstance());
    }

    public DatePickerCell(DateTimeFormat format) {
        this(format, SimpleSafeHtmlRenderer.getInstance());
    }

    public DatePickerCell(SafeHtmlRenderer<String> renderer) {
        this(DateTimeFormat.getFormat(DateTimeFormat.PredefinedFormat.DATE_FULL), renderer);
    }

    public DatePickerCell(DateTimeFormat format, SafeHtmlRenderer<String> renderer) {
        super("click", "keydown");
        if (format == null) {
            throw new IllegalArgumentException("format == null");
        }
        if (renderer == null) {
            throw new IllegalArgumentException("renderer == null");
        }
        this.format = format;
        this.renderer = renderer;
        this.datePicker = new DatePicker();
        this.panel = new PopupPanel(true, true){

            protected void onPreviewNativeEvent(Event.NativePreviewEvent event) {
                if (512 == event.getTypeInt() && event.getNativeEvent().getKeyCode() == 27) {
                    DatePickerCell.this.panel.hide();
                }
            }
        };
        this.panel.addCloseHandler(new CloseHandler<PopupPanel>(){

            @Override
            public void onClose(CloseEvent<PopupPanel> event) {
                DatePickerCell.this.lastKey = null;
                DatePickerCell.this.lastValue = null;
                if (DatePickerCell.this.lastParent != null && !event.isAutoClosed()) {
                    DatePickerCell.this.lastParent.focus();
                }
                DatePickerCell.this.lastParent = null;
            }
        });
        this.panel.add(this.datePicker);
        this.datePicker.addValueChangeHandler(new ValueChangeHandler<Date>(){

            @Override
            public void onValueChange(ValueChangeEvent<Date> event) {
                Element cellParent = DatePickerCell.this.lastParent;
                Date oldValue = DatePickerCell.this.lastValue;
                Object key = DatePickerCell.this.lastKey;
                DatePickerCell.this.panel.hide();
                Date date = event.getValue();
                DatePickerCell.this.setViewData(key, date);
                DatePickerCell.this.setValue(cellParent, oldValue, key);
                if (DatePickerCell.this.valueUpdater != null) {
                    DatePickerCell.this.valueUpdater.update(date);
                }
            }
        });
    }

    @Override
    public boolean isEditing(Element parent, Date value, Object key) {
        return this.lastKey != null && this.lastKey.equals(key);
    }

    @Override
    public void onBrowserEvent(Element parent, Date value, Object key, NativeEvent event, ValueUpdater<Date> valueUpdater) {
        super.onBrowserEvent(parent, value, key, event, valueUpdater);
        if ("click".equals(event.getType())) {
            this.onEnterKeyDown(parent, value, key, event, valueUpdater);
        }
    }

    @Override
    public void render(Date value, Object key, SafeHtmlBuilder sb) {
        Date viewData = (Date)this.getViewData(key);
        if (viewData != null && viewData.equals(value)) {
            this.clearViewData(key);
            viewData = null;
        }
        String s = null;
        if (viewData != null) {
            s = this.format.format(viewData);
        } else if (value != null) {
            s = this.format.format(value);
        }
        if (s != null) {
            sb.append(this.renderer.render(s));
        }
    }

    @Override
    protected void onEnterKeyDown(final Element parent, Date value, Object key, NativeEvent event, ValueUpdater<Date> valueUpdater) {
        this.lastKey = key;
        this.lastParent = parent;
        this.lastValue = value;
        this.valueUpdater = valueUpdater;
        Date viewData = (Date)this.getViewData(key);
        Date date = viewData == null ? value : viewData;
        this.datePicker.setCurrentMonth(date);
        this.datePicker.setValue(date);
        this.panel.setPopupPositionAndShow(new PopupPanel.PositionCallback(){

            public void setPosition(int offsetWidth, int offsetHeight) {
                DatePickerCell.this.panel.setPopupPosition(parent.getAbsoluteLeft() + DatePickerCell.this.offsetX, parent.getAbsoluteTop() + DatePickerCell.this.offsetY);
            }
        });
    }
}

