/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.user.datepicker.client;

import com.google.gwt.core.client.GWT;
import com.google.gwt.editor.client.IsEditor;
import com.google.gwt.editor.client.LeafValueEditor;
import com.google.gwt.editor.client.adapters.TakesValueEditor;
import com.google.gwt.event.dom.client.BlurEvent;
import com.google.gwt.event.dom.client.BlurHandler;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.dom.client.FocusEvent;
import com.google.gwt.event.dom.client.FocusHandler;
import com.google.gwt.event.dom.client.KeyDownEvent;
import com.google.gwt.event.dom.client.KeyDownHandler;
import com.google.gwt.event.logical.shared.CloseEvent;
import com.google.gwt.event.logical.shared.CloseHandler;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.i18n.client.DateTimeFormat;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.DeferredCommand;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.HasValue;
import com.google.gwt.user.client.ui.PopupPanel;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.datepicker.client.DateChangeEvent;
import com.google.gwt.user.datepicker.client.DatePicker;
import java.util.Date;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DateBox
extends Composite
implements HasValue<Date>,
IsEditor<LeafValueEditor<Date>> {
    private static final String DATE_BOX_FORMAT_ERROR = "dateBoxFormatError";
    public static final String DEFAULT_STYLENAME = "gwt-DateBox";
    private static final DefaultFormat DEFAULT_FORMAT = (DefaultFormat)GWT.create(DefaultFormat.class);
    private final PopupPanel popup;
    private final TextBox box = new TextBox();
    private final DatePicker picker;
    private Format format;
    private boolean allowDPShow = true;

    public DateBox() {
        this(new DatePicker(), null, DEFAULT_FORMAT);
    }

    public DateBox(DatePicker picker, Date date, Format format) {
        this.picker = picker;
        this.popup = new PopupPanel(true);
        assert (format != null) : "You may not construct a date box with a null format";
        this.format = format;
        this.popup.addAutoHidePartner(this.box.getElement());
        this.popup.setWidget(picker);
        this.popup.setStyleName("dateBoxPopup");
        this.initWidget(this.box);
        this.setStyleName(DEFAULT_STYLENAME);
        DateBoxHandler handler = new DateBoxHandler();
        picker.addValueChangeHandler(handler);
        this.box.addFocusHandler(handler);
        this.box.addBlurHandler(handler);
        this.box.addClickHandler(handler);
        this.box.addKeyDownHandler(handler);
        this.popup.addCloseHandler(handler);
        this.setValue(date);
    }

    @Override
    public HandlerRegistration addValueChangeHandler(ValueChangeHandler<Date> handler) {
        return this.addHandler(handler, ValueChangeEvent.getType());
    }

    @Override
    public LeafValueEditor<Date> asEditor() {
        return TakesValueEditor.of(this);
    }

    public int getCursorPos() {
        return this.box.getCursorPos();
    }

    public DatePicker getDatePicker() {
        return this.picker;
    }

    public Format getFormat() {
        return this.format;
    }

    public int getTabIndex() {
        return this.box.getTabIndex();
    }

    public TextBox getTextBox() {
        return this.box;
    }

    @Override
    public Date getValue() {
        return this.parseDate(true);
    }

    public void hideDatePicker() {
        this.popup.hide();
    }

    public boolean isDatePickerShowing() {
        return this.popup.isShowing();
    }

    public void setAccessKey(char key) {
        this.box.setAccessKey(key);
    }

    public void setEnabled(boolean enabled) {
        this.box.setEnabled(enabled);
    }

    public void setFocus(boolean focused) {
        this.box.setFocus(focused);
    }

    public void setFormat(Format format) {
        assert (format != null) : "A Date box may not have a null format";
        if (this.format != format) {
            Date date = this.getValue();
            this.format.reset(this, true);
            this.format = format;
            this.setValue(date);
        }
    }

    public void setTabIndex(int index) {
        this.box.setTabIndex(index);
    }

    @Override
    public void setValue(Date date) {
        this.setValue(date, false);
    }

    @Override
    public void setValue(Date date, boolean fireEvents) {
        this.setValue(this.picker.getValue(), date, fireEvents);
    }

    public void showDatePicker() {
        Date current = this.parseDate(false);
        if (current == null) {
            current = new Date();
        }
        this.picker.setCurrentMonth(current);
        this.popup.showRelativeTo(this);
    }

    private Date parseDate(boolean reportError) {
        if (reportError) {
            this.getFormat().reset(this, false);
        }
        String text = this.box.getText().trim();
        return this.getFormat().parse(this, text, reportError);
    }

    private void preventDatePickerPopup() {
        this.allowDPShow = false;
        DeferredCommand.addCommand(new Command(){

            public void execute() {
                DateBox.this.allowDPShow = true;
            }
        });
    }

    private void setValue(Date oldDate, Date date, boolean fireEvents) {
        if (date != null) {
            this.picker.setCurrentMonth(date);
        }
        this.picker.setValue(date, false);
        this.format.reset(this, false);
        this.box.setText(this.getFormat().format(this, date));
        if (fireEvents) {
            DateChangeEvent.fireIfNotEqualDates(this, oldDate, date);
        }
    }

    private void updateDateFromTextBox() {
        Date parsedDate = this.parseDate(true);
        if (parsedDate != null) {
            this.setValue(this.picker.getValue(), parsedDate, true);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class DateBoxHandler
    implements ValueChangeHandler<Date>,
    FocusHandler,
    BlurHandler,
    ClickHandler,
    KeyDownHandler,
    CloseHandler<PopupPanel> {
        private DateBoxHandler() {
        }

        @Override
        public void onBlur(BlurEvent event) {
            if (!DateBox.this.isDatePickerShowing()) {
                DateBox.this.updateDateFromTextBox();
            }
        }

        @Override
        public void onClick(ClickEvent event) {
            DateBox.this.showDatePicker();
        }

        @Override
        public void onClose(CloseEvent<PopupPanel> event) {
            if (DateBox.this.allowDPShow) {
                DateBox.this.updateDateFromTextBox();
            }
        }

        @Override
        public void onFocus(FocusEvent event) {
            if (DateBox.this.allowDPShow && !DateBox.this.isDatePickerShowing()) {
                DateBox.this.showDatePicker();
            }
        }

        @Override
        public void onKeyDown(KeyDownEvent event) {
            switch (event.getNativeKeyCode()) {
                case 9: 
                case 13: {
                    DateBox.this.updateDateFromTextBox();
                }
                case 27: 
                case 38: {
                    DateBox.this.hideDatePicker();
                    break;
                }
                case 40: {
                    DateBox.this.showDatePicker();
                }
            }
        }

        @Override
        public void onValueChange(ValueChangeEvent<Date> event) {
            DateBox.this.setValue(DateBox.this.parseDate(false), event.getValue(), true);
            DateBox.this.hideDatePicker();
            DateBox.this.preventDatePickerPopup();
            DateBox.this.box.setFocus(true);
        }
    }

    public static interface Format {
        public String format(DateBox var1, Date var2);

        public Date parse(DateBox var1, String var2, boolean var3);

        public void reset(DateBox var1, boolean var2);
    }

    public static class DefaultFormat
    implements Format {
        private final DateTimeFormat dateTimeFormat;

        public DefaultFormat() {
            this.dateTimeFormat = DateTimeFormat.getMediumDateTimeFormat();
        }

        public DefaultFormat(DateTimeFormat dateTimeFormat) {
            this.dateTimeFormat = dateTimeFormat;
        }

        public String format(DateBox box, Date date) {
            if (date == null) {
                return "";
            }
            return this.dateTimeFormat.format(date);
        }

        public DateTimeFormat getDateTimeFormat() {
            return this.dateTimeFormat;
        }

        public Date parse(DateBox dateBox, String dateText, boolean reportError) {
            Date date = null;
            try {
                if (dateText.length() > 0) {
                    date = this.dateTimeFormat.parse(dateText);
                }
            }
            catch (IllegalArgumentException exception) {
                try {
                    date = new Date(dateText);
                }
                catch (IllegalArgumentException e) {
                    if (reportError) {
                        dateBox.addStyleName(DateBox.DATE_BOX_FORMAT_ERROR);
                    }
                    return null;
                }
            }
            return date;
        }

        public void reset(DateBox dateBox, boolean abandon) {
            dateBox.removeStyleName(DateBox.DATE_BOX_FORMAT_ERROR);
        }
    }
}

