/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.lsp.clangd.internal.config;

import java.io.IOException;
import java.io.InputStream;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Platform;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.error.Mark;
import org.yaml.snakeyaml.error.MarkedYAMLException;

public class ClangdConfigFileChecker {
    public static final String CLANGD_MARKER = "org.eclipse.cdt.lsp.clangd.config.marker";

    public void checkConfigFile(IFile configFile) {
        if (!configFile.exists()) {
            return;
        }
        Yaml yaml = new Yaml();
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (InputStream inputStream = configFile.getContents();){
                try {
                    this.removeMarkerFromClangdConfig(configFile);
                    yaml.load(inputStream);
                }
                catch (MarkedYAMLException yamlException) {
                    Throwable throwable2 = null;
                    Object var8_13 = null;
                    try (InputStream reReadStream = configFile.getContents();){
                        this.addMarkerToClangdConfig(configFile, yamlException, reReadStream.readAllBytes());
                    }
                    catch (Throwable throwable3) {
                        if (throwable2 == null) {
                            throwable2 = throwable3;
                        } else if (throwable2 != throwable3) {
                            throwable2.addSuppressed(throwable3);
                        }
                        throw throwable2;
                    }
                }
                catch (Exception exception) {
                    Platform.getLog(this.getClass()).error("Expected MarkedYAMLException, but was: " + exception.getMessage(), (Throwable)exception);
                }
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                } else if (throwable != throwable4) {
                    throwable.addSuppressed(throwable4);
                }
                throw throwable;
            }
        }
        catch (IOException | CoreException e) {
            Platform.getLog(this.getClass()).error(e.getMessage(), e);
        }
    }

    private void addMarkerToClangdConfig(IFile configFile, MarkedYAMLException yamlException, byte[] buffer) {
        try {
            ClangdConfigMarker configMarker = this.parseYamlException(yamlException, buffer);
            IMarker marker = configFile.createMarker(CLANGD_MARKER);
            marker.setAttribute("message", (Object)configMarker.message);
            marker.setAttribute("severity", 2);
            marker.setAttribute("lineNumber", configMarker.line);
            marker.setAttribute("charStart", configMarker.charStart);
            marker.setAttribute("charEnd", configMarker.charEnd);
        }
        catch (CoreException core) {
            Platform.getLog(this.getClass()).log(core.getStatus());
        }
    }

    private void removeMarkerFromClangdConfig(IFile configFile) {
        try {
            configFile.deleteMarkers(CLANGD_MARKER, false, 0);
        }
        catch (CoreException e) {
            Platform.getLog(this.getClass()).log(e.getStatus());
        }
    }

    private ClangdConfigMarker parseYamlException(MarkedYAMLException exception, byte[] buffer) {
        ClangdConfigMarker marker = new ClangdConfigMarker();
        String context = exception.getContext();
        marker.message = context != null ? context + " " + exception.getProblem() : exception.getProblem();
        Mark problemMark = exception.getProblemMark();
        if (problemMark == null) {
            return marker;
        }
        marker.line = problemMark.getLine() + 1;
        int index = problemMark.getIndex();
        if (index == buffer.length) {
            index = this.getIndexOfLastVisibleChar(buffer);
        }
        marker.charStart = index;
        marker.charEnd = index + 1;
        return marker;
    }

    private int getIndexOfLastVisibleChar(byte[] buffer) {
        int i = buffer.length - 1;
        while (i >= 0) {
            if ('\r' != (char)buffer[i] && '\n' != (char)buffer[i]) {
                return i;
            }
            --i;
        }
        return Math.max(0, buffer.length - 2);
    }

    private class ClangdConfigMarker {
        public String message;
        public int line = 1;
        public int charStart = -1;
        public int charEnd = -1;

        private ClangdConfigMarker() {
        }
    }
}

