/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.lsp.clangd.internal.ui;

import org.eclipse.cdt.lsp.clangd.ClangdConfiguration;
import org.eclipse.cdt.lsp.clangd.ClangdMetadata;
import org.eclipse.cdt.lsp.clangd.ClangdOptions;
import org.eclipse.cdt.lsp.clangd.internal.ui.ClangdConfigurationArea;
import org.eclipse.cdt.lsp.config.Configuration;
import org.eclipse.cdt.lsp.ui.ConfigurationArea;
import org.eclipse.cdt.lsp.ui.EditorConfigurationPage;
import org.eclipse.cdt.lsp.util.LspUtils;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;

public final class ClangdConfigurationPage
extends EditorConfigurationPage {
    private final String id = "org.eclipse.cdt.lsp.clangd.editor.preferencePage";

    public void init(IWorkbench workbench) {
        this.configuration = (Configuration)workbench.getService(ClangdConfiguration.class);
        this.workspace = (IWorkspace)workbench.getService(IWorkspace.class);
    }

    protected Configuration getConfiguration() {
        return (Configuration)PlatformUI.getWorkbench().getService(ClangdConfiguration.class);
    }

    protected ConfigurationArea getConfigurationArea(Composite composite, boolean isProjectScope) {
        return new ClangdConfigurationArea(composite, (ClangdMetadata)this.configuration.metadata(), isProjectScope);
    }

    protected String getPreferenceId() {
        return "org.eclipse.cdt.lsp.clangd.editor.preferencePage";
    }

    public boolean performOk() {
        boolean configSettingsChanged = this.configurationSettingsChanged();
        boolean projectOptionsDifferFromWorkspace = this.projectOptionsDifferFromWorkspace();
        boolean done = super.performOk();
        if (done && this.isLsActive() && ((!this.projectScope().isPresent() || this.useProjectSettings()) && configSettingsChanged || projectOptionsDifferFromWorkspace)) {
            this.restartClangd();
        }
        return done;
    }

    private void restartClangd() {
        LspUtils.getLanguageServers().forEach(w -> w.restart());
    }

    private boolean configurationSettingsChanged() {
        return ((ClangdConfigurationArea)this.area).optionsChanged((ClangdOptions)this.configuration.options((Object)this.getElement()));
    }

    private boolean projectOptionsDifferFromWorkspace() {
        return this.hasProjectSpecificOptions() != this.useProjectSettings() && ((ClangdConfigurationArea)this.area).optionsChanged((ClangdOptions)this.configuration.options(null));
    }

    private boolean isLsActive() {
        return LspUtils.getLanguageServers().findAny().isPresent();
    }

    protected boolean hasProjectSpecificOptions() {
        return this.projectScope().map(p -> p.getNode(this.configuration.qualifier())).map(n -> n.get(((ClangdMetadata)this.configuration.metadata()).clangdPath().identifer(), null)).isPresent();
    }
}

