/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.meson.core;

import com.google.gson.Gson;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.cdt.core.ConsoleOutputStream;
import org.eclipse.cdt.core.ErrorParserManager;
import org.eclipse.cdt.core.IConsoleParser;
import org.eclipse.cdt.core.IMarkerGenerator;
import org.eclipse.cdt.core.build.CBuildConfiguration;
import org.eclipse.cdt.core.build.IToolChain;
import org.eclipse.cdt.core.envvar.EnvironmentVariable;
import org.eclipse.cdt.core.envvar.IEnvironmentVariable;
import org.eclipse.cdt.core.resources.IConsole;
import org.eclipse.cdt.internal.meson.core.CompileCommand;
import org.eclipse.cdt.internal.meson.core.MesonUtils;
import org.eclipse.cdt.internal.meson.core.Messages;
import org.eclipse.cdt.meson.core.Activator;
import org.eclipse.cdt.meson.core.IMesonToolChainFile;
import org.eclipse.cdt.meson.core.IMesonToolChainManager;
import org.eclipse.core.resources.IBuildConfiguration;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;

public class MesonBuildConfiguration
extends CBuildConfiguration {
    private static final String TOOLCHAIN_FILE = "cdt.meson.toolchainfile";
    private IMesonToolChainFile toolChainFile;

    public MesonBuildConfiguration(IBuildConfiguration config, String name) throws CoreException {
        super(config, name);
        IMesonToolChainManager manager = Activator.getService(IMesonToolChainManager.class);
        Preferences settings = this.getSettings();
        String pathStr = settings.get(TOOLCHAIN_FILE, "");
        if (!pathStr.isEmpty()) {
            java.nio.file.Path path = Paths.get(pathStr, new String[0]);
            this.toolChainFile = manager.getToolChainFile(path);
        } else {
            this.toolChainFile = manager.getToolChainFileFor(this.getToolChain());
            if (this.toolChainFile != null) {
                this.saveToolChainFile();
            }
        }
    }

    public MesonBuildConfiguration(IBuildConfiguration config, String name, IToolChain toolChain) {
        this(config, name, toolChain, null, "run");
    }

    public MesonBuildConfiguration(IBuildConfiguration config, String name, IToolChain toolChain, IMesonToolChainFile toolChainFile, String launchMode) {
        super(config, name, toolChain, launchMode);
        this.toolChainFile = toolChainFile;
        if (toolChainFile != null) {
            this.saveToolChainFile();
        }
    }

    private void saveToolChainFile() {
        Preferences settings = this.getSettings();
        settings.put(TOOLCHAIN_FILE, this.toolChainFile.getPath().toString());
        try {
            settings.flush();
        }
        catch (BackingStoreException e) {
            Activator.log(e);
        }
    }

    public IMesonToolChainFile getToolChainFile() {
        return this.toolChainFile;
    }

    private boolean isLocal() throws CoreException {
        IToolChain toolchain = this.getToolChain();
        return (Platform.getOS().equals(toolchain.getProperty("os")) || "linux-container".equals(toolchain.getProperty("os"))) && Platform.getOSArch().equals(toolchain.getProperty("arch"));
    }

    public IProject[] build(int kind, Map<String, String> args, IConsole console, IProgressMonitor monitor) throws CoreException {
        return this.build(kind, args, null, null, console, monitor);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IProject[] build(int kind, Map<String, String> args, String[] ninjaEnv, String[] ninjaArgs, IConsole console, IProgressMonitor monitor) throws CoreException {
        IProject project = this.getProject();
        try {
            boolean runMeson;
            project.deleteMarkers("org.eclipse.cdt.core.problem", false, 2);
            ConsoleOutputStream outStream = console.getOutputStream();
            java.nio.file.Path buildDir = this.getBuildDirectory();
            outStream.write(String.format(Messages.MesonBuildConfiguration_BuildingIn, buildDir.toString()));
            if (this.toolChainFile == null && !this.isLocal()) {
                IMesonToolChainManager manager = Activator.getService(IMesonToolChainManager.class);
                this.toolChainFile = manager.getToolChainFileFor(this.getToolChain());
                if (this.toolChainFile == null) {
                    console.getErrorStream().write(Messages.MesonBuildConfiguration_NoToolchainFile);
                    return null;
                }
            }
            boolean bl = runMeson = !Files.exists(buildDir.resolve("build.ninja"), new LinkOption[0]);
            if (runMeson) {
                String projOptions;
                ArrayList<String> commandList = new ArrayList<String>();
                String envStr = this.getProperty("meson.environment");
                ArrayList<EnvironmentVariable> envVars = new ArrayList<EnvironmentVariable>();
                if (envStr != null) {
                    List<String> envList = MesonUtils.stripEnvVars(envStr);
                    for (String s : envList) {
                        int index = s.indexOf("=");
                        if (index == -1) {
                            envVars.add(new EnvironmentVariable(s));
                            continue;
                        }
                        envVars.add(new EnvironmentVariable(s.substring(0, index), s.substring(index + 1)));
                    }
                }
                commandList.add("meson");
                String userArgs = this.getProperty("meson.arguments");
                if (userArgs != null && !userArgs.isEmpty()) {
                    commandList.addAll(Arrays.asList(userArgs.split(" ")));
                }
                if ((projOptions = this.getProperty("meson.project.options")) != null && !projOptions.isEmpty()) {
                    commandList.addAll(Arrays.asList(projOptions.split(" ")));
                }
                commandList.add(this.getBuildDirectory().toString());
                monitor.subTask(Messages.MesonBuildConfiguration_RunningMeson);
                outStream.write(String.join((CharSequence)" ", new CharSequence[]{envStr != null ? "env " + envStr : "", "sh -c \"meson", userArgs != null ? userArgs : "", projOptions != null ? projOptions : "", this.getBuildDirectory().getParent().getParent().toString() + "\"\n"}));
                Path workingDir = new Path(this.getBuildDirectory().getParent().getParent().toString());
                Process p = this.startBuildProcess(commandList, envVars.toArray(new IEnvironmentVariable[0]), (IPath)workingDir, console, monitor);
                if (p == null) {
                    console.getErrorStream().write(String.format(Messages.MesonBuildConfiguration_RunningMesonFailure, ""));
                    return null;
                }
                this.watchProcess(console, monitor);
            }
            if (!Files.exists(buildDir.resolve("build.ninja"), new LinkOption[0])) {
                console.getErrorStream().write(String.format(Messages.MesonBuildConfiguration_NoNinjaFile, ""));
                return null;
            }
            Throwable throwable = null;
            Object var12_15 = null;
            try (ErrorParserManager epm = new ErrorParserManager(project, this.getBuildDirectoryURI(), (IMarkerGenerator)this, this.getToolChain().getErrorParserIds());){
                int n;
                epm.setOutputStream((OutputStream)console.getOutputStream());
                String buildCommand = this.getProperty("meson.command.build");
                if (buildCommand == null || buildCommand.isEmpty()) {
                    buildCommand = "ninja";
                }
                monitor.subTask(Messages.MesonBuildConfiguration_RunningNinja);
                ArrayList<String> commandList = new ArrayList<String>();
                ArrayList<EnvironmentVariable> envList = new ArrayList<EnvironmentVariable>();
                if (ninjaEnv != null) {
                    String[] stringArray = ninjaEnv;
                    n = ninjaEnv.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String s = stringArray[n2];
                        int index = s.indexOf("=");
                        if (index == -1) {
                            envList.add(new EnvironmentVariable(s));
                        } else {
                            envList.add(new EnvironmentVariable(s.substring(0, index), s.substring(index + 1)));
                        }
                        ++n2;
                    }
                }
                IEnvironmentVariable[] env = envList.toArray(new IEnvironmentVariable[0]);
                commandList.add(buildCommand);
                if (ninjaArgs == null) {
                    commandList.add("-v");
                } else {
                    String[] stringArray = ninjaArgs;
                    int n3 = ninjaArgs.length;
                    n = 0;
                    while (n < n3) {
                        String arg = stringArray[n];
                        if (!arg.isEmpty()) {
                            commandList.add(arg);
                        }
                        ++n;
                    }
                }
                Path workingDir = new Path(this.getBuildDirectory().toString());
                Process p = this.startBuildProcess(commandList, env, (IPath)workingDir, console, monitor);
                if (p == null) {
                    console.getErrorStream().write(String.format(Messages.MesonBuildConfiguration_RunningNinjaFailure, ""));
                    return null;
                }
                this.watchProcess(new IConsoleParser[]{epm}, monitor);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                    throw throwable;
                }
                if (throwable == throwable2) throw throwable;
                throwable.addSuppressed(throwable2);
                throw throwable;
            }
            project.refreshLocal(2, monitor);
            this.refreshScannerInfo();
            outStream.write(String.format(Messages.MesonBuildConfiguration_BuildingComplete, buildDir.toString()));
            return new IProject[]{project};
        }
        catch (IOException e) {
            throw new CoreException(Activator.errorStatus(String.format(Messages.MesonBuildConfiguration_Building, project.getName()), e));
        }
    }

    public void clean(IConsole console, IProgressMonitor monitor) throws CoreException {
        IProject project = this.getProject();
        try {
            project.deleteMarkers("org.eclipse.cdt.core.problem", false, 2);
            ConsoleOutputStream outStream = console.getOutputStream();
            java.nio.file.Path buildDir = this.getBuildDirectory();
            outStream.write(String.format(Messages.MesonBuildConfiguration_BuildingIn, buildDir.toString()));
            if (!Files.exists(buildDir.resolve("build.ninja"), new LinkOption[0])) {
                console.getOutputStream().write(Messages.MesonBuildConfiguration_NoNinjaFileToClean);
                return;
            }
            Throwable throwable = null;
            Object var7_9 = null;
            try (ErrorParserManager epm = new ErrorParserManager(project, this.getBuildDirectoryURI(), (IMarkerGenerator)this, this.getToolChain().getErrorParserIds());){
                epm.setOutputStream((OutputStream)console.getOutputStream());
                ArrayList<String> commandList = new ArrayList<String>();
                String cleanCommand = this.getProperty("meson.command.clean");
                if (cleanCommand == null) {
                    commandList.add("ninja");
                    commandList.add("clean");
                    commandList.add("-v");
                } else {
                    commandList.addAll(Arrays.asList(cleanCommand.split(" ")));
                }
                Path workingDir = new Path(buildDir.toString());
                IEnvironmentVariable[] env = new IEnvironmentVariable[]{};
                outStream.write(String.join((CharSequence)" ", commandList) + "\n");
                Process p = this.startBuildProcess(commandList, env, (IPath)workingDir, console, monitor);
                if (p == null) {
                    console.getErrorStream().write(String.format(Messages.MesonBuildConfiguration_RunningNinjaFailure, ""));
                    return;
                }
                this.watchProcess(console, monitor);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            outStream.write(String.format(Messages.MesonBuildConfiguration_BuildingComplete, buildDir.toString()));
            project.refreshLocal(2, monitor);
        }
        catch (IOException e) {
            throw new CoreException(Activator.errorStatus(String.format(Messages.MesonBuildConfiguration_Cleaning, project.getName()), e));
        }
    }

    public void refreshScannerInfo() throws CoreException {
        Job job = new Job(Messages.MesonBuildConfiguration_RefreshingScannerInfo){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    MesonBuildConfiguration.this.processCompileCommandsFile(monitor);
                }
                catch (CoreException e) {
                    return e.getStatus();
                }
                return Status.OK_STATUS;
            }
        };
        job.schedule();
    }

    private void processCompileCommandsFile(IProgressMonitor monitor) throws CoreException {
        IProject project = this.getProject();
        java.nio.file.Path commandsFile = this.getBuildDirectory().resolve("compile_commands.json");
        if (Files.exists(commandsFile, new LinkOption[0])) {
            ArrayList jobsList = new ArrayList();
            monitor.setTaskName(Messages.MesonBuildConfiguration_ProcCompJson);
            try {
                Throwable throwable = null;
                Object var6_8 = null;
                try (FileReader reader = new FileReader(commandsFile.toFile());){
                    Gson gson = new Gson();
                    CompileCommand[] commands = (CompileCommand[])gson.fromJson((Reader)reader, CompileCommand[].class);
                    if (commands == null) {
                        throw new CoreException(Activator.errorStatus(String.format(Messages.MesonBuildConfiguration_ProcCompCmds, project.getName()), new NullPointerException(Messages.MesonBuildConfiguration_StillNull)));
                    }
                    HashMap<String, CompileCommand> dedupedCmds = new HashMap<String, CompileCommand>();
                    CompileCommand[] compileCommandArray = commands;
                    int n = commands.length;
                    int n2 = 0;
                    while (n2 < n) {
                        CompileCommand command = compileCommandArray[n2];
                        dedupedCmds.put(command.getFile(), command);
                        ++n2;
                    }
                    for (CompileCommand command : dedupedCmds.values()) {
                        this.processLine(command.getCommand(), jobsList);
                    }
                    for (Job j : jobsList) {
                        try {
                            j.join();
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                    this.shutdown();
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException e) {
                throw new CoreException(Activator.errorStatus(String.format(Messages.MesonBuildConfiguration_ProcCompCmds, project.getName()), e));
            }
        }
    }
}

