/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.ibm.db2.luw.catalog;

import java.io.File;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.datatools.connectivity.sqm.core.definition.DataModelElementFactory;
import org.eclipse.datatools.connectivity.sqm.core.definition.DatabaseDefinition;
import org.eclipse.datatools.connectivity.sqm.core.rte.ICatalogObject;
import org.eclipse.datatools.connectivity.sqm.core.rte.RefreshManager;
import org.eclipse.datatools.connectivity.sqm.internal.core.RDBCorePlugin;
import org.eclipse.datatools.connectivity.sqm.internal.core.connection.ConnectionFilter;
import org.eclipse.datatools.connectivity.sqm.internal.core.connection.ConnectionInfo;
import org.eclipse.datatools.connectivity.sqm.internal.core.connection.DatabaseConnectionRegistry;
import org.eclipse.datatools.enablement.ibm.catalog.util.CatalogLoadUtil;
import org.eclipse.datatools.enablement.ibm.db2.luw.DB2LUWPluginActivator;
import org.eclipse.datatools.enablement.ibm.db2.luw.catalog.LUWCatalogAlias;
import org.eclipse.datatools.enablement.ibm.db2.luw.catalog.LUWCatalogArrayDataType;
import org.eclipse.datatools.enablement.ibm.db2.luw.catalog.LUWCatalogCursorDataType;
import org.eclipse.datatools.enablement.ibm.db2.luw.catalog.LUWCatalogDatabase;
import org.eclipse.datatools.enablement.ibm.db2.luw.catalog.LUWCatalogDatabasePackage;
import org.eclipse.datatools.enablement.ibm.db2.luw.catalog.LUWCatalogDistinctUserDefinedType;
import org.eclipse.datatools.enablement.ibm.db2.luw.catalog.LUWCatalogFederatedProcedure;
import org.eclipse.datatools.enablement.ibm.db2.luw.catalog.LUWCatalogGlobalVariable;
import org.eclipse.datatools.enablement.ibm.db2.luw.catalog.LUWCatalogIndex;
import org.eclipse.datatools.enablement.ibm.db2.luw.catalog.LUWCatalogJar;
import org.eclipse.datatools.enablement.ibm.db2.luw.catalog.LUWCatalogMaterializedQueryTable;
import org.eclipse.datatools.enablement.ibm.db2.luw.catalog.LUWCatalogNickname;
import org.eclipse.datatools.enablement.ibm.db2.luw.catalog.LUWCatalogPrivilege;
import org.eclipse.datatools.enablement.ibm.db2.luw.catalog.LUWCatalogProcedure;
import org.eclipse.datatools.enablement.ibm.db2.luw.catalog.LUWCatalogRowDataType;
import org.eclipse.datatools.enablement.ibm.db2.luw.catalog.LUWCatalogSequence;
import org.eclipse.datatools.enablement.ibm.db2.luw.catalog.LUWCatalogStructuredUserDefinedType;
import org.eclipse.datatools.enablement.ibm.db2.luw.catalog.LUWCatalogTable;
import org.eclipse.datatools.enablement.ibm.db2.luw.catalog.LUWCatalogUserDefinedFunction;
import org.eclipse.datatools.enablement.ibm.db2.luw.catalog.LUWCatalogView;
import org.eclipse.datatools.enablement.ibm.db2.luw.catalog.LUWCatalogXmlSchema;
import org.eclipse.datatools.enablement.ibm.db2.luw.catalog.LUWOverwriteStatus;
import org.eclipse.datatools.enablement.ibm.db2.luw.catalog.ModuleCatalogProvider;
import org.eclipse.datatools.enablement.ibm.db2.luw.catalog.OlapCatalogProvider;
import org.eclipse.datatools.enablement.ibm.db2.luw.catalog.util.LUWUtil;
import org.eclipse.datatools.enablement.ibm.db2.luw.model.CursorBlockType;
import org.eclipse.datatools.enablement.ibm.db2.luw.model.ExplainSnaphotType;
import org.eclipse.datatools.enablement.ibm.db2.luw.model.LUWArrayDataType;
import org.eclipse.datatools.enablement.ibm.db2.luw.model.LUWIndex;
import org.eclipse.datatools.enablement.ibm.db2.luw.model.LUWModule;
import org.eclipse.datatools.enablement.ibm.db2.luw.model.LUWPackage;
import org.eclipse.datatools.enablement.ibm.db2.model.DB2IdentitySpecifier;
import org.eclipse.datatools.enablement.ibm.db2.model.DB2IndexType;
import org.eclipse.datatools.enablement.ibm.db2.model.DB2Jar;
import org.eclipse.datatools.enablement.ibm.db2.model.DB2ModelPackage;
import org.eclipse.datatools.enablement.ibm.db2.model.DB2Package;
import org.eclipse.datatools.enablement.ibm.db2.model.DB2Schema;
import org.eclipse.datatools.enablement.ibm.db2.model.DB2XMLSchema;
import org.eclipse.datatools.enablement.ibm.db2.model.DB2XMLSchemaDecomposition;
import org.eclipse.datatools.enablement.ibm.db2.model.DB2XMLSchemaStatus;
import org.eclipse.datatools.enablement.ibm.db2.model.DataCaptureType;
import org.eclipse.datatools.enablement.ibm.db2.model.IsolationLevelType;
import org.eclipse.datatools.enablement.ibm.db2.model.OriginType;
import org.eclipse.datatools.enablement.ibm.db2.model.ReoptType;
import org.eclipse.datatools.enablement.ibm.db2.model.SourceDialect;
import org.eclipse.datatools.enablement.ibm.db2.model.impl.DB2SchemaImpl;
import org.eclipse.datatools.enablement.ibm.db2.util.DB2Version;
import org.eclipse.datatools.enablement.ibm.util.ModelHelper;
import org.eclipse.datatools.modelbase.dbdefinition.PredefinedDataTypeDefinition;
import org.eclipse.datatools.modelbase.sql.accesscontrol.AuthorizationIdentifier;
import org.eclipse.datatools.modelbase.sql.accesscontrol.Privilege;
import org.eclipse.datatools.modelbase.sql.datatypes.DataType;
import org.eclipse.datatools.modelbase.sql.datatypes.DistinctUserDefinedType;
import org.eclipse.datatools.modelbase.sql.datatypes.ElementType;
import org.eclipse.datatools.modelbase.sql.datatypes.PredefinedDataType;
import org.eclipse.datatools.modelbase.sql.datatypes.SQLDataType;
import org.eclipse.datatools.modelbase.sql.datatypes.SQLDataTypesPackage;
import org.eclipse.datatools.modelbase.sql.datatypes.StructuredUserDefinedType;
import org.eclipse.datatools.modelbase.sql.datatypes.UserDefinedType;
import org.eclipse.datatools.modelbase.sql.routines.DataAccess;
import org.eclipse.datatools.modelbase.sql.routines.Routine;
import org.eclipse.datatools.modelbase.sql.routines.SQLRoutinesPackage;
import org.eclipse.datatools.modelbase.sql.schema.Database;
import org.eclipse.datatools.modelbase.sql.schema.GenerateType;
import org.eclipse.datatools.modelbase.sql.schema.IdentitySpecifier;
import org.eclipse.datatools.modelbase.sql.schema.SQLObject;
import org.eclipse.datatools.modelbase.sql.schema.SQLSchemaPackage;
import org.eclipse.datatools.modelbase.sql.schema.Schema;
import org.eclipse.datatools.modelbase.sql.tables.Table;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;

public class LUWCatalogSchema
extends DB2SchemaImpl
implements ICatalogObject {
    private static OlapCatalogProvider olapCatalogProvider = null;
    private boolean tablesLoaded = false;
    private boolean routinesLoaded = false;
    private boolean jarsLoaded = false;
    private boolean xsrObjsLoaded = false;
    private boolean sequencesLoaded = false;
    private boolean userDefinedTypesLoaded = false;
    private boolean indicesLoaded = false;
    private boolean triggersLoaded = false;
    private boolean olapobjectLoaded = false;
    private boolean privilegeLoaded = false;
    private boolean packagesLoaded = false;
    private boolean moduleLoaded = false;
    private boolean globalVariableLoaded = false;
    private HashMap cachedTables = new HashMap();
    private HashMap cachedDB2Packages = new HashMap();

    public static OlapCatalogProvider getOlapCatalogProvider() {
        IExtensionRegistry pluginRegistry = Platform.getExtensionRegistry();
        IExtensionPoint extensionPoint = pluginRegistry.getExtensionPoint("com.ibm.datatools.db2.luw", "luwolapProvider");
        IExtension[] extensions = extensionPoint.getExtensions();
        if (extensions.length == 1) {
            IConfigurationElement[] configElements = extensions[0].getConfigurationElements();
            try {
                olapCatalogProvider = (OlapCatalogProvider)configElements[0].createExecutableExtension("class");
            }
            catch (Exception exception) {}
        }
        return olapCatalogProvider;
    }

    public synchronized void refresh() {
        this.tablesLoaded = false;
        this.routinesLoaded = false;
        this.jarsLoaded = false;
        this.indicesLoaded = false;
        this.triggersLoaded = false;
        this.sequencesLoaded = false;
        this.userDefinedTypesLoaded = false;
        if (this.olapobjectLoaded) {
            this.olapObjects.clear();
            this.olapobjectLoaded = false;
        }
        this.xsrObjsLoaded = false;
        this.privilegeLoaded = false;
        if (this.packagesLoaded) {
            this.packages.clear();
            this.packagesLoaded = false;
        }
        this.moduleLoaded = false;
        this.globalVariableLoaded = false;
        RefreshManager.getInstance().referesh((ICatalogObject)this);
    }

    public boolean isSystemObject() {
        return false;
    }

    public Connection getConnection() {
        Database database = this.getDatabase();
        return ((LUWCatalogDatabase)database).getConnection();
    }

    public Database getCatalogDatabase() {
        return this.getDatabase();
    }

    public EList getTables() {
        if (LUWOverwriteStatus.IS_OVERWRITE) {
            return super.getTables();
        }
        if (!this.tablesLoaded) {
            this.loadTables();
        }
        return this.tables;
    }

    public EList getRoutines() {
        if (LUWOverwriteStatus.IS_OVERWRITE) {
            return super.getRoutines();
        }
        if (!this.routinesLoaded) {
            this.loadRoutines();
        }
        return this.routines;
    }

    public EList getFederatedStoredProcedures() {
        if (!this.routinesLoaded) {
            this.loadRoutines();
        }
        return this.routines;
    }

    public EList getXsrObjects() {
        if (LUWOverwriteStatus.IS_OVERWRITE) {
            return super.getXsrObjects();
        }
        DB2Version db2Version = new DB2Version(this.getConnection());
        DatabaseDefinition databaseDefinition = RDBCorePlugin.getDefault().getDatabaseDefinitionRegistry().getDefinition(this.getDatabase());
        if (!this.xsrObjsLoaded && !this.getName().toUpperCase().startsWith("SYS") && db2Version.isUNO() && databaseDefinition.supportsXML()) {
            this.loadXsrObjects();
        } else {
            this.xsrObjects = super.getXsrObjects();
        }
        this.xsrObjsLoaded = true;
        return this.xsrObjects;
    }

    public EList getSequences() {
        if (LUWOverwriteStatus.IS_OVERWRITE) {
            return super.getSequences();
        }
        if (!this.sequencesLoaded) {
            this.loadSequences();
        }
        return this.sequences;
    }

    public EList getUserDefinedTypes() {
        if (LUWOverwriteStatus.IS_OVERWRITE) {
            return super.getUserDefinedTypes();
        }
        if (!this.userDefinedTypesLoaded) {
            this.loadUserDefinedTypes();
        }
        return this.userDefinedTypes;
    }

    public synchronized EList getTriggers() {
        if (LUWOverwriteStatus.IS_OVERWRITE) {
            return super.getTriggers();
        }
        if (!this.triggersLoaded) {
            this.loadTriggers();
        }
        return this.triggers;
    }

    public EList getIndices() {
        if (LUWOverwriteStatus.IS_OVERWRITE) {
            return super.getIndices();
        }
        if (!this.indicesLoaded) {
            this.loadIndices();
        }
        return this.indices;
    }

    public synchronized EList getOlapObjects() {
        if (LUWOverwriteStatus.IS_OVERWRITE) {
            return super.getOlapObjects();
        }
        if (!this.olapobjectLoaded) {
            this.loadOlapobjects();
        }
        return this.olapObjects;
    }

    public EList getPrivileges() {
        if (LUWOverwriteStatus.IS_OVERWRITE) {
            return super.getPrivileges();
        }
        if (!this.privilegeLoaded) {
            this.loadPrivileges();
        }
        return this.privileges;
    }

    public EList getPackages() {
        if (LUWOverwriteStatus.IS_OVERWRITE) {
            return super.getPackages();
        }
        if (!this.packagesLoaded) {
            this.loadPackages();
        }
        return this.packages;
    }

    public EList getModules() {
        if (LUWOverwriteStatus.IS_OVERWRITE) {
            return super.getModules();
        }
        if (!this.moduleLoaded) {
            this.loadModules();
        }
        return this.modules;
    }

    public EList getGlobalVariables() {
        if (LUWOverwriteStatus.IS_OVERWRITE) {
            return super.getGlobalVariables();
        }
        if (!this.globalVariableLoaded) {
            this.loadGlobaleVaraibles();
        }
        return this.globalVariables;
    }

    public boolean eIsSet(EStructuralFeature eFeature) {
        int id = this.eDerivedStructuralFeatureID(eFeature);
        if (id == 10) {
            this.getTables();
        } else if (id == 17) {
            this.getRoutines();
        } else if (id == 21) {
            this.getJars();
        } else if (id == 22) {
            this.getXsrObjects();
        } else if (id == 11) {
            this.getSequences();
        } else if (id == 15) {
            this.getUserDefinedTypes();
        } else if (id == 8) {
            this.getTriggers();
        } else if (id == 9) {
            this.getIndices();
        } else if (id == 20) {
            this.getOlapObjects();
        } else if (id == 7) {
            this.getPrivileges();
        } else if (id == 23) {
            this.getPackages();
        } else if (id == 26) {
            this.getModules();
        } else if (id == 27) {
            this.getGlobalVariables();
        }
        return super.eIsSet(eFeature);
    }

    public static void loadTables(Connection connection, EList tableList, LUWCatalogSchema schema, int options) throws SQLException {
        ConnectionFilter nicknameFilter;
        ConnectionFilter mqtFilter;
        ConnectionFilter aliasFilter;
        ConnectionFilter viewFilter;
        LUWCatalogDatabase database = (LUWCatalogDatabase)schema.getCatalogDatabase();
        HashMap cachedElement = schema.getCachedTable();
        schema.iniCachedTable();
        Object[] oldList = tableList.toArray();
        tableList.clear();
        boolean isBatchLoad = database.isBatchLoad();
        if ((options & 8) == 8 && (options & 0x100) == 256 && (options & 0x200) == 512) {
            return;
        }
        boolean hasFilter = false;
        String filterStr = "";
        ConnectionInfo connectionInfo = DatabaseConnectionRegistry.getInstance().getConnectionForDatabase(ModelHelper.getDatabase((Schema)schema));
        ConnectionFilter tableFilter = connectionInfo.getFilter(String.valueOf(schema.getName()) + "::" + "DatatoolsTableFilterPredicate");
        if (tableFilter == null) {
            tableFilter = connectionInfo.getFilter("DatatoolsTableFilterPredicate");
        }
        if ((viewFilter = connectionInfo.getFilter(String.valueOf(schema.getName()) + "::" + "DatatoolsViewFilterPredicate")) == null) {
            viewFilter = connectionInfo.getFilter("DatatoolsViewFilterPredicate");
        }
        if ((aliasFilter = connectionInfo.getFilter(String.valueOf(schema.getName()) + "::" + "DatatoolsAliasFilterPredicate")) == null) {
            aliasFilter = connectionInfo.getFilter("DatatoolsAliasFilterPredicate");
        }
        if ((mqtFilter = connectionInfo.getFilter(String.valueOf(schema.getName()) + "::" + "DatatoolsMQTFilterPredicate")) == null) {
            mqtFilter = connectionInfo.getFilter("DatatoolsMQTFilterPredicate");
        }
        if ((nicknameFilter = connectionInfo.getFilter(String.valueOf(schema.getName()) + "::" + "DatatoolsNicknameFilterPredicate")) == null) {
            nicknameFilter = connectionInfo.getFilter("DatatoolsNicknameFilterPredicate");
        }
        boolean bl = hasFilter = tableFilter != null || viewFilter != null || aliasFilter != null || mqtFilter != null || nicknameFilter != null;
        if (hasFilter) {
            if ((options & 8) != 8) {
                filterStr = tableFilter != null ? String.valueOf(filterStr) + CatalogLoadUtil.getFilterString((String)tableFilter.getPredicate(), (String)"TABNAME") + " AND TYPE='T' " : String.valueOf(filterStr) + "TYPE='T' ";
            }
            if ((options & 0x100) != 256) {
                if (viewFilter != null) {
                    if (filterStr.length() > 0) {
                        filterStr = String.valueOf(filterStr) + " OR ";
                    }
                    filterStr = String.valueOf(filterStr) + CatalogLoadUtil.getFilterString((String)viewFilter.getPredicate(), (String)"TABNAME") + " AND TYPE='V' ";
                } else {
                    filterStr = String.valueOf(filterStr) + " OR TYPE='V' ";
                }
            }
            if ((options & 0x200) != 512) {
                if (aliasFilter != null) {
                    if (filterStr.length() > 0) {
                        filterStr = String.valueOf(filterStr) + " OR ";
                    }
                    filterStr = String.valueOf(filterStr) + CatalogLoadUtil.getFilterString((String)aliasFilter.getPredicate(), (String)"TABNAME") + " AND TYPE='A' ";
                } else {
                    filterStr = String.valueOf(filterStr) + " OR TYPE='A' ";
                }
            }
            if ((options & 0x100) != 256) {
                if (mqtFilter != null) {
                    if (filterStr.length() > 0) {
                        filterStr = String.valueOf(filterStr) + " OR ";
                    }
                    filterStr = String.valueOf(filterStr) + CatalogLoadUtil.getFilterString((String)mqtFilter.getPredicate(), (String)"TABNAME") + " AND TYPE='S' ";
                } else {
                    filterStr = String.valueOf(filterStr) + " OR TYPE='S' ";
                }
            }
            if ((options & 8) != 8) {
                if (nicknameFilter != null) {
                    if (filterStr.length() > 0) {
                        filterStr = String.valueOf(filterStr) + " OR ";
                    }
                    filterStr = String.valueOf(filterStr) + CatalogLoadUtil.getFilterString((String)nicknameFilter.getPredicate(), (String)"TABNAME") + " AND TYPE='N' ";
                } else {
                    filterStr = String.valueOf(filterStr) + " OR TYPE='N' ";
                }
            }
            filterStr = filterStr.length() > 0 ? " AND (" + filterStr + ")" : "";
        }
        String query = "SELECT TABNAME, TYPE,REMARKS ,PARTITION_MODE,TBSPACE, INDEX_TBSPACE,LONG_TBSPACE,DATACAPTURE, COMPRESSION, TABSCHEMA FROM SYSCAT.TABLES";
        query = String.valueOf(query) + " WHERE TABSCHEMA='" + LUWUtil.getIdentifier(schema.getName()) + "'";
        if (hasFilter) {
            query = String.valueOf(query) + filterStr;
        } else {
            String types = "";
            if ((options & 8) != 8) {
                types = String.valueOf(types) + "'T','N','G'";
            }
            if ((options & 0x100) != 256) {
                types = String.valueOf(types) + (types.length() > 0 ? ",'V','S'" : "'V','S'");
            }
            if ((options & 0x200) != 512) {
                types = String.valueOf(types) + (types.length() > 0 ? ",'A'" : "'A'");
            }
            query = String.valueOf(query) + " AND TYPE IN(" + (types.length() > 0 ? types : "") + ")";
        }
        Statement s = null;
        ResultSet r = null;
        try {
            try {
                s = connection.createStatement();
                r = s.executeQuery(query);
                while (r.next()) {
                    String partitionMode;
                    Object table;
                    r.getString("TABSCHEMA").trim();
                    String tableName = r.getString(1);
                    String type = r.getString(2);
                    EClass metaclass = null;
                    if (type.equals("T")) {
                        metaclass = LUWPackage.eINSTANCE.getLUWTable();
                    } else if (type.equals("V")) {
                        metaclass = LUWPackage.eINSTANCE.getLUWView();
                    } else if (type.equals("A")) {
                        metaclass = DB2ModelPackage.eINSTANCE.getDB2Alias();
                    } else if (type.equals("S")) {
                        metaclass = LUWPackage.eINSTANCE.getLUWMaterializedQueryTable();
                    } else if (type.equals("N")) {
                        metaclass = LUWPackage.eINSTANCE.getLUWGenericNickname();
                    }
                    Object element = LUWCatalogSchema.findTable(cachedElement, oldList, tableName, metaclass);
                    if (element != null) {
                        table = (Table)element;
                        tableList.add(table);
                        ((ICatalogObject)table).refresh();
                        continue;
                    }
                    if (type.equals("T")) {
                        table = new LUWCatalogTable();
                        partitionMode = r.getString(4);
                        ((LUWCatalogTable)table).setPartitionMode(partitionMode);
                        String tspName = r.getString(5);
                        ((LUWCatalogTable)table).setTablespaceName(tspName);
                        String indexTbspaceName = r.getString(6);
                        ((LUWCatalogTable)table).setIndexTbspaceName(indexTbspaceName);
                        String longTbspaceName = r.getString(7);
                        ((LUWCatalogTable)table).setlongTbspaceName(longTbspaceName);
                        String dataCapture = r.getString("DATACAPTURE");
                        if (dataCapture.equals("N")) {
                            ((LUWCatalogTable)table).setDataCapture(DataCaptureType.NONE_LITERAL);
                        } else {
                            ((LUWCatalogTable)table).setDataCapture(DataCaptureType.CHANGES_LITERAL);
                        }
                        String compression = r.getString("COMPRESSION");
                        if ("V".equals(compression)) {
                            ((LUWCatalogTable)table).setValueCompression(true);
                        } else if ("R".equals(compression)) {
                            ((LUWCatalogTable)table).setRowCompression(true);
                        } else if ("B".equals(compression)) {
                            ((LUWCatalogTable)table).setValueCompression(true);
                            ((LUWCatalogTable)table).setRowCompression(true);
                        } else {
                            ((LUWCatalogTable)table).setValueCompression(false);
                            ((LUWCatalogTable)table).setRowCompression(false);
                        }
                    } else if (type.equals("V")) {
                        table = new LUWCatalogView();
                    } else if (type.equals("A")) {
                        table = new LUWCatalogAlias();
                    } else if (type.equals("S")) {
                        table = new LUWCatalogMaterializedQueryTable();
                        partitionMode = r.getString(4);
                        ((LUWCatalogMaterializedQueryTable)table).setPartitionMode(partitionMode);
                        String compression = r.getString("COMPRESSION");
                        if ("V".equals(compression)) {
                            ((LUWCatalogMaterializedQueryTable)table).setValueCompression(true);
                            ((LUWCatalogMaterializedQueryTable)table).setRowCompression(false);
                        } else if ("R".equals(compression)) {
                            ((LUWCatalogMaterializedQueryTable)table).setRowCompression(true);
                            ((LUWCatalogMaterializedQueryTable)table).setValueCompression(false);
                        } else if ("B".equals(compression)) {
                            ((LUWCatalogMaterializedQueryTable)table).setValueCompression(true);
                            ((LUWCatalogMaterializedQueryTable)table).setRowCompression(true);
                        } else {
                            ((LUWCatalogMaterializedQueryTable)table).setValueCompression(false);
                            ((LUWCatalogMaterializedQueryTable)table).setRowCompression(false);
                        }
                    } else {
                        if (!type.equals("N")) continue;
                        table = new LUWCatalogNickname();
                        ((LUWCatalogNickname)table).setAsBatchLoad(isBatchLoad);
                    }
                    table.setName(tableName);
                    String description = r.getString("REMARKS");
                    table.setDescription(description);
                    tableList.add(table);
                    schema.cacheTable(tableName, (Table)table);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                if (r != null) {
                    r.close();
                }
                if (s != null) {
                    s.close();
                }
            }
        }
        finally {
            if (r != null) {
                r.close();
            }
            if (s != null) {
                s.close();
            }
        }
    }

    private synchronized void loadTables() {
        if (this.tablesLoaded) {
            return;
        }
        this.tablesLoaded = true;
        EList tableList = super.getTables();
        Connection connection = this.getConnection();
        boolean deliver = this.eDeliver();
        this.eSetDeliver(false);
        try {
            LUWCatalogSchema.loadTables(connection, tableList, this, ((LUWCatalogDatabase)this.getCatalogDatabase()).getLoadOptions());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        LUWCatalogDatabase cfr_ignored_0 = (LUWCatalogDatabase)this.getCatalogDatabase();
        this.eSetDeliver(deliver);
    }

    public static void loadRoutines(Connection connection, EList routineList, Schema schema, int options) throws SQLException {
        boolean hasFilter;
        ConnectionFilter udfFilter;
        ConnectionFilter fedspFilter;
        String version = connection.getMetaData().getDatabaseProductVersion();
        if (version.startsWith("SQL07")) {
            return;
        }
        Object[] oldList = routineList.toArray();
        routineList.clear();
        if ((options & 0x10) == 16) {
            return;
        }
        ConnectionInfo connectionInfo = DatabaseConnectionRegistry.getInstance().getConnectionForDatabase(ModelHelper.getDatabase((Schema)schema));
        ConnectionFilter spFilter = connectionInfo.getFilter(String.valueOf(schema.getName()) + "::" + "DatatoolsSPFilterPredicate");
        if (spFilter == null) {
            spFilter = connectionInfo.getFilter("DatatoolsSPFilterPredicate");
        }
        if ((fedspFilter = connectionInfo.getFilter(String.valueOf(schema.getName()) + "::" + "DatatoolsFSPFilterPredicate")) == null) {
            fedspFilter = connectionInfo.getFilter("DatatoolsFSPFilterPredicate");
        }
        if ((udfFilter = connectionInfo.getFilter(String.valueOf(schema.getName()) + "::" + "DatatoolsUDFFilterPredicate")) == null) {
            udfFilter = connectionInfo.getFilter("DatatoolsUDFFilterPredicate");
        }
        String filterStr = "";
        boolean bl = hasFilter = spFilter != null || udfFilter != null || fedspFilter != null;
        if (hasFilter) {
            filterStr = spFilter != null ? String.valueOf(filterStr) + "( " + CatalogLoadUtil.getFilterString((String)spFilter.getPredicate(), (String)"ROUTINENAME") + " AND ROUTINETYPE='P' AND ORIGIN<>'F') " : String.valueOf(filterStr) + "(ROUTINETYPE='P' and ORIGIN<>'F')";
            filterStr = fedspFilter != null ? String.valueOf(filterStr) + " OR (" + CatalogLoadUtil.getFilterString((String)fedspFilter.getPredicate(), (String)"ROUTINENAME") + " AND ROUTINETYPE='P' AND ORIGIN='F') " : String.valueOf(filterStr) + "OR (ROUTINETYPE='P' and ORIGIN='F')";
            if (udfFilter != null) {
                if (filterStr.length() > 0) {
                    filterStr = String.valueOf(filterStr) + " OR ";
                }
                filterStr = String.valueOf(filterStr) + "(" + CatalogLoadUtil.getFilterString((String)udfFilter.getPredicate(), (String)"ROUTINENAME") + " AND ROUTINETYPE='F') ";
            } else {
                filterStr = String.valueOf(filterStr) + " OR ROUTINETYPE='F' ";
            }
            filterStr = " AND (" + filterStr;
            filterStr = String.valueOf(filterStr) + ") ";
        }
        DatabaseDefinition databaseDefinition = RDBCorePlugin.getDefault().getDatabaseDefinitionRegistry().getDefinition(ModelHelper.getDatabase((Schema)schema));
        String query = "SELECT ROUTINENAME, ROUTINETYPE,FUNCTIONTYPE,SPECIFICNAME,LANGUAGE,PARAMETER_STYLE,\"DETERMINISTIC\" as D, SQL_DATA_ACCESS, EXTERNAL_ACTION, CHAR(CREATE_TIME) AS CT, CHAR(ALTER_TIME) AS AT, REMARKS, ROUTINEID, ORIGIN ";
        query = ModelHelper.isSupportPL_SQL((DatabaseDefinition)databaseDefinition) ? String.valueOf(query) + " ,DIALECT " : String.valueOf(query) + " ,'' AS DIALECT ";
        query = String.valueOf(query) + " FROM SYSCAT.ROUTINES WHERE ROUTINESCHEMA='" + LUWUtil.getIdentifier(schema.getName()) + "'" + " AND ORIGIN<>'S'";
        if (ModelHelper.isSupportModule((DatabaseDefinition)databaseDefinition)) {
            query = String.valueOf(query) + " AND ROUTINEMODULENAME IS NULL";
        }
        if (hasFilter) {
            query = String.valueOf(query) + filterStr;
        }
        Statement s = connection.createStatement();
        ResultSet r = s.executeQuery(query);
        try {
            while (r.next()) {
                Object routine;
                String routineName = r.getString(1);
                String routineType = r.getString(2);
                String origin = r.getString("ORIGIN");
                String dialect = r.getString("DIALECT");
                boolean isPlsql = false;
                if (dialect != null && dialect.trim().equals("PL/SQL")) {
                    isPlsql = true;
                }
                EClass metaclass = null;
                if (routineType.equals("P")) {
                    metaclass = SQLRoutinesPackage.eINSTANCE.getProcedure();
                } else if (routineType.equals("F")) {
                    metaclass = SQLRoutinesPackage.eINSTANCE.getUserDefinedFunction();
                } else if (routineType.equals("M")) {
                    metaclass = SQLRoutinesPackage.eINSTANCE.getMethod();
                }
                Object element = LUWCatalogSchema.findElement(oldList, routineName, metaclass);
                if (element != null) {
                    routine = (Routine)element;
                    ((ICatalogObject)routine).refresh();
                } else {
                    if (routineType.equals("F")) {
                        routine = new LUWCatalogUserDefinedFunction();
                        String funcType = r.getString("FUNCTIONTYPE");
                        if (funcType.equals("T")) {
                            ((LUWCatalogUserDefinedFunction)((Object)routine)).setLUWFunctionType((byte)1);
                        } else if (funcType.equals("C")) {
                            ((LUWCatalogUserDefinedFunction)((Object)routine)).setLUWFunctionType((byte)3);
                        } else if (funcType.equals("R")) {
                            ((LUWCatalogUserDefinedFunction)((Object)routine)).setLUWFunctionType((byte)2);
                        } else {
                            ((LUWCatalogUserDefinedFunction)((Object)routine)).setLUWFunctionType((byte)0);
                        }
                        if (origin.equals("M")) {
                            ((LUWCatalogUserDefinedFunction)((Object)routine)).setOrigin(OriginType.TEMPLATE_LITERAL);
                        } else if (origin.equals("U")) {
                            ((LUWCatalogUserDefinedFunction)((Object)routine)).setOrigin(OriginType.SOURCE_LITERAL);
                        } else {
                            ((LUWCatalogUserDefinedFunction)((Object)routine)).setOrigin(OriginType.NONE_LITERAL);
                        }
                        if (isPlsql) {
                            ((LUWCatalogUserDefinedFunction)((Object)routine)).setDialect(SourceDialect.PLSQL_LITERAL);
                        } else {
                            ((LUWCatalogUserDefinedFunction)((Object)routine)).setDialect(SourceDialect.DB2SQLPL_LITERAL);
                        }
                    } else if (routineType.equals("P")) {
                        if (!origin.equals("F")) {
                            routine = new LUWCatalogProcedure();
                            if (isPlsql) {
                                ((LUWCatalogProcedure)((Object)routine)).setDialect(SourceDialect.PLSQL_LITERAL);
                            } else {
                                ((LUWCatalogProcedure)((Object)routine)).setDialect(SourceDialect.DB2SQLPL_LITERAL);
                            }
                        } else {
                            routine = new LUWCatalogFederatedProcedure();
                            LUWCatalogFederatedProcedure fedRoutine = (LUWCatalogFederatedProcedure)routine;
                            int routineID = r.getInt("ROUTINEID");
                            fedRoutine.setRoutineID(routineID);
                            String deterministic = r.getString("D");
                            if (deterministic.equals("Y")) {
                                routine.setDeterministic(true);
                            } else {
                                routine.setDeterministic(false);
                            }
                            String sql_data_access = r.getString("SQL_DATA_ACCESS");
                            if (sql_data_access.equals("C")) {
                                fedRoutine.setSQLDataAccess(DataAccess.CONTAINS_SQL_LITERAL);
                            } else if (sql_data_access.equals("M")) {
                                fedRoutine.setSQLDataAccess(DataAccess.MODIFIES_SQL_DATA_LITERAL);
                            } else if (sql_data_access.equals("N")) {
                                fedRoutine.setSQLDataAccess(DataAccess.NO_SQL_LITERAL);
                            } else {
                                fedRoutine.setSQLDataAccess(DataAccess.READS_SQL_DATA_LITERAL);
                            }
                            String externalAction = r.getString("EXTERNAL_ACTION");
                            fedRoutine.setExternalAction(externalAction);
                        }
                    } else {
                        if (!routineType.equals("M")) continue;
                        continue;
                    }
                    routine.setName(routineName);
                }
                String language = r.getString("LANGUAGE").trim();
                routine.setLanguage(language);
                String paramStyle = r.getString("PARAMETER_STYLE").trim();
                routine.setParameterStyle(paramStyle);
                String createdTS = r.getString("CT");
                routine.setCreationTS(createdTS);
                String alteredTS = r.getString("AT");
                routine.setLastAlteredTS(alteredTS);
                String remarks = r.getString("REMARKS");
                routine.setDescription(remarks);
                String specificName = r.getString("SPECIFICNAME");
                routine.setSpecificName(specificName);
                if (!origin.equals("F")) {
                    routineList.add(routine);
                    continue;
                }
                routineList.add(routine);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        r.close();
        s.close();
    }

    private synchronized void loadRoutines() {
        if (this.routinesLoaded) {
            return;
        }
        this.routinesLoaded = true;
        EList routineList = super.getRoutines();
        boolean deliver = this.eDeliver();
        this.eSetDeliver(false);
        Connection connection = this.getConnection();
        try {
            LUWCatalogSchema.loadRoutines(connection, routineList, (Schema)this, ((LUWCatalogDatabase)this.getCatalogDatabase()).getLoadOptions());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.eSetDeliver(deliver);
    }

    public static void loadJars(Connection connection, EList jarList, Schema schema, int options) throws SQLException {
        Object[] oldList = jarList.toArray();
        jarList.clear();
        if ((options & 0x10) == 16) {
            return;
        }
        ConnectionInfo connectionInfo = DatabaseConnectionRegistry.getInstance().getConnectionForDatabase(ModelHelper.getDatabase((Schema)schema));
        ConnectionFilter jarFilter = connectionInfo.getFilter(String.valueOf(schema.getName()) + "::" + "DatatoolsJarFilterPredicate");
        if (jarFilter == null) {
            jarFilter = connectionInfo.getFilter("DatatoolsJarFilterPredicate");
        }
        String filterStr = "";
        if (jarFilter != null) {
            filterStr = String.valueOf(filterStr) + " AND " + CatalogLoadUtil.getFilterString((String)jarFilter.getPredicate(), (String)"JAR_ID");
        }
        String query = "SELECT JAR_ID, DEFINER, ALTEREDTS, CREATEDTS FROM SYSIBM.SYSJAROBJECTS WHERE JARSCHEMA='" + LUWUtil.getIdentifier(schema.getName()) + "'";
        Statement s = connection.createStatement();
        ResultSet r = s.executeQuery(query);
        try {
            while (r.next()) {
                Object jar;
                String jarID = r.getString("JAR_ID");
                String definer = r.getString("DEFINER");
                EClass metaclass = DB2ModelPackage.eINSTANCE.getDB2Jar();
                Object element = LUWCatalogSchema.findElement(oldList, jarID, metaclass);
                if (element != null) {
                    jar = (DB2Jar)element;
                    ((ICatalogObject)jar).refresh();
                } else {
                    jar = new LUWCatalogJar();
                    jar.setName(jarID);
                }
                jar.setOwner(definer);
                String createdTS = r.getString("CREATEDTS");
                jar.setCreatedTS(createdTS);
                String alteredTS = r.getString("ALTEREDTS");
                jar.setAlteredTS(alteredTS);
                jarList.add(jar);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        r.close();
        s.close();
    }

    public static void loadXMLSchemas(Connection connection, EList xsrObjList, Schema schema) throws SQLException {
        Object[] oldList = xsrObjList.toArray();
        xsrObjList.clear();
        ConnectionInfo connectionInfo = DatabaseConnectionRegistry.getInstance().getConnectionForDatabase(ModelHelper.getDatabase((Schema)schema));
        String rootPath = LUWCatalogSchema.getXSDSourceCacheRoot(connectionInfo, schema);
        LUWCatalogSchema.deleteXSDSourceCache(rootPath);
        ConnectionFilter xsrObjectFilter = connectionInfo.getFilter(String.valueOf(schema.getName()) + "::" + "DatatoolsXMLSchemasFilterPredicate");
        if (xsrObjectFilter == null) {
            xsrObjectFilter = connectionInfo.getFilter("DatatoolsXMLSchemasFilterPredicate");
        }
        String filterStr = "";
        if (xsrObjectFilter != null) {
            filterStr = String.valueOf(filterStr) + CatalogLoadUtil.getFilterString((String)xsrObjectFilter.getPredicate(), (String)"OBJECTNAME") + " AND OBJECTTYPE='S' ";
            filterStr = " AND (" + filterStr;
            filterStr = String.valueOf(filterStr) + ") ";
        }
        String query = "SELECT OBJECTNAME, OBJECTTYPE, DECOMPOSITION, REMARKS, STATUS FROM SYSCAT.XSROBJECTS WHERE OBJECTSCHEMA='" + LUWUtil.getIdentifier(schema.getName()) + "'";
        if (xsrObjectFilter != null) {
            query = String.valueOf(query) + filterStr;
        }
        Statement s = null;
        ResultSet r = null;
        try {
            try {
                s = connection.createStatement();
                r = s.executeQuery(query);
                while (r.next()) {
                    Object xmlSchema;
                    String xsrObjectName = r.getString("OBJECTNAME");
                    String objectType = r.getString("OBJECTTYPE");
                    EClass metaclass = null;
                    if (objectType.equals("S")) {
                        metaclass = DB2ModelPackage.eINSTANCE.getDB2XMLSchema();
                    }
                    if (metaclass == null) continue;
                    Object element = LUWCatalogSchema.findElement(oldList, xsrObjectName, metaclass);
                    if (element != null) {
                        xmlSchema = (DB2XMLSchema)element;
                        ((ICatalogObject)xmlSchema).refresh();
                    } else {
                        xmlSchema = new LUWCatalogXmlSchema();
                        xmlSchema.setName(xsrObjectName);
                    }
                    String decomposition = r.getString("DECOMPOSITION");
                    if (decomposition.equalsIgnoreCase("Y")) {
                        xmlSchema.setDecomposition(DB2XMLSchemaDecomposition.ENABLED_LITERAL);
                    } else if (decomposition.equalsIgnoreCase("N")) {
                        xmlSchema.setDecomposition(DB2XMLSchemaDecomposition.NOT_ENABLED_LITERAL);
                    } else if (decomposition.equalsIgnoreCase("X")) {
                        xmlSchema.setDecomposition(DB2XMLSchemaDecomposition.INOPERATIVE_LITERAL);
                    }
                    String status = r.getString("STATUS");
                    if (status.equalsIgnoreCase("C")) {
                        xmlSchema.setStatus(DB2XMLSchemaStatus.COMPLETE_LITERAL);
                    } else if (status.equalsIgnoreCase("I")) {
                        xmlSchema.setStatus(DB2XMLSchemaStatus.INCOMPLETE_LITERAL);
                    } else if (status.equalsIgnoreCase("R")) {
                        xmlSchema.setStatus(DB2XMLSchemaStatus.REPLACE_LITERAL);
                    } else if (status.equalsIgnoreCase("T")) {
                        xmlSchema.setStatus(DB2XMLSchemaStatus.TEMPORARY_LITERAL);
                    }
                    String comment = r.getString("REMARKS");
                    xmlSchema.setDescription(comment);
                    xsrObjList.add(xmlSchema);
                }
            }
            catch (Exception e) {
                DB2LUWPluginActivator.getInstance().log("LUWCatalogSchema.loadXMLSchemas()", 4, e);
                r.close();
                s.close();
            }
        }
        finally {
            r.close();
            s.close();
        }
    }

    private synchronized void loadJars() {
        if (this.jarsLoaded) {
            return;
        }
        this.jarsLoaded = true;
        EList jarList = super.getJars();
        boolean deliver = this.eDeliver();
        this.eSetDeliver(false);
        Connection connection = this.getConnection();
        try {
            LUWCatalogSchema.loadJars(connection, jarList, (Schema)this, ((LUWCatalogDatabase)this.getCatalogDatabase()).getLoadOptions());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.eSetDeliver(deliver);
    }

    private synchronized void loadXsrObjects() {
        if (this.xsrObjsLoaded) {
            return;
        }
        EList xsrObjList = super.getXsrObjects();
        boolean deliver = this.eDeliver();
        this.eSetDeliver(false);
        Connection connection = this.getConnection();
        try {
            LUWCatalogSchema.loadXMLSchemas(connection, xsrObjList, (Schema)this);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.eSetDeliver(deliver);
    }

    public static void loadSequences(Connection connection, EList sequenceList, Schema schema, int options) throws SQLException {
        boolean hasFilter;
        Object[] oldList = sequenceList.toArray();
        sequenceList.clear();
        if ((options & 0x40) == 64) {
            return;
        }
        DatabaseDefinition databaseDefinition = RDBCorePlugin.getDefault().getDatabaseDefinitionRegistry().getDefinition(ModelHelper.getDatabase((Schema)schema));
        DataModelElementFactory factory = databaseDefinition.getDataModelElementFactory();
        ConnectionInfo connectionInfo = DatabaseConnectionRegistry.getInstance().getConnectionForDatabase(ModelHelper.getDatabase((Schema)schema));
        ConnectionFilter sequenceFilter = connectionInfo.getFilter(String.valueOf(schema.getName()) + "::" + "DatatoolsSequenceFilterPredicate");
        if (sequenceFilter == null) {
            sequenceFilter = connectionInfo.getFilter("DatatoolsSequenceFilterPredicate");
        }
        String filterStr = "";
        boolean bl = hasFilter = sequenceFilter != null;
        if (hasFilter) {
            filterStr = " AND " + CatalogLoadUtil.getFilterString((String)sequenceFilter.getPredicate(), (String)"SEQNAME");
        }
        String query = "SELECT SEQNAME, REMARKS, DATATYPEID, PRECISION, INCREMENT, START, MAXVALUE, MINVALUE, CYCLE, CACHE FROM SYSCAT.SEQUENCES  WHERE SEQSCHEMA='" + LUWUtil.getIdentifier(schema.getName()) + "'" + " AND ORIGIN='U'" + " AND (SEQTYPE = 'S' OR SEQTYPE = 'I')";
        if (hasFilter) {
            query = String.valueOf(query) + filterStr;
        }
        Statement s = connection.createStatement();
        ResultSet r = s.executeQuery(query);
        try {
            while (r.next()) {
                LUWCatalogSequence sequence;
                EClass metaclass;
                String seqName = r.getString(1);
                Object element = LUWCatalogSchema.findElement(oldList, seqName, metaclass = SQLSchemaPackage.eINSTANCE.getSequence());
                if (element != null) {
                    sequence = (LUWCatalogSequence)((Object)element);
                    sequence.refresh();
                } else {
                    sequence = new LUWCatalogSequence();
                    sequence.setName(seqName);
                }
                String remarks = r.getString(2);
                sequence.setDescription(remarks);
                int dataTypeId = r.getInt(3);
                sequence.setDataTypeId(dataTypeId);
                int precision = r.getInt(4);
                sequence.setPrecision(precision);
                DB2IdentitySpecifier identity = (DB2IdentitySpecifier)factory.create(DB2ModelPackage.eINSTANCE.getDB2IdentitySpecifier());
                identity.setGenerationType(GenerateType.ALWAYS_GENERATED_LITERAL);
                identity.setIncrement(r.getBigDecimal(5).toBigInteger());
                identity.setStartValue(r.getBigDecimal(6).toBigInteger());
                identity.setMaximum(r.getBigDecimal(7).toBigInteger());
                identity.setMinimum(r.getBigDecimal(8).toBigInteger());
                String cycle = r.getString(9);
                if (cycle.equals("Y")) {
                    identity.setCycleOption(true);
                } else {
                    identity.setCycleOption(false);
                }
                int cache = r.getInt(10);
                identity.setCache(cache);
                sequence.setIdentity((IdentitySpecifier)identity);
                sequenceList.add((Object)sequence);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        r.close();
        s.close();
    }

    private synchronized void loadSequences() {
        if (this.sequencesLoaded) {
            return;
        }
        this.sequencesLoaded = true;
        EList sequenceList = super.getSequences();
        Connection connection = this.getConnection();
        if (connection == null) {
            return;
        }
        boolean deliver = this.eDeliver();
        this.eSetDeliver(false);
        try {
            LUWCatalogSchema.loadSequences(connection, sequenceList, (Schema)this, ((LUWCatalogDatabase)this.getCatalogDatabase()).getLoadOptions());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.eSetDeliver(deliver);
    }

    private synchronized void loadTriggers() {
        if (this.triggersLoaded) {
            return;
        }
        this.triggersLoaded = true;
        super.getTriggers();
        LUWCatalogDatabase cfr_ignored_0 = (LUWCatalogDatabase)this.getCatalogDatabase();
        Connection connection = this.getConnection();
        int options = ((LUWCatalogDatabase)this.getCatalogDatabase()).getLoadOptions();
        if ((options & 2) == 2) {
            return;
        }
        boolean deliver = this.eDeliver();
        this.eSetDeliver(false);
        try {
            Statement s = connection.createStatement();
            ResultSet r = s.executeQuery("SELECT DISTINCT TABSCHEMA, TABNAME FROM SYSCAT.TRIGGERS WHERE TRIGSCHEMA='" + LUWUtil.getIdentifier(this.getName()) + "'");
            while (r.next()) {
                String tabName;
                String tabSchema = r.getString(1).trim();
                Table table = this.getTable(tabSchema, tabName = r.getString(2));
                if (table == null) continue;
                table.getTriggers();
            }
            r.close();
            s.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.eSetDeliver(deliver);
    }

    private synchronized void loadIndices() {
        if (this.indicesLoaded) {
            return;
        }
        this.indicesLoaded = true;
        super.getIndices().clear();
        LUWCatalogDatabase database = (LUWCatalogDatabase)this.getCatalogDatabase();
        if (!database.isBatchLoad()) {
            return;
        }
        int options = ((LUWCatalogDatabase)this.getCatalogDatabase()).getLoadOptions();
        if ((options & 1) == 1) {
            return;
        }
        Connection connection = this.getConnection();
        boolean deliver = this.eDeliver();
        this.eSetDeliver(false);
        try {
            String query = "SELECT INDEXTYPE, INDSCHEMA,TABNAME, INDNAME, REMARKS, UNIQUERULE, PCTFREE, SYSTEM_REQUIRED, USER_DEFINED FROM SYSCAT.INDEXES WHERE TABSCHEMA='" + LUWUtil.getIdentifier(this.getName()) + "'";
            ConnectionInfo connectionInfo = DatabaseConnectionRegistry.getInstance().getConnectionForDatabase((Database)database);
            ConnectionFilter tableFilter = connectionInfo.getFilter(String.valueOf(this.getName()) + "::" + "DatatoolsTableFilterPredicate");
            if (tableFilter == null) {
                tableFilter = connectionInfo.getFilter("DatatoolsTableFilterPredicate");
            }
            if (tableFilter != null) {
                query = String.valueOf(query) + " AND " + CatalogLoadUtil.getFilterString((String)tableFilter.getPredicate(), (String)"TABNAME");
            }
            Statement s = connection.createStatement();
            ResultSet r = s.executeQuery(query);
            int typeOrdinal = r.findColumn("INDEXTYPE");
            int idxSchemOrdinal = r.findColumn("INDSCHEMA");
            int tableOrdinal = r.findColumn("TABNAME");
            int nameOrdinal = r.findColumn("INDNAME");
            int remarkOrdinal = r.findColumn("REMARKS");
            int ruleOrdinal = r.findColumn("UNIQUERULE");
            int pctfreeOrdinal = r.findColumn("PCTFREE");
            int systemRequiredOrdinal = r.findColumn("SYSTEM_REQUIRED");
            int userDefinedOrdinal = r.findColumn("USER_DEFINED");
            while (r.next()) {
                String schemaName;
                Schema indexSchema;
                int userDefined;
                int pctfree;
                String indName = r.getString(nameOrdinal);
                LUWCatalogIndex index = null;
                String type = r.getString(typeOrdinal);
                if (type.equals("REG ")) {
                    index = new LUWCatalogIndex();
                } else if (type.equals("CLUS")) {
                    index = new LUWCatalogIndex();
                    index.setClustered(true);
                } else if (type.equals("DIM ")) {
                    index = new LUWCatalogIndex();
                    index.setIndexType(DB2IndexType.DIMENSION_LITERAL);
                } else {
                    if (!type.equals("BLOK")) continue;
                    index = new LUWCatalogIndex();
                    index.setIndexType(DB2IndexType.BLOCK_LITERAL);
                }
                index.setName(indName);
                String remarks = r.getString(remarkOrdinal);
                index.setDescription(remarks);
                String uniqueRule = r.getString(ruleOrdinal);
                if (!uniqueRule.equals("D")) {
                    index.setUnique(true);
                }
                if ("P".equalsIgnoreCase(uniqueRule)) {
                    index.setIndexUniqueRule(LUWCatalogIndex.IndexUniqueRule.PRIMARYKEY);
                }
                if ((pctfree = r.getInt(pctfreeOrdinal)) == -1) {
                    index.setFillFactor(10);
                } else {
                    index.setFillFactor(pctfree);
                }
                int systemRequred = r.getInt(systemRequiredOrdinal);
                if (index instanceof LUWIndex) {
                    if (systemRequred != 0) {
                        ((LUWIndex)index).setSystemRequired(true);
                    } else {
                        ((LUWIndex)index).setSystemRequired(false);
                    }
                }
                if ((userDefined = r.getInt(userDefinedOrdinal)) == 0) {
                    index.setSystemGenerated(true);
                } else {
                    index.setSystemGenerated(false);
                }
                String tabName = r.getString(tableOrdinal).trim();
                Table table = this.getTable(this.getName(), tabName);
                if (table != null) {
                    index.setTable(table);
                }
                if ((indexSchema = LUWCatalogSchema.getSchema((Schema)this, schemaName = r.getString(idxSchemOrdinal).trim())) == null) continue;
                index.setSchema(indexSchema);
            }
            r.close();
            s.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.eSetDeliver(deliver);
    }

    private synchronized void loadOlapobjects() {
        if (this.olapobjectLoaded) {
            return;
        }
        this.olapobjectLoaded = true;
        EList olapList = super.getOlapObjects();
        Connection connection = this.getConnection();
        boolean deliver = this.eDeliver();
        this.eSetDeliver(false);
        try {
            OlapCatalogProvider provider = LUWCatalogSchema.getOlapCatalogProvider();
            if (provider != null) {
                for (Object bp : provider.getOlapobjects(connection, (DB2Schema)this)) {
                    olapList.add(bp);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.eSetDeliver(deliver);
    }

    private synchronized void loadUserDefinedTypes() {
        if (this.userDefinedTypesLoaded) {
            return;
        }
        this.userDefinedTypesLoaded = true;
        EList userDefinedTypeList = super.getUserDefinedTypes();
        Connection connection = this.getConnection();
        boolean deliver = this.eDeliver();
        this.eSetDeliver(false);
        try {
            LUWCatalogSchema.loadUserDefinedTypes(connection, userDefinedTypeList, (Schema)this, ((LUWCatalogDatabase)this.getCatalogDatabase()).getLoadOptions());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.eSetDeliver(deliver);
    }

    public static void loadUserDefinedTypes(Connection connection, EList userDefinedTypeList, Schema schema, int options) throws SQLException {
        boolean hasFilter;
        Object[] oldList = userDefinedTypeList.toArray();
        userDefinedTypeList.clear();
        if ((options & 0x20) == 32) {
            return;
        }
        DatabaseDefinition databaseDefinition = RDBCorePlugin.getDefault().getDatabaseDefinitionRegistry().getDefinition(ModelHelper.getDatabase((Schema)schema));
        ConnectionInfo connectionInfo = DatabaseConnectionRegistry.getInstance().getConnectionForDatabase(ModelHelper.getDatabase((Schema)schema));
        ConnectionFilter udtFilter = connectionInfo.getFilter(String.valueOf(schema.getName()) + "::" + "DatatoolsUDTFilterPredicate");
        if (udtFilter == null) {
            udtFilter = connectionInfo.getFilter("DatatoolsUDTFilterPredicate");
        }
        String filterStr = "";
        boolean bl = hasFilter = udtFilter != null;
        if (hasFilter) {
            filterStr = String.valueOf(filterStr) + " AND " + CatalogLoadUtil.getFilterString((String)udtFilter.getPredicate(), (String)"TYPENAME");
        }
        String query = "";
        query = ModelHelper.isSupportArrayDataType((DatabaseDefinition)databaseDefinition) ? "SELECT TYPENAME, METATYPE, REMARKS, SOURCESCHEMA, SOURCENAME, LENGTH,SCALE, CODEPAGE, INSTANTIABLE, FINAL, ARRAY_LENGTH " : "SELECT TYPENAME, METATYPE, REMARKS, SOURCESCHEMA, SOURCENAME, LENGTH,SCALE, CODEPAGE, INSTANTIABLE, FINAL, 0 AS ARRAY_LENGTH ";
        query = String.valueOf(query) + " FROM SYSCAT.DATATYPES  WHERE TYPESCHEMA='" + LUWUtil.getIdentifier(schema.getName()) + "'";
        if (hasFilter) {
            query = String.valueOf(query) + filterStr;
        }
        if (ModelHelper.isSupportModule((DatabaseDefinition)databaseDefinition)) {
            query = String.valueOf(query) + " AND TYPEMODULENAME IS NULL";
        }
        Statement s = connection.createStatement();
        ResultSet r = s.executeQuery(query);
        try {
            while (r.next()) {
                String typeName = r.getString(1);
                UserDefinedType type = null;
                EClass metaclass = SQLDataTypesPackage.eINSTANCE.getUserDefinedType();
                Object element = LUWCatalogSchema.findElement(oldList, typeName, metaclass);
                if (element != null) {
                    type = (UserDefinedType)element;
                    ((ICatalogObject)type).refresh();
                } else {
                    String metaType = r.getString(2);
                    if (metaType.equals("T")) {
                        type = LUWCatalogSchema.constructDistintUserDefinedType(r, schema);
                    } else if (metaType.equals("R")) {
                        type = LUWCatalogSchema.constructStructuredUserDefinedType(r);
                    } else if (metaType.equals("A")) {
                        type = LUWCatalogSchema.constructArrayDataType(r, schema);
                    } else if (metaType.equals("F")) {
                        type = new LUWCatalogRowDataType();
                    } else if (metaType.equals("C")) {
                        type = new LUWCatalogCursorDataType();
                    } else {
                        if (!metaType.equals("S")) continue;
                        continue;
                    }
                    type.setName(typeName);
                }
                String remarks = r.getString(3);
                type.setDescription(remarks);
                userDefinedTypeList.add((Object)type);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        r.close();
        s.close();
    }

    private synchronized void loadPrivileges() {
        if (this.privilegeLoaded) {
            return;
        }
        this.privilegeLoaded = true;
        EList privileges = super.getPrivileges();
        for (Privilege privilege : privileges) {
            privilege.setGrantor(null);
            privilege.setGrantee(null);
        }
        privileges.clear();
        boolean deliver = this.eDeliver();
        this.eSetDeliver(false);
        try {
            LUWCatalogSchema.loadPrivileges(this.getConnection(), privileges, (Schema)this, "");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.eSetDeliver(deliver);
    }

    public static void loadPrivileges(Connection connection, EList privilegeList, Schema schema, String granteeFilter) throws SQLException {
        Database database = ModelHelper.getDatabase((Schema)schema);
        int options = ((LUWCatalogDatabase)database).getLoadOptions();
        if ((options & 0x800) == 2048) {
            return;
        }
        Statement s = connection.createStatement();
        String query = "SELECT GRANTOR,GRANTEE,GRANTEETYPE,ALTERINAUTH,CREATEINAUTH,DROPINAUTH FROM SYSCAT.SCHEMAAUTH WHERE SCHEMANAME='" + LUWUtil.getIdentifier(schema.getName()) + "'";
        if (granteeFilter != null && !"".equals(granteeFilter)) {
            query = String.valueOf(query) + " AND " + granteeFilter;
        }
        ResultSet r = s.executeQuery(query);
        try {
            String userName = connection.getMetaData().getUserName();
            while (r.next()) {
                String indexAuth;
                String deleteAuth;
                String grantorId = r.getString("GRANTOR").trim();
                AuthorizationIdentifier grantor = LUWCatalogDatabase.getAuthorizationId(database, grantorId, null);
                String granteeId = r.getString("GRANTEE").trim();
                AuthorizationIdentifier grantee = null;
                String granteeType = r.getString("GRANTEETYPE");
                grantee = "G".equals(granteeType) ? LUWCatalogDatabase.getAuthorizationId(database, granteeId, "G") : ("R".equals(granteeType) ? LUWCatalogDatabase.getAuthorizationId(database, granteeId, "R") : LUWCatalogDatabase.getAuthorizationId(database, granteeId, "U"));
                LUWCatalogPrivilege privilege = null;
                boolean isSystemGranted = granteeId.equalsIgnoreCase(userName);
                String alterAuth = r.getString("ALTERINAUTH");
                if (!alterAuth.equals("N")) {
                    privilege = new LUWCatalogPrivilege();
                    privilege.setAction("ALTERIN");
                    if (alterAuth.equals("G")) {
                        privilege.setGrantable(true);
                    }
                    privilegeList.add((Object)privilege);
                    privilege.setGrantor(grantor);
                    privilege.setGrantee(grantee);
                    LUWCatalogPrivilege.setAsSystemGranted((Privilege)privilege, isSystemGranted);
                }
                if (!(deleteAuth = r.getString("CREATEINAUTH")).equals("N")) {
                    privilege = new LUWCatalogPrivilege();
                    privilege.setAction("CREATEIN");
                    if (deleteAuth.equals("G")) {
                        privilege.setGrantable(true);
                    }
                    privilegeList.add((Object)privilege);
                    privilege.setGrantor(grantor);
                    privilege.setGrantee(grantee);
                    LUWCatalogPrivilege.setAsSystemGranted((Privilege)privilege, isSystemGranted);
                }
                if ((indexAuth = r.getString("DROPINAUTH")).equals("N")) continue;
                privilege = new LUWCatalogPrivilege();
                privilege.setAction("DROPIN");
                if (indexAuth.equals("G")) {
                    privilege.setGrantable(true);
                }
                privilegeList.add((Object)privilege);
                privilege.setGrantor(grantor);
                privilege.setGrantee(grantee);
                LUWCatalogPrivilege.setAsSystemGranted((Privilege)privilege, isSystemGranted);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        r.close();
        s.close();
    }

    private synchronized void loadPackages() {
        if (this.packagesLoaded) {
            return;
        }
        this.packagesLoaded = true;
        boolean deliver = this.eDeliver();
        this.eSetDeliver(false);
        try {
            LUWCatalogSchema.loadPackages(this.getConnection(), super.getPackages(), this);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.eSetDeliver(deliver);
    }

    public static void loadPackages(Connection connection, EList packageList, LUWCatalogSchema schema) throws SQLException {
        schema.iniCachedDb2Package();
        if (((LUWCatalogDatabase)schema.getCatalogDatabase()).isBatchLoad()) {
            return;
        }
        DatabaseDefinition definition = RDBCorePlugin.getDefault().getDatabaseDefinitionRegistry().getDefinition(schema.getCatalogDatabase());
        String version = definition.getVersion();
        float ver = 8.0f;
        try {
            ver = Float.parseFloat(version.substring(1));
        }
        catch (NumberFormatException numberFormatException) {}
        String query = "SELECT PKGNAME, VALID, PKGVERSION, DEFAULT_SCHEMA, FUNC_PATH, REOPTVAR, ISOLATION, HEX(UNIQUE_ID) AS UID, CHAR(LAST_BIND_TIME) AS LBTS, BOUNDBY, BLOCKING, TOTAL_SECT, QUERYOPT, EXPLAIN_SNAPSHOT, REMARKS";
        query = (double)ver < 9.0 ? String.valueOf(query) + " ,DEFINER AS OWNER" : String.valueOf(query) + " ,OWNER";
        query = String.valueOf(query) + " FROM SYSCAT.PACKAGES WHERE PKGSCHEMA=" + LUWUtil.getSingleQuotedString(schema.getName()) + " FOR FETCH ONLY WITH UR";
        Statement s = connection.createStatement();
        ResultSet r = s.executeQuery(query);
        try {
            while (r.next()) {
                LUWCatalogDatabasePackage dbpackage = new LUWCatalogDatabasePackage();
                String pkgName = r.getString("PKGNAME").trim();
                dbpackage.setName(pkgName);
                String pkgValid = r.getString("VALID").trim();
                dbpackage.setValid(pkgValid);
                String pkgVersion = r.getString("PKGVERSION").trim();
                dbpackage.setVersion(pkgVersion);
                String pkgDefaultSchema = r.getString("DEFAULT_SCHEMA").trim();
                dbpackage.setDefaultSchema(pkgDefaultSchema);
                String pkgSqlPath = r.getString("FUNC_PATH").trim();
                dbpackage.setSqlPath(pkgSqlPath);
                String pkgReoptVar = r.getString("REOPTVAR");
                if ("A".equals(pkgReoptVar)) {
                    dbpackage.setReoptVar(ReoptType.ALWAYS_LITERAL);
                } else if ("N".equals(pkgReoptVar)) {
                    dbpackage.setReoptVar(ReoptType.NONE_LITERAL);
                } else if ("O".equals(pkgReoptVar)) {
                    dbpackage.setReoptVar(ReoptType.ONCE_LITERAL);
                }
                String pkgIsolation = r.getString("ISOLATION");
                if ("CS".equals(pkgIsolation)) {
                    dbpackage.setIsolation(IsolationLevelType.CURSOR_STABILITY_LITERAL);
                } else if ("RR".equals(pkgIsolation)) {
                    dbpackage.setIsolation(IsolationLevelType.REPEATABLE_READ_LITERAL);
                } else if ("RS".equals(pkgIsolation)) {
                    dbpackage.setIsolation(IsolationLevelType.READ_STABILITY_LITERAL);
                } else if ("UR".equals(pkgIsolation)) {
                    dbpackage.setIsolation(IsolationLevelType.UNCOMMITTED_READ_LITERAL);
                } else {
                    dbpackage.setIsolation(null);
                }
                String pkgUniqueID = r.getString("UID").trim();
                dbpackage.setUniqueID(pkgUniqueID);
                String pkgLastBindTS = r.getString("LBTS").trim();
                dbpackage.setLastBindTS(pkgLastBindTS);
                String pkgBoundBy = r.getString("BOUNDBY");
                dbpackage.setBinder(pkgBoundBy);
                String pkgOwner = r.getString("OWNER");
                dbpackage.setCreator(pkgOwner);
                String pkgBlocking = r.getString("BLOCKING");
                if ("B".equals(pkgBlocking)) {
                    dbpackage.setCursorBlock(CursorBlockType.BLOCK_ALL_CURSORS_LITERAL);
                } else if ("N".equals(pkgBlocking)) {
                    dbpackage.setCursorBlock(CursorBlockType.NO_BLOCKING_LITERAL);
                } else if ("U".equals(pkgBlocking)) {
                    dbpackage.setCursorBlock(CursorBlockType.BLOCK_UNAMBIGUOUS_CURSORS_LITERAL);
                }
                String pkgTotalSect = r.getString("TOTAL_SECT");
                dbpackage.setNumberOfSections(Integer.parseInt(pkgTotalSect));
                String pkgQueryOpt = r.getString("QUERYOPT");
                dbpackage.setOptimizationClass(Integer.parseInt(pkgQueryOpt));
                String pkgExplainSnapShot = r.getString("EXPLAIN_SNAPSHOT");
                if ("A".equals(pkgExplainSnapShot)) {
                    dbpackage.setExplainSnapshot(ExplainSnaphotType.ALL_LITERAL);
                } else if ("N".equals(pkgExplainSnapShot)) {
                    dbpackage.setExplainSnapshot(ExplainSnaphotType.NO_LITERAL);
                } else if ("R".equals(pkgExplainSnapShot)) {
                    dbpackage.setExplainSnapshot(ExplainSnaphotType.REOPT_LITERAL);
                } else if ("Y".equals(pkgExplainSnapShot)) {
                    dbpackage.setExplainSnapshot(ExplainSnaphotType.REOPT_LITERAL);
                }
                String remarks = r.getString("REMARKS");
                dbpackage.setDescription(remarks);
                packageList.add((Object)dbpackage);
                schema.cacheDB2Package(pkgName, pkgUniqueID, dbpackage);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        r.close();
        s.close();
    }

    private synchronized void loadModules() {
        if (this.moduleLoaded) {
            return;
        }
        this.moduleLoaded = true;
        EList modules = super.getModules();
        modules.clear();
        Database database = this.getDatabase();
        DatabaseDefinition databaseDefinition = RDBCorePlugin.getDefault().getDatabaseDefinitionRegistry().getDefinition(database);
        if (!ModelHelper.isSupportModule((DatabaseDefinition)databaseDefinition)) {
            return;
        }
        boolean deliver = this.eDeliver();
        this.eSetDeliver(false);
        try {
            LUWCatalogDatabase cfr_ignored_0 = (LUWCatalogDatabase)this.getCatalogDatabase();
            ModuleCatalogProvider moduleProvider = LUWCatalogDatabase.getCatalogModuleProvider();
            if (moduleProvider != null) {
                for (LUWModule module : moduleProvider.getModules(this.getConnection(), (DB2Schema)this)) {
                    modules.add((Object)module);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.eSetDeliver(deliver);
    }

    private synchronized void loadGlobaleVaraibles() {
        if (this.globalVariableLoaded) {
            return;
        }
        this.globalVariableLoaded = true;
        EList varaibles = super.getGlobalVariables();
        varaibles.clear();
        Database database = this.getDatabase();
        DatabaseDefinition databaseDefinition = RDBCorePlugin.getDefault().getDatabaseDefinitionRegistry().getDefinition(database);
        if (!ModelHelper.isSupportGlobalVariable((DatabaseDefinition)databaseDefinition)) {
            return;
        }
        boolean deliver = this.eDeliver();
        this.eSetDeliver(false);
        try {
            String query = "SELECT VARNAME,TYPESCHEMA,TYPENAME,LENGTH,SCALE,CODEPAGE,READONLY,REMARKS,DEFAULT FROM SYSCAT.VARIABLES  WHERE VARSCHEMA='" + LUWUtil.getIdentifier(this.getName()) + "'" + " AND VARMODULENAME is NULL";
            Statement s = this.getConnection().createStatement();
            ResultSet r = s.executeQuery(query);
            while (r.next()) {
                String typeSchemaName;
                PredefinedDataTypeDefinition typeDefinition;
                LUWCatalogGlobalVariable var = new LUWCatalogGlobalVariable();
                String name = r.getString("VARNAME");
                var.setName(name);
                String remarks = r.getString("REMARKS");
                var.setDescription(remarks);
                String typeName = r.getString("TYPENAME");
                if (typeName.equalsIgnoreCase("FLOAT")) {
                    int length = r.getInt("LENGTH");
                    typeName = length == 4 ? "REAL" : "DOUBLE";
                }
                if ((typeDefinition = databaseDefinition.getPredefinedDataTypeDefinition(typeName)) != null) {
                    EStructuralFeature feature;
                    int length;
                    int codePage;
                    if (typeDefinition.getPrimitiveType().getValue() == 0) {
                        int codePage2 = r.getInt("CODEPAGE");
                        if (codePage2 == 0) {
                            typeDefinition = databaseDefinition.getPredefinedDataTypeDefinition("CHAR () FOR BIT DATA");
                        }
                    } else if (typeDefinition.getPrimitiveType().getValue() == 1 && (codePage = r.getInt("CODEPAGE")) == 0) {
                        typeDefinition = typeName.equals("LONG VARCHAR") ? databaseDefinition.getPredefinedDataTypeDefinition("LONG VARCHAR FOR BIT DATA") : databaseDefinition.getPredefinedDataTypeDefinition("VARCHAR () FOR BIT DATA");
                    }
                    PredefinedDataType type = databaseDefinition.getPredefinedDataType(typeDefinition);
                    if (typeDefinition.isLengthSupported()) {
                        length = r.getInt("LENGTH");
                        feature = type.eClass().getEStructuralFeature("length");
                        type.eSet(feature, (Object)length);
                    } else if (typeDefinition.isPrecisionSupported()) {
                        if (typeName.equals("TIMESTAMP")) {
                            int length2 = r.getInt("SCALE");
                            feature = type.eClass().getEStructuralFeature("fractionalSecondsPrecision");
                            type.eSet(feature, (Object)length2);
                        } else {
                            int length3 = r.getInt("LENGTH");
                            if (typeName.equals("DECFLOAT")) {
                                length3 = length3 == 8 ? 16 : 34;
                            }
                            feature = type.eClass().getEStructuralFeature("precision");
                            type.eSet(feature, (Object)length3);
                        }
                    }
                    if (typeDefinition.isScaleSupported()) {
                        length = r.getInt("SCALE");
                        feature = type.eClass().getEStructuralFeature("scale");
                        type.eSet(feature, (Object)length);
                    }
                    var.setContainedType((SQLDataType)type);
                } else if (typeName.equals("REFERENCE")) {
                    typeSchemaName = r.getString("TARGET_TYPESCHEMA").trim();
                    String udtName = r.getString("TARGET_TYPENAME");
                    var.setReferencedType(LUWCatalogSchema.getUserDefinedType((Schema)this, typeSchemaName, udtName));
                } else {
                    typeSchemaName = r.getString("TYPESCHEMA").trim();
                    var.setReferencedType(LUWCatalogSchema.getUserDefinedType((Schema)this, typeSchemaName, typeName));
                }
                String readOnly = r.getString("READONLY");
                if ("C".equalsIgnoreCase(readOnly)) {
                    var.setIsConstant(true);
                }
                String defaultValue = r.getString("DEFAULT");
                var.setDefaultValue(defaultValue);
                varaibles.add((Object)var);
            }
            r.close();
            s.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.eSetDeliver(deliver);
    }

    private static DistinctUserDefinedType constructDistintUserDefinedType(ResultSet r, Schema schema) throws SQLException {
        EStructuralFeature feature;
        int length;
        int codePage;
        DatabaseDefinition databaseDefinition;
        PredefinedDataTypeDefinition sourceTypeDefinition;
        LUWCatalogDistinctUserDefinedType type = new LUWCatalogDistinctUserDefinedType();
        String sourceName = r.getString(5);
        if (sourceName.equalsIgnoreCase("FLOAT")) {
            int length2 = r.getInt(6);
            sourceName = length2 == 4 ? "REAL" : "DOUBLE";
        }
        if ((sourceTypeDefinition = (databaseDefinition = RDBCorePlugin.getDefault().getDatabaseDefinitionRegistry().getDefinition(ModelHelper.getDatabase((Schema)schema))).getPredefinedDataTypeDefinition(sourceName)).getPrimitiveType().getValue() == 0) {
            codePage = r.getInt(8);
            if (codePage == 0) {
                sourceTypeDefinition = databaseDefinition.getPredefinedDataTypeDefinition("CHAR () FOR BIT DATA");
            }
        } else if (sourceTypeDefinition.getPrimitiveType().getValue() == 1 && (codePage = r.getInt(8)) == 0) {
            sourceTypeDefinition = sourceName.equals("LONG VARCHAR") ? databaseDefinition.getPredefinedDataTypeDefinition("LONG VARCHAR FOR BIT DATA") : databaseDefinition.getPredefinedDataTypeDefinition("VARCHAR () FOR BIT DATA");
        }
        PredefinedDataType sourceType = databaseDefinition.getPredefinedDataType(sourceTypeDefinition);
        if (sourceTypeDefinition.isLengthSupported()) {
            length = r.getInt(6);
            feature = sourceType.eClass().getEStructuralFeature("length");
            sourceType.eSet(feature, (Object)length);
        } else if (sourceTypeDefinition.isPrecisionSupported()) {
            if (sourceName.equals("TIMESTAMP")) {
                length = r.getInt(7);
                feature = sourceType.eClass().getEStructuralFeature("fractionalSecondsPrecision");
                sourceType.eSet(feature, (Object)length);
            } else {
                length = r.getInt(6);
                if (sourceName.equals("DECFLOAT")) {
                    length = length == 8 ? 16 : 34;
                }
                feature = sourceType.eClass().getEStructuralFeature("precision");
                sourceType.eSet(feature, (Object)length);
            }
        }
        if (sourceTypeDefinition.isScaleSupported()) {
            length = r.getInt(7);
            feature = sourceType.eClass().getEStructuralFeature("scale");
            sourceType.eSet(feature, (Object)length);
        }
        type.setPredefinedRepresentation(sourceType);
        return type;
    }

    private static StructuredUserDefinedType constructStructuredUserDefinedType(ResultSet r) throws SQLException {
        LUWCatalogStructuredUserDefinedType type = new LUWCatalogStructuredUserDefinedType();
        String instantiable = r.getString(9);
        if (instantiable.equals("Y")) {
            type.setInstantiable(true);
        } else {
            type.setInstantiable(false);
        }
        String f = r.getString(10);
        if (f.equals("Y")) {
            type.setFinal(true);
        } else {
            type.setFinal(false);
        }
        return type;
    }

    private static LUWArrayDataType constructArrayDataType(ResultSet r, Schema schema) throws SQLException {
        LUWCatalogArrayDataType arrayType = new LUWCatalogArrayDataType();
        String sourceName = r.getString("SOURCENAME");
        if (sourceName.equalsIgnoreCase("FLOAT")) {
            int length = r.getInt("LENGTH");
            sourceName = length == 4 ? "REAL" : "DOUBLE";
        }
        DatabaseDefinition databaseDefinition = RDBCorePlugin.getDefault().getDatabaseDefinitionRegistry().getDefinition(schema.getDatabase());
        DataModelElementFactory factory = databaseDefinition.getDataModelElementFactory();
        ElementType elmentType = (ElementType)factory.create(SQLDataTypesPackage.eINSTANCE.getElementType());
        PredefinedDataTypeDefinition sourceTypeDefinition = databaseDefinition.getPredefinedDataTypeDefinition(sourceName);
        if (sourceTypeDefinition != null) {
            EStructuralFeature feature;
            int length;
            int codePage;
            if (sourceTypeDefinition.getPrimitiveType().getValue() == 0) {
                codePage = r.getInt("CODEPAGE");
                if (codePage == 0) {
                    sourceTypeDefinition = databaseDefinition.getPredefinedDataTypeDefinition("CHAR () FOR BIT DATA");
                }
            } else if (sourceTypeDefinition.getPrimitiveType().getValue() == 1 && (codePage = r.getInt("CODEPAGE")) == 0) {
                sourceTypeDefinition = sourceName.equals("LONG VARCHAR") ? databaseDefinition.getPredefinedDataTypeDefinition("LONG VARCHAR FOR BIT DATA") : databaseDefinition.getPredefinedDataTypeDefinition("VARCHAR () FOR BIT DATA");
            }
            PredefinedDataType sourceType = databaseDefinition.getPredefinedDataType(sourceTypeDefinition);
            if (sourceTypeDefinition.isLengthSupported()) {
                length = r.getInt("LENGTH");
                feature = sourceType.eClass().getEStructuralFeature("length");
                sourceType.eSet(feature, (Object)length);
            } else if (sourceTypeDefinition.isPrecisionSupported()) {
                if (sourceName.equals("TIMESTAMP")) {
                    length = r.getInt("SCALE");
                    feature = sourceType.eClass().getEStructuralFeature("fractionalSecondsPrecision");
                    sourceType.eSet(feature, (Object)length);
                } else {
                    length = r.getInt("LENGTH");
                    if (sourceName.equals("DECFLOAT")) {
                        length = length == 8 ? 16 : 34;
                    }
                    feature = sourceType.eClass().getEStructuralFeature("precision");
                    sourceType.eSet(feature, (Object)length);
                }
            }
            if (sourceTypeDefinition.isScaleSupported()) {
                int scale = r.getInt("SCALE");
                feature = sourceType.eClass().getEStructuralFeature("scale");
                sourceType.eSet(feature, (Object)scale);
            }
            elmentType.setDataType((DataType)sourceType);
        } else {
            String typeSchemaName = r.getString("SOURCESCHEMA").trim();
            UserDefinedType sourceType = LUWCatalogSchema.getUserDefinedType(schema, typeSchemaName, sourceName);
            elmentType.setDataType((DataType)sourceType);
        }
        arrayType.setElementType(elmentType);
        int arrayLen = r.getInt("ARRAY_LENGTH");
        arrayType.setMaxCardinality(arrayLen);
        return arrayType;
    }

    private String getWhereClause() {
        return " WHERE TABSCHEMA='" + LUWUtil.getIdentifier(this.getName()) + "'";
    }

    public Table getTable(String schema, String tableName) {
        Table table;
        Schema s = LUWCatalogSchema.getSchema((Schema)this, schema);
        EList tables = s.getTables();
        if (s instanceof LUWCatalogSchema && (table = ((LUWCatalogSchema)s).getCachedTable(tableName)) != null) {
            return table;
        }
        for (Table t : tables) {
            if (!t.getName().equals(tableName)) continue;
            return t;
        }
        return null;
    }

    public DB2Package getDB2Package(String name, String uniqueID) {
        if (!this.packagesLoaded) {
            this.getPackages();
        }
        DB2Package pkg = (DB2Package)this.cachedDB2Packages.get(this.getDB2PackageHashKey(name, uniqueID));
        return pkg;
    }

    private static Schema getSchema(Schema schema, String schemaName) {
        if (schema.getName().equals(schemaName)) {
            return schema;
        }
        Database d = schema.getDatabase();
        if (d instanceof LUWCatalogDatabase) {
            Schema s = ((LUWCatalogDatabase)d).getSchema(schemaName);
            if (s != null) {
                return s;
            }
        } else {
            for (Schema s : d.getSchemas()) {
                if (!s.getName().equals(schemaName)) continue;
                return s;
            }
        }
        LUWCatalogSchema newSchema = new LUWCatalogSchema();
        newSchema.setName(schemaName);
        newSchema.setDatabase(d);
        if (d instanceof LUWCatalogDatabase) {
            ((LUWCatalogDatabase)d).cacheSchema((Schema)newSchema);
        }
        return newSchema;
    }

    private void cacheTable(String name, Table table) {
        this.cachedTables.put(name, table);
    }

    private Table getCachedTable(String name) {
        return (Table)this.cachedTables.get(name);
    }

    private HashMap getCachedTable() {
        return this.cachedTables;
    }

    private void iniCachedTable() {
        this.cachedTables.clear();
    }

    private void cacheDB2Package(String name, String uniqueID, DB2Package pkg) {
        this.cachedDB2Packages.put(this.getDB2PackageHashKey(name, uniqueID), pkg);
    }

    private void iniCachedDb2Package() {
        this.cachedDB2Packages.clear();
    }

    private String getDB2PackageHashKey(String name, String uniqueID) {
        name = LUWUtil.getSingleQuotedString(name);
        return String.valueOf(name) + uniqueID;
    }

    protected static Object findElement(Object[] list, String name, EClass metaclass) {
        Object object = null;
        int i = 0;
        while (i < list.length) {
            SQLObject sqlObject = (SQLObject)list[i];
            if (sqlObject.getName().equals(name) && sqlObject.eClass() == metaclass && sqlObject instanceof ICatalogObject) {
                object = list[i];
                break;
            }
            ++i;
        }
        return object;
    }

    private static Object findTable(HashMap cachedElements, Object[] list, String name, EClass metaclass) {
        SQLObject sqlObject = (SQLObject)cachedElements.get(name);
        if (sqlObject != null && sqlObject.eClass() == metaclass && sqlObject instanceof ICatalogObject) {
            return sqlObject;
        }
        return LUWCatalogSchema.findElement(list, name, metaclass);
    }

    public static String getXSDSourceCacheRoot(ConnectionInfo connectionInfo, Schema schema) {
        StringBuffer rootPath = new StringBuffer(DB2LUWPluginActivator.getInstance().getStateLocation().toOSString()).append(File.separator);
        rootPath.append(connectionInfo.getName()).append(File.separator);
        rootPath.append(ModelHelper.getDatabase((Schema)schema).getName()).append(File.separator);
        rootPath.append(schema.getName()).append(File.separator);
        return rootPath.toString();
    }

    private static void deleteXSDSourceCache(String rootPath) {
        File file = new File(rootPath);
        File[] files = file.listFiles();
        LUWCatalogSchema.deleteFiles(files);
    }

    private static void deleteFiles(File[] files) {
        if (files == null) {
            return;
        }
        int length = files.length;
        int i = 0;
        while (i < length) {
            File file = files[i];
            if (file.isFile() && file.getName().endsWith(".xsd")) {
                file.delete();
            } else if (file.isDirectory()) {
                LUWCatalogSchema.deleteFiles(file.listFiles());
                if (file.listFiles().length == 0) {
                    file.delete();
                }
            }
            ++i;
        }
    }

    public void getPrivilegesWithFilter(String granteeFilter) throws SQLException {
        if (this.privilegeLoaded) {
            return;
        }
        EList privileges = super.getPrivileges();
        boolean deliver = this.eDeliver();
        this.eSetDeliver(false);
        try {
            LUWCatalogSchema.loadPrivileges(this.getConnection(), privileges, (Schema)this, granteeFilter);
        }
        catch (Exception exception) {}
        this.eSetDeliver(deliver);
    }

    private static UserDefinedType getUserDefinedType(Schema currentSchema, String schemaName, String userDefinedTypeName) {
        LUWCatalogDistinctUserDefinedType userDefinedType2;
        Schema schema = LUWCatalogSchema.getSchema(currentSchema, schemaName);
        for (LUWCatalogDistinctUserDefinedType userDefinedType2 : schema.getUserDefinedTypes()) {
            if (!userDefinedType2.getName().equals(userDefinedTypeName)) continue;
            return userDefinedType2;
        }
        userDefinedType2 = new LUWCatalogDistinctUserDefinedType();
        userDefinedType2.setName(userDefinedTypeName);
        userDefinedType2.setSchema(schema);
        return userDefinedType2;
    }
}

