/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.tcl.internal.testing;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.dltk.launching.IInterpreterRunner;
import org.eclipse.dltk.launching.InterpreterConfig;
import org.eclipse.dltk.tcl.internal.testing.TclTestingEngineManager;
import org.eclipse.dltk.tcl.launching.TclLaunchConfigurationDelegate;
import org.eclipse.dltk.tcl.testing.ITclTestingEngine;
import org.eclipse.dltk.testing.DLTKTestingCore;
import org.eclipse.dltk.testing.ITestingProcessor;

public class TclTestingLaunchConfigurationDelegate
extends TclLaunchConfigurationDelegate {
    private ITclTestingEngine engine;

    protected InterpreterConfig createInterpreterConfig(ILaunchConfiguration configuration, ILaunch launch) throws CoreException {
        InterpreterConfig config = super.createInterpreterConfig(configuration, launch);
        ITclTestingEngine[] engines = TclTestingEngineManager.getEngines();
        String engineId = configuration.getAttribute("org.eclipse.dltk.testing.engineId", "");
        int i = 0;
        while (i < engines.length) {
            if (engines[i].getId().equals(engineId)) {
                engines[i].correctLaunchConfiguration(config, configuration, launch);
                this.engine = engines[i];
                break;
            }
            ++i;
        }
        return config;
    }

    protected void runRunner(ILaunchConfiguration configuration, IInterpreterRunner runner, InterpreterConfig config, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        if (this.engine != null) {
            DLTKTestingCore.registerTestingProcessor((ILaunch)launch, (ITestingProcessor)this.engine.getProcessor(launch));
        }
        super.runRunner(configuration, runner, config, launch, monitor);
    }
}

