/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.tools.emf.ui.internal.common.component.virtual;

import jakarta.annotation.PostConstruct;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.value.WritableValue;
import org.eclipse.e4.tools.emf.ui.common.component.AbstractComponentEditor;
import org.eclipse.e4.tools.emf.ui.internal.common.AbstractPickList;
import org.eclipse.e4.tools.emf.ui.internal.common.E4PickList;
import org.eclipse.e4.tools.emf.ui.internal.common.VirtualEntry;
import org.eclipse.e4.ui.model.application.ui.basic.MBasicFactory;
import org.eclipse.e4.ui.model.application.ui.basic.MTrimBar;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.databinding.EMFDataBindingContext;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public abstract class AbstractVTrimEditor<M>
extends AbstractComponentEditor<M> {
    private Composite composite;
    private EMFDataBindingContext context;
    private TableViewer viewer;
    private final List<Action> actions = new ArrayList<Action>();

    protected abstract String getActionLabel();

    protected abstract List<?> getTrimBars(Object var1);

    protected abstract EReference getTrimBarFeature();

    @PostConstruct
    void init() {
        this.actions.add(new Action(this.getActionLabel(), this.createImageDescriptor("IMG_org.eclipse.e4.tools.emf.ui.modelelements.WindowTrim")){

            public void run() {
                AbstractVTrimEditor.this.handleAdd();
            }
        });
    }

    @Override
    public Composite doGetEditor(Composite parent, Object object) {
        if (this.composite == null) {
            this.context = new EMFDataBindingContext();
            this.composite = this.createForm(parent, this.context, this.getMaster());
        }
        VirtualEntry o = (VirtualEntry)object;
        this.viewer.setInput(o.getList());
        this.getMaster().setValue(o.getOriginalParent());
        return this.composite;
    }

    private Composite createForm(Composite parent, EMFDataBindingContext context, WritableValue<M> master) {
        CTabFolder folder = new CTabFolder(parent, 1024);
        CTabItem item = new CTabItem(folder, 0);
        item.setText(this.Messages.ModelTooling_Common_TabDefault);
        parent = this.createScrollableContainer((Composite)folder);
        item.setControl((Control)parent.getParent());
        E4PickList pickList = new E4PickList(parent, 0, Arrays.asList(AbstractPickList.PickListFeatures.NO_PICKER, AbstractPickList.PickListFeatures.NO_GROUP), (AbstractComponentEditor)this, (EStructuralFeature)this.getTrimBarFeature()){

            @Override
            protected void addPressed() {
                AbstractVTrimEditor.this.handleAdd();
            }

            @Override
            protected List<?> getContainerChildren(Object master) {
                return AbstractVTrimEditor.this.getTrimBars(master);
            }
        };
        pickList.setLayoutData(new GridData(4, 4, true, true, 3, 1));
        this.viewer = pickList.getList();
        folder.setSelection(0);
        return folder;
    }

    @Override
    public IObservableList<?> getChildList(Object element) {
        return null;
    }

    protected void handleAdd() {
        MTrimBar handler = MBasicFactory.INSTANCE.createTrimBar();
        this.setElementId(handler);
        Command cmd = AddCommand.create((EditingDomain)this.getEditingDomain(), (Object)this.getMaster().getValue(), (Object)this.getTrimBarFeature(), (Object)handler);
        if (cmd.canExecute()) {
            this.getEditingDomain().getCommandStack().execute(cmd);
            this.getEditor().setSelection(handler);
        }
    }

    @Override
    public List<Action> getActions(Object element) {
        ArrayList<Action> l = new ArrayList<Action>(super.getActions(element));
        l.addAll(this.actions);
        return l;
    }
}

