/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.eventmanager.util;

import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.ocl.examples.eventmanager.util.Statistics;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StatisticsImpl
extends Statistics {
    private Map<String, List<Statistics.Record>> records = new HashMap<String, List<Statistics.Record>>();
    private Map<List<Object>, Long> running = new HashMap<List<Object>, Long>();

    @Override
    public void begin(String groupId, Object key) {
        List<Object> groupIdAndKey = Arrays.asList(groupId, key);
        if (this.running.containsKey(groupIdAndKey)) {
            throw new RuntimeException("beginning an already running measurement: " + groupIdAndKey);
        }
        this.running.put(groupIdAndKey, System.nanoTime());
    }

    @Override
    public void end(String groupId, Object key) {
        long endTime = System.nanoTime();
        List<Object> groupIdAndKey = Arrays.asList(groupId, key);
        Long startTime = this.running.get(groupIdAndKey);
        if (startTime == null) {
            throw new RuntimeException("ending a measurement that hasn't been started: " + groupIdAndKey);
        }
        long value = endTime - startTime;
        this.record(groupId, key, value);
        this.running.remove(groupIdAndKey);
    }

    @Override
    public void record(String groupId, Object key, long value) {
        List<Statistics.Record> recordsForGroupId = this.records.get(groupId);
        if (recordsForGroupId == null) {
            recordsForGroupId = new LinkedList<Statistics.Record>();
            this.records.put(groupId, recordsForGroupId);
        }
        recordsForGroupId.add(new Statistics.Record(key, value));
    }

    @Override
    public List<Statistics.Record> getRecords(String groupId) {
        return this.records.get(groupId);
    }

    @Override
    public Set<String> getGroupIds() {
        return this.records.keySet();
    }

    @Override
    public void clear() {
        this.records.clear();
        this.running.clear();
    }
}

