/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.constraints.runtime;

import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.papyrus.infra.constraints.Activator;
import org.eclipse.papyrus.infra.constraints.ConstraintDescriptor;
import org.eclipse.papyrus.infra.constraints.DisplayUnit;
import org.eclipse.papyrus.infra.constraints.constraints.Constraint;
import org.eclipse.papyrus.infra.constraints.runtime.ConstraintEngine;
import org.eclipse.papyrus.infra.constraints.runtime.ConstraintEngineListener;
import org.eclipse.papyrus.infra.constraints.runtime.ConstraintFactory;
import org.eclipse.papyrus.infra.constraints.runtime.ConstraintsChangedEvent;

public abstract class DefaultConstraintEngine<E extends DisplayUnit>
implements ConstraintEngine<E> {
    private static final Pattern CONVERTER_PATTERN = Pattern.compile("(?:to|as)(?:Collection|List|Set)");
    private static final Method NO_CONVERTER = Object.class.getMethods()[0];
    private final ListenerList<ConstraintEngineListener> listeners = new ListenerList(1);
    protected final Set<Constraint> constraints = new LinkedHashSet<Constraint>();
    private final Class<? extends E> displayUnitType;
    private final Map<Class<?>, Method> collectionConverters = new HashMap();

    protected DefaultConstraintEngine(Class<? extends E> displayUnitType) {
        this.displayUnitType = displayUnitType;
    }

    @Override
    public abstract void refresh();

    @Override
    public synchronized void addConstraint(ConstraintDescriptor descriptor) {
        Constraint constraint = ConstraintFactory.getInstance().createFromModel(descriptor);
        if (constraint != null) {
            this.constraints.add(constraint);
        }
    }

    @Override
    public synchronized Set<E> getDisplayUnits(Object selection) {
        Collection<?> collection = this.asCollection(selection);
        Set<Constraint> matchedConstraints = this.match(collection);
        return this.getDisplayUnits(matchedConstraints);
    }

    private Set<Constraint> match(Collection<?> selection) {
        LinkedHashSet<Constraint> matchedConstraints = new LinkedHashSet<Constraint>();
        if (selection.isEmpty()) {
            return matchedConstraints;
        }
        for (Constraint c : this.constraints) {
            try {
                if (!c.match(selection)) continue;
                matchedConstraints.add(c);
            }
            catch (Throwable ex) {
                String errorMessage = String.format("An error occurred when executing the matching constraint %s. This constraint will be ignored", c.getDescriptor().getName());
                Activator.log.error(errorMessage, ex);
            }
        }
        this.resolveConstraintConflicts(matchedConstraints);
        return matchedConstraints;
    }

    private void resolveConstraintConflicts(Set<Constraint> matchedConstraints) {
        HashSet<Constraint> constraintsSet = new HashSet<Constraint>(matchedConstraints);
        for (Constraint c : constraintsSet) {
            for (Constraint c2 : constraintsSet) {
                if (c == c2) continue;
                if (c.getDescriptor().getOverriddenConstraints().contains((Object)c2.getDescriptor())) {
                    matchedConstraints.remove(c2);
                    continue;
                }
                if (!c2.getDescriptor().isOverrideable() || !c.overrides(c2)) continue;
                matchedConstraints.remove(c2);
            }
        }
    }

    private Set<E> getDisplayUnits(Set<Constraint> matchedConstraints) {
        LinkedHashSet<DisplayUnit> displayUnits = new LinkedHashSet<DisplayUnit>();
        for (Constraint c : matchedConstraints) {
            displayUnits.add((DisplayUnit)this.displayUnitType.cast(c.getDescriptor().getDisplay()));
        }
        return displayUnits;
    }

    @Override
    public void addConstraintEngineListener(ConstraintEngineListener listener) {
        this.listeners.add((Object)listener);
    }

    @Override
    public void removeConstraintEngineListener(ConstraintEngineListener listener) {
        this.listeners.remove((Object)listener);
    }

    protected void fireConstraintsChanged() {
        if (!this.listeners.isEmpty()) {
            Object[] toNotify = this.listeners.getListeners();
            ConstraintsChangedEvent event = new ConstraintsChangedEvent(this);
            int i = 0;
            while (i < toNotify.length) {
                try {
                    ((ConstraintEngineListener)toNotify[i]).constraintsChanged(event);
                }
                catch (Exception e) {
                    Activator.log.error("Uncaught exception in constraints-changed listener.", (Throwable)e);
                }
                ++i;
            }
        }
    }

    private Collection<?> asCollection(Object object) {
        List result;
        if (object == null) {
            result = Collections.EMPTY_LIST;
        } else if (object instanceof Collection) {
            result = (Collection)object;
        } else if (object instanceof Iterable) {
            result = StreamSupport.stream(((Iterable)object).spliterator(), false).collect(Collectors.toList());
        } else {
            Method converter = this.getToCollectionMethod(object);
            if (converter != null) {
                try {
                    result = (Collection)converter.invoke(object, new Object[0]);
                }
                catch (Exception e) {
                    this.rejectConverter(object);
                    result = Collections.EMPTY_LIST;
                }
            } else {
                result = Collections.singletonList(object);
            }
        }
        return result;
    }

    private Method getToCollectionMethod(Object object) {
        Class<?> key = object.getClass();
        Method result = this.collectionConverters.computeIfAbsent(key, owner -> {
            Method[] methodArray = owner.getMethods();
            int n = methodArray.length;
            int n2 = 0;
            while (n2 < n) {
                Method next = methodArray[n2];
                if ((next.getModifiers() & 8) == 0 && Collection.class.isAssignableFrom(next.getReturnType()) && next.getParameterCount() == 0 && CONVERTER_PATTERN.matcher(next.getName()).matches()) {
                    return next;
                }
                ++n2;
            }
            return NO_CONVERTER;
        });
        return result == NO_CONVERTER ? null : result;
    }

    private void rejectConverter(Object object) {
        this.collectionConverters.put(object.getClass(), NO_CONVERTER);
    }
}

