/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.importt.handlers;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.papyrus.infra.emf.utils.EMFHelper;
import org.eclipse.papyrus.uml.extensionpoints.Registry;
import org.eclipse.papyrus.uml.extensionpoints.profile.FilteredRegisteredProfilesAsLibrarySelectionDialog;
import org.eclipse.papyrus.uml.extensionpoints.profile.IRegisteredProfile;
import org.eclipse.papyrus.uml.extensionpoints.utils.Util;
import org.eclipse.papyrus.uml.importt.handlers.AbstractImportHandler;
import org.eclipse.papyrus.uml.profile.ui.dialogs.ElementImportTreeSelectionDialog;
import org.eclipse.papyrus.uml.profile.ui.dialogs.ProfileTreeSelectionDialog;
import org.eclipse.papyrus.uml.tools.utils.PackageUtil;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.PackageImport;
import org.eclipse.uml2.uml.UMLFactory;

public class ImportRegisteredProfileHandler
extends AbstractImportHandler {
    @Override
    protected ICommand getGMFCommand(IEvaluationContext context) {
        return new ImportProfileCommand(context);
    }

    protected void importProfiles(IRegisteredProfile[] profilesToImport) {
        ResourceSet resourceSet = Util.createTemporaryResourceSet();
        try {
            int i = 0;
            while (i < profilesToImport.length) {
                IRegisteredProfile currentLibrary = profilesToImport[i];
                URI modelUri = currentLibrary.getUri();
                Resource modelResource = resourceSet.getResource(modelUri, true);
                ProfileTreeSelectionDialog dialog = new ProfileTreeSelectionDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (Package)modelResource.getContents().get(0));
                int ret = dialog.open();
                if (ret == 0) {
                    Collection result = dialog.getResult();
                    Iterator resultIter = result.iterator();
                    while (resultIter.hasNext()) {
                        Package element = (Package)((ElementImportTreeSelectionDialog.ImportSpec)resultIter.next()).getElement();
                        PackageImport ei = UMLFactory.eINSTANCE.createPackageImport();
                        ei.setImportedPackage(element);
                        EList importedPackages = ((Package)this.getSelectedElement()).getImportedPackages();
                        if (importedPackages.contains(element)) continue;
                        ((Package)this.getSelectedElement()).getPackageImports().add((Object)ei);
                    }
                }
                ++i;
            }
        }
        finally {
            EMFHelper.unload((ResourceSet)resourceSet);
        }
    }

    protected Collection<IRegisteredProfile> getImportedProfiles() {
        ArrayList<IRegisteredProfile> profiles = new ArrayList<IRegisteredProfile>();
        IRegisteredProfile[] allLibraries = Registry.getRegisteredProfiles().toArray(new IRegisteredProfile[0]);
        int i = 0;
        while (i < allLibraries.length) {
            IRegisteredProfile registeredProfile = allLibraries[i];
            List importedPackageNames = PackageUtil.getImportedPackagesNames((Package)((Package)this.getSelectedElement()));
            if (importedPackageNames.contains(registeredProfile.getName())) {
                profiles.add(registeredProfile);
            }
            ++i;
        }
        return profiles;
    }

    public class ImportProfileCommand
    extends AbstractImportHandler.AbstractImportCommand {
        public ImportProfileCommand(IEvaluationContext context) {
            super(ImportRegisteredProfileHandler.this, new Runnable(){

                @Override
                public void run() {
                    Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
                    Object[] allProfiles = Registry.getRegisteredProfiles().toArray(new IRegisteredProfile[0]);
                    FilteredRegisteredProfilesAsLibrarySelectionDialog dialog = new FilteredRegisteredProfilesAsLibrarySelectionDialog(shell, true, allProfiles, ImportRegisteredProfileHandler.this.getImportedProfiles());
                    dialog.open();
                    if (dialog.getReturnCode() == 0) {
                        List<Object> profilesToImport = Arrays.asList(dialog.getResult());
                        ImportRegisteredProfileHandler.this.importProfiles(profilesToImport.toArray(new IRegisteredProfile[profilesToImport.size()]));
                    }
                }
            }, context, "Import Profile", "Import Profile from Registred Profiles");
        }
    }
}

