/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.common.tools.api.interpreter;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.ECrossReferenceAdapter;
import org.eclipse.sirius.common.tools.api.interpreter.EvaluationException;
import org.eclipse.sirius.common.tools.api.interpreter.EvaluationResult;
import org.eclipse.sirius.common.tools.api.interpreter.IConverter;
import org.eclipse.sirius.common.tools.api.interpreter.IEvaluationResult;
import org.eclipse.sirius.common.tools.api.interpreter.IInterpreterContext;
import org.eclipse.sirius.common.tools.api.interpreter.IInterpreterStatus;
import org.eclipse.sirius.ecore.extender.business.api.accessor.MetamodelDescriptor;
import org.eclipse.sirius.ecore.extender.business.api.accessor.ModelAccessor;

public interface IInterpreter {
    public static final String FILES = "files";

    public boolean provides(String var1);

    public String getPrefix();

    public String getVariablePrefix();

    public boolean supportsValidation();

    public Collection<IInterpreterStatus> validateExpression(IInterpreterContext var1, String var2);

    public Object evaluate(EObject var1, String var2) throws EvaluationException;

    default public IEvaluationResult evaluateExpression(EObject target, String expression) throws EvaluationException {
        Object result = this.evaluate(target, expression);
        return EvaluationResult.ofValue(result, this.getConverter());
    }

    public IConverter getConverter();

    default public Collection<EObject> evaluateCollection(EObject context, String expression) throws EvaluationException {
        Object rawValue = this.evaluate(context, expression);
        return this.getConverter().toEObjectCollection(rawValue).orElse(Collections.emptySet());
    }

    default public boolean evaluateBoolean(EObject context, String expression) throws EvaluationException {
        Object rawValue = this.evaluate(context, expression);
        return this.getConverter().toBoolean(rawValue).orElse(false);
    }

    default public EObject evaluateEObject(EObject context, String expression) throws EvaluationException {
        Object rawValue = this.evaluate(context, expression);
        return this.getConverter().toEObject(rawValue).orElse(null);
    }

    default public String evaluateString(EObject context, String expression) throws EvaluationException {
        Object rawValue = this.evaluate(context, expression);
        return this.getConverter().toString(rawValue).orElse(null);
    }

    default public Integer evaluateInteger(EObject context, String expression) throws EvaluationException {
        Object rawValue = this.evaluate(context, expression);
        return this.getConverter().toInt(rawValue).orElse(0);
    }

    public void setVariable(String var1, Object var2);

    public void unSetVariable(String var1);

    public Object getVariable(String var1);

    public Map<String, ?> getVariables();

    public void clearVariables();

    public void addImport(String var1);

    public Collection<String> getImports();

    public void removeImport(String var1);

    public void clearImports();

    public void setProperty(Object var1, Object var2);

    public void setModelAccessor(ModelAccessor var1);

    public void setCrossReferencer(ECrossReferenceAdapter var1);

    public void activateMetamodels(Collection<MetamodelDescriptor> var1);

    public void dispose();
}

