/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.tools.internal.dialogs;

import java.util.List;
import org.eclipse.gmf.runtime.common.ui.util.WindowUtil;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.sirius.diagram.ui.provider.DiagramUIPlugin;
import org.eclipse.sirius.diagram.ui.provider.Messages;
import org.eclipse.sirius.diagram.ui.tools.api.color.ColorManager;
import org.eclipse.sirius.diagram.ui.tools.internal.dialogs.ColorPaletteComposite;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.ColorDialog;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class ColorSelectionDialog
extends Dialog {
    private static final String INVALID_COLOR_SUBSTITUTE = "{-1,-1,-1}";
    private static final int NB_COLORS_PER_LINE = 10;
    private RGB dialogSelectedColor;
    private String dialogTitle;
    private String displayedColorsGroupLabel;
    private String allColorsGroupLabel;
    private final PaletteAndButtonsWrapper displayedColorsWrapper = new PaletteAndButtonsWrapper();
    private final PaletteAndButtonsWrapper allColorsWrapper = new PaletteAndButtonsWrapper();
    private List<RGB> displayedColors;
    private List<RGB> allColors;
    private String displayedColorsTooltip;
    private String allColorsTooltip;
    private Image helpImage;
    private boolean allColorsReorderAllowed;

    public ColorSelectionDialog(Shell parentShell) {
        super(parentShell);
    }

    protected Control createDialogArea(Composite parent) {
        Composite container = (Composite)super.createDialogArea(parent);
        this.initDisplayedColorsGroup(container);
        this.initAllColorsGroup(container);
        return container;
    }

    protected void initDisplayedColorsGroup(Composite container) {
        this.configureDisplayedColorsGroup(container);
    }

    protected void initAllColorsGroup(Composite container) {
        this.configureAllColorsGroup(container);
    }

    protected Group configureDisplayedColorsGroup(Composite container) {
        Group displayedColorsGroup = new Group(container, 0);
        displayedColorsGroup.setLayout((Layout)new GridLayout());
        GridData displayedColorsGroupLayoutData = new GridData(4, 4, true, true, 1, 1);
        displayedColorsGroup.setLayoutData((Object)displayedColorsGroupLayoutData);
        displayedColorsGroup.setText(this.displayedColorsGroupLabel);
        Composite paletteAndHelpIcon = new Composite((Composite)displayedColorsGroup, 0);
        GridLayout paletteAndHelpIconGridLayout = new GridLayout(2, false);
        paletteAndHelpIcon.setLayout((Layout)paletteAndHelpIconGridLayout);
        GridData paletteAndIconLayoutData = new GridData(4, 4, true, true);
        paletteAndHelpIcon.setLayoutData((Object)paletteAndIconLayoutData);
        ColorPaletteComposite displayedColorsPalette = this.createDisplayedColorsPalette(container, paletteAndHelpIcon);
        this.getDisplayedColorsWrapper().setColorPaletteComposite(displayedColorsPalette);
        Label helpIcon = new Label(paletteAndHelpIcon, 0);
        this.helpImage = this.getHelpIcon();
        helpIcon.setImage(this.helpImage);
        helpIcon.setToolTipText(this.displayedColorsTooltip);
        helpIcon.setLayoutData((Object)new GridData(0x1000008, 0x1000000, false, true, 1, 1));
        return displayedColorsGroup;
    }

    private ColorPaletteComposite createDisplayedColorsPalette(Composite compositeToRefresh, Composite parent) {
        ColorPaletteComposite displayedColorsPalette = new ColorPaletteComposite(parent, this.displayedColors, 10, true){

            @Override
            public void selectColor(RGB colorToSet) {
                super.selectColor(colorToSet);
                ColorSelectionDialog.this.dialogSelectedColor = colorToSet;
                Button displayedColorsRemoveButton = ColorSelectionDialog.this.getDisplayedColorsWrapper().getColorPaletteRemoveButton();
                if (displayedColorsRemoveButton != null) {
                    displayedColorsRemoveButton.setEnabled(colorToSet != null && this.getColors().contains(colorToSet));
                }
            }

            @Override
            protected void handleDoubleClick(Button button) {
                String colorString = (String)button.getData("color");
                RGB convertedColor = ColorManager.getDefault().stringToRGB(colorString);
                this.removeColor(convertedColor);
            }

            @Override
            protected void dropColorOnButton(Button targetButton, String droppedColorString) {
                if (!ColorSelectionDialog.INVALID_COLOR_SUBSTITUTE.equals(droppedColorString) && (this.getColors().size() < this.getNumberOfColumns() || this.getColors().contains(ColorManager.getDefault().stringToRGB(droppedColorString)))) {
                    super.dropColorOnButton(targetButton, droppedColorString);
                    Button displayedColorsRemoveButton = ColorSelectionDialog.this.getDisplayedColorsWrapper().getColorPaletteRemoveButton();
                    if (displayedColorsRemoveButton != null) {
                        displayedColorsRemoveButton.setEnabled(false);
                    }
                }
            }

            @Override
            protected void dropColorOnPalette(String droppedColorString) {
                if (!ColorSelectionDialog.INVALID_COLOR_SUBSTITUTE.equals(droppedColorString) && (this.getColors().size() < this.getNumberOfColumns() || this.getColors().contains(ColorManager.getDefault().stringToRGB(droppedColorString)))) {
                    super.dropColorOnPalette(droppedColorString);
                    Button displayedColorsRemoveButton = ColorSelectionDialog.this.getDisplayedColorsWrapper().getColorPaletteRemoveButton();
                    if (displayedColorsRemoveButton != null) {
                        displayedColorsRemoveButton.setEnabled(false);
                    }
                }
            }
        };
        return displayedColorsPalette;
    }

    protected Group configureAllColorsGroup(Composite container) {
        Group allColorsGroup = new Group(container, 0);
        allColorsGroup.setLayout((Layout)new GridLayout());
        GridData allColorsGroupLayoutData = new GridData(4, 4, true, true, 1, 1);
        allColorsGroup.setLayoutData((Object)allColorsGroupLayoutData);
        allColorsGroup.setText(this.allColorsGroupLabel);
        Composite paletteAndHelpIcon = new Composite((Composite)allColorsGroup, 0);
        GridLayout paletteAndHelpIconGridLayout = new GridLayout(2, false);
        paletteAndHelpIcon.setLayout((Layout)paletteAndHelpIconGridLayout);
        GridData paletteAndIconLayoutData = new GridData(4, 4, true, true);
        paletteAndHelpIcon.setLayoutData((Object)paletteAndIconLayoutData);
        ColorPaletteComposite allColorsPalette = this.createAllColorsPalette((Composite)allColorsGroup, paletteAndHelpIcon);
        this.getAllColorsWrapper().setColorPaletteComposite(allColorsPalette);
        Label helpIcon = new Label(paletteAndHelpIcon, 0);
        this.helpImage = this.getHelpIcon();
        helpIcon.setImage(this.helpImage);
        helpIcon.setToolTipText(this.allColorsTooltip);
        helpIcon.setLayoutData((Object)new GridData(0x1000008, 0x1000000, false, true, 1, 1));
        return allColorsGroup;
    }

    private ColorPaletteComposite createAllColorsPalette(final Composite compositeToRefresh, Composite parent) {
        ColorPaletteComposite allColorsPalette = new ColorPaletteComposite(parent, this.allColors, 10, true){

            @Override
            public void selectColor(RGB colorToSet) {
                Button allColorsRemoveButton;
                super.selectColor(colorToSet);
                ColorSelectionDialog.this.dialogSelectedColor = colorToSet;
                Button displayedColorsRemoveButton = ColorSelectionDialog.this.getDisplayedColorsWrapper().getColorPaletteRemoveButton();
                if (displayedColorsRemoveButton != null) {
                    displayedColorsRemoveButton.setEnabled(false);
                }
                if ((allColorsRemoveButton = ColorSelectionDialog.this.getAllColorsWrapper().getColorPaletteRemoveButton()) != null) {
                    allColorsRemoveButton.setEnabled(colorToSet != null && this.getColors().contains(colorToSet));
                }
            }

            @Override
            protected void handleDoubleClick(Button button) {
                ColorPaletteComposite displayedColorPalette = ColorSelectionDialog.this.getDisplayedColorsWrapper().getColorPaletteComposite();
                if (displayedColorPalette != null && displayedColorPalette.getColors().size() < displayedColorPalette.getNumberOfColumns()) {
                    String colorString = (String)button.getData("color");
                    RGB convertedColor = ColorManager.getDefault().stringToRGB(colorString);
                    displayedColorPalette.addColor(convertedColor);
                }
            }

            @Override
            protected void dragColor(Button button, String draggedColorString, DragSourceEvent dragEvent) {
                ColorPaletteComposite displayedColorPalette = ColorSelectionDialog.this.getDisplayedColorsWrapper().getColorPaletteComposite();
                if (displayedColorPalette != null && displayedColorPalette.getColors().size() < displayedColorPalette.getNumberOfColumns() || displayedColorPalette == null && this.isDroppingAllowed()) {
                    super.dragColor(button, draggedColorString, dragEvent);
                } else {
                    super.dragColor(button, ColorSelectionDialog.INVALID_COLOR_SUBSTITUTE, dragEvent);
                }
            }

            @Override
            public boolean addColor(int index, RGB colorToAdd) {
                boolean resizePaletteNeeded = this.getColors().size() % this.getNumberOfColumns() == 0;
                boolean paletteIsEmpty = this.getColors().isEmpty();
                boolean hasBeenAdded = super.addColor(index, colorToAdd);
                if (resizePaletteNeeded && hasBeenAdded && !paletteIsEmpty) {
                    ColorSelectionDialog.this.resizeDialog(compositeToRefresh, 25);
                }
                return hasBeenAdded;
            }

            @Override
            public boolean removeColor(RGB colorToRemove) {
                boolean hasBeenRemoved = super.removeColor(colorToRemove);
                boolean resizePaletteNeeded = this.getColors().size() % this.getNumberOfColumns() == 0;
                boolean paletteIsEmpty = this.getColors().isEmpty();
                if (resizePaletteNeeded && hasBeenRemoved && !paletteIsEmpty) {
                    ColorSelectionDialog.this.resizeDialog(compositeToRefresh, -25);
                }
                return hasBeenRemoved;
            }

            @Override
            protected void dropColorOnButton(Button targetButton, String droppedColorString) {
                ColorPaletteComposite displayedColorPalette = ColorSelectionDialog.this.getDisplayedColorsWrapper().getColorPaletteComposite();
                if (displayedColorPalette != null) {
                    RGB sourceDroppedColor = ColorManager.getDefault().stringToRGB(droppedColorString);
                    displayedColorPalette.basicRemoveColor(sourceDroppedColor);
                } else if (ColorSelectionDialog.this.allColorsReorderAllowed) {
                    super.dropColorOnButton(targetButton, droppedColorString);
                }
            }

            @Override
            protected void dropColorOnPalette(String droppedColorString) {
                ColorPaletteComposite displayedColorPalette = ColorSelectionDialog.this.getDisplayedColorsWrapper().getColorPaletteComposite();
                if (displayedColorPalette != null) {
                    RGB sourceDroppedColor = ColorManager.getDefault().stringToRGB(droppedColorString);
                    displayedColorPalette.basicRemoveColor(sourceDroppedColor);
                }
            }
        };
        return allColorsPalette;
    }

    protected Composite configurePaletteButtonsComposite(Group colorsGroup) {
        Composite buttonsComposite = new Composite((Composite)colorsGroup, 0);
        GridLayout buttonsGridLayout = new GridLayout(2, false);
        buttonsGridLayout.marginHeight = 0;
        buttonsComposite.setLayout((Layout)buttonsGridLayout);
        GridData buttonsGridData = new GridData(0x1000008, 0x1000000, true, true, 1, 1);
        buttonsComposite.setLayoutData((Object)buttonsGridData);
        return buttonsComposite;
    }

    protected void configureAddButton(Composite container, final PaletteAndButtonsWrapper wrapper) {
        Button addButton = new Button(container, 8);
        addButton.setText(Messages.ColorSelectionDialog_addButtonLabel);
        addButton.setToolTipText(Messages.ColorSelectionDialog_addButtonTooltip);
        addButton.setLayoutData((Object)new GridData(0x1000008, 0x1000000, true, true, 1, 1));
        addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ColorSelectionDialog.this.addClicked(wrapper);
            }
        });
        wrapper.setColorPaletteAddButton(addButton);
    }

    protected void addClicked(PaletteAndButtonsWrapper wrapper) {
        ColorDialog systemDialog = new ColorDialog(Display.getCurrent().getActiveShell());
        systemDialog.setRGB(this.getSelectedColor());
        if (this.allColors != null && !this.allColors.isEmpty()) {
            systemDialog.setRGBs(this.allColors.toArray(new RGB[this.allColors.size()]));
        }
        WindowUtil.centerDialog((Shell)systemDialog.getParent(), (Shell)Display.getCurrent().getActiveShell());
        RGB returnedSelectedColor = systemDialog.open();
        if (returnedSelectedColor != null) {
            this.dialogSelectedColor = systemDialog.getRGB();
            wrapper.getColorPaletteComposite().addColor(returnedSelectedColor);
        }
    }

    protected void configureRemoveButton(Composite container, final PaletteAndButtonsWrapper wrapper) {
        Button removeButton = new Button(container, 8);
        removeButton.setText(Messages.ColorSelectionDialog_removeButtonLabel);
        removeButton.setToolTipText(Messages.ColorSelectionDialog_removeButtonTooltip);
        removeButton.setLayoutData((Object)new GridData(0x1000008, 0x1000000, true, true, 1, 1));
        removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ColorSelectionDialog.this.removeClicked(wrapper);
            }
        });
        removeButton.setEnabled(false);
        wrapper.setColorPaletteRemoveButton(removeButton);
    }

    protected void removeClicked(PaletteAndButtonsWrapper wrapper) {
        RGB colorToRemove = wrapper.getColorPaletteComposite().getPaletteSelectedColor();
        wrapper.getColorPaletteComposite().removeColor(colorToRemove);
        wrapper.getColorPaletteRemoveButton().setEnabled(false);
        this.dialogSelectedColor = null;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(this.dialogTitle);
        newShell.setMinimumSize(363, 219);
    }

    public boolean close() {
        ColorPaletteComposite allPaletteColors;
        ColorPaletteComposite displayedPaletteColors = this.displayedColorsWrapper.getColorPaletteComposite();
        if (displayedPaletteColors != null) {
            displayedPaletteColors.dispose();
        }
        if ((allPaletteColors = this.allColorsWrapper.getColorPaletteComposite()) != null) {
            allPaletteColors.dispose();
        }
        return super.close();
    }

    private void resizeDialog(Composite composite, int additionalHeight) {
        Rectangle oldBounds = this.getShell().getBounds();
        this.getShell().setBounds(new Rectangle(oldBounds.x, oldBounds.y, oldBounds.width, oldBounds.height + additionalHeight));
        composite.layout(true);
    }

    private Image getHelpIcon() {
        if (this.helpImage == null) {
            ImageDescriptor findImageDescriptor = DiagramUIPlugin.Implementation.findImageDescriptor("icons/help.gif");
            this.helpImage = DiagramUIPlugin.getPlugin().getImage(findImageDescriptor);
        }
        return this.helpImage;
    }

    public RGB getSelectedColor() {
        return this.dialogSelectedColor;
    }

    public PaletteAndButtonsWrapper getDisplayedColorsWrapper() {
        return this.displayedColorsWrapper;
    }

    public PaletteAndButtonsWrapper getAllColorsWrapper() {
        return this.allColorsWrapper;
    }

    public void setDialogSelectedColor(RGB dialogSelectedColor) {
        this.dialogSelectedColor = dialogSelectedColor;
    }

    public void setDialogTitle(String dialogTitle) {
        this.dialogTitle = dialogTitle;
    }

    public void setDisplayedColorsGroupLabel(String displayedColorsGroupLabel) {
        this.displayedColorsGroupLabel = displayedColorsGroupLabel;
    }

    public void setAllColorsGroupLabel(String allColorsGroupLabel) {
        this.allColorsGroupLabel = allColorsGroupLabel;
    }

    public void setDisplayedColors(List<RGB> displayedColors) {
        this.displayedColors = displayedColors;
    }

    public List<RGB> getDisplayedColors() {
        return this.displayedColors;
    }

    public void setAllColors(List<RGB> allColors) {
        this.allColors = allColors;
    }

    public List<RGB> getAllColors() {
        return this.allColors;
    }

    public void setDisplayedColorsTooltip(String displayedColorsTooltip) {
        this.displayedColorsTooltip = displayedColorsTooltip;
    }

    public void setAllColorsTooltip(String allColorsTooltip) {
        this.allColorsTooltip = allColorsTooltip;
    }

    public void setAllColorsReorderAllowed(boolean allColorsReorderAllowed) {
        this.allColorsReorderAllowed = allColorsReorderAllowed;
    }

    public class PaletteAndButtonsWrapper {
        private ColorPaletteComposite colorPaletteComposite;
        private Button colorPaletteRemoveButton;
        private Button colorPaletteAddButton;

        public ColorPaletteComposite getColorPaletteComposite() {
            return this.colorPaletteComposite;
        }

        public void setColorPaletteComposite(ColorPaletteComposite colorPaletteComposite) {
            this.colorPaletteComposite = colorPaletteComposite;
        }

        public Button getColorPaletteRemoveButton() {
            return this.colorPaletteRemoveButton;
        }

        public void setColorPaletteRemoveButton(Button colorPaletteRemoveButton) {
            this.colorPaletteRemoveButton = colorPaletteRemoveButton;
        }

        public Button getColorPaletteAddButton() {
            return this.colorPaletteAddButton;
        }

        public void setColorPaletteAddButton(Button colorPaletteAddButton) {
            this.colorPaletteAddButton = colorPaletteAddButton;
        }
    }
}

