/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.preferences;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.wb.internal.core.UiMessages;
import org.eclipse.wb.internal.core.model.description.LayoutDescription;
import org.eclipse.wb.internal.core.model.description.ToolkitDescription;
import org.eclipse.wb.internal.core.model.description.helpers.LayoutDescriptionHelper;
import org.eclipse.wb.internal.core.preferences.bind.AbstractBindingPreferencesPage;
import org.eclipse.wb.internal.core.utils.binding.DataBindManager;
import org.eclipse.wb.internal.core.utils.binding.IDataEditor;
import org.eclipse.wb.internal.core.utils.binding.IDataProvider;
import org.eclipse.wb.internal.core.utils.binding.providers.StringPreferenceProvider;
import org.eclipse.wb.internal.core.utils.ui.AbstractBindingComposite;
import org.eclipse.wb.internal.core.utils.ui.GridDataFactory;
import org.eclipse.wb.internal.core.utils.ui.GridLayoutFactory;
import org.eclipse.wb.internal.core.utils.ui.UiUtils;
import org.osgi.service.prefs.BackingStoreException;

public abstract class LayoutsPreferencePage
extends AbstractBindingPreferencesPage {
    private final IEclipsePreferences m_layoutPreferences = InstanceScope.INSTANCE.getNode("layout.available");

    public LayoutsPreferencePage(ToolkitDescription toolkit) {
        super(toolkit);
    }

    protected AbstractBindingComposite createBindingComposite(Composite parent) {
        return new ContentsComposite(parent, this.m_bindManager, this.m_preferences);
    }

    public boolean performOk() {
        try {
            this.m_layoutPreferences.flush();
        }
        catch (BackingStoreException e) {
            e.printStackTrace();
        }
        return super.performOk();
    }

    protected class ContentsComposite
    extends AbstractBindingComposite {
        private final CheckboxTableViewer m_table;

        public ContentsComposite(Composite parent, DataBindManager bindManager, IPreferenceStore preferences) {
            super(parent, bindManager, preferences);
            int gridLayoutColumns = 2;
            GridLayoutFactory.create((Composite)this).noMargins().columns(gridLayoutColumns);
            new Label((Composite)this, 0).setText(UiMessages.LayoutsPreferencePage_defaultLayout);
            StructuredSelection implicitLayoutSelection = new StructuredSelection((Object)UiMessages.LayoutsPreferencePage_implicitLayout);
            final ComboViewer layoutCombo = new ComboViewer((Composite)this, 8);
            layoutCombo.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
            layoutCombo.setLabelProvider((IBaseLabelProvider)ColumnLabelProvider.createTextProvider(o -> {
                Object object = o;
                if (object instanceof LayoutDescription) {
                    void layout;
                    LayoutDescription layoutDescription = (LayoutDescription)object;
                    LayoutDescription cfr_ignored_0 = (LayoutDescription)object;
                    return layout.getName();
                }
                return (String)o;
            }));
            GridDataFactory.create((Control)layoutCombo.getCombo()).grabH().fillH();
            UiUtils.setVisibleItemCount((Combo)layoutCombo.getCombo(), (int)15);
            List layouts = LayoutDescriptionHelper.get((ToolkitDescription)LayoutsPreferencePage.this.m_toolkit);
            Collections.sort(layouts, new Comparator<LayoutDescription>(){

                @Override
                public int compare(LayoutDescription layout_1, LayoutDescription layout_2) {
                    return layout_1.getName().compareTo(layout_2.getName());
                }
            });
            layoutCombo.add((Object)UiMessages.LayoutsPreferencePage_implicitLayout);
            for (LayoutDescription layoutDescription : layouts) {
                layoutCombo.add((Object)layoutDescription.getName());
            }
            new Label((Composite)this, 0).setText(UiMessages.LayoutsPreferencePage_availableLayouts);
            this.m_table = CheckboxTableViewer.newCheckList((Composite)this, (int)2816);
            this.m_table.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
            this.m_table.setLabelProvider((IBaseLabelProvider)ColumnLabelProvider.createTextProvider(o -> ((LayoutDescription)o).getName()));
            this.m_table.setCheckStateProvider(new ICheckStateProvider(){

                public boolean isChecked(Object element) {
                    return ((ContentsComposite)ContentsComposite.this).LayoutsPreferencePage.this.m_layoutPreferences.getBoolean(((LayoutDescription)element).getLayoutClassName(), true);
                }

                public boolean isGrayed(Object element) {
                    return false;
                }
            });
            this.m_table.setInput((Object)layouts);
            this.m_table.addCheckStateListener(arg_0 -> this.lambda$2(layoutCombo, (ISelection)implicitLayoutSelection, arg_0));
            GridDataFactory.create((Control)this.m_table.getTable()).fillH().spanH(gridLayoutColumns);
            layoutCombo.setInput(this.getLayoutItems());
            this.m_bindManager.bind(new IDataEditor((ISelection)implicitLayoutSelection, layouts){
                private final /* synthetic */ ISelection val$implicitLayoutSelection;
                private final /* synthetic */ List val$layouts;
                {
                    this.val$implicitLayoutSelection = iSelection;
                    this.val$layouts = list;
                }

                public void setValue(Object value) {
                    String id = (String)value;
                    if (StringUtils.isEmpty((CharSequence)id)) {
                        layoutCombo.setSelection(this.val$implicitLayoutSelection);
                        return;
                    }
                    int index = 0;
                    while (index < this.val$layouts.size()) {
                        LayoutDescription layout = (LayoutDescription)this.val$layouts.get(index);
                        if (layout.getId().equals(id)) {
                            layoutCombo.setSelection((ISelection)new StructuredSelection((Object)layout));
                        }
                        ++index;
                    }
                }

                /*
                 * WARNING - void declaration
                 */
                public Object getValue() {
                    Object object = layoutCombo.getStructuredSelection().getFirstElement();
                    if (object instanceof LayoutDescription) {
                        void layout;
                        LayoutDescription layoutDescription = (LayoutDescription)object;
                        LayoutDescription cfr_ignored_0 = (LayoutDescription)object;
                        return layout.getId();
                    }
                    return null;
                }
            }, (IDataProvider)new StringPreferenceProvider(this.m_preferences, "layout.default"), true);
            this.checkButton((Composite)this, 2, UiMessages.LayoutsPreferencePage_inheritLayout, "layout.inheritLayoutOfParent");
        }

        private List<Object> getLayoutItems() {
            ArrayList<Object> layoutItems = new ArrayList<Object>();
            layoutItems.add(UiMessages.LayoutsPreferencePage_implicitLayout);
            layoutItems.addAll(List.of(this.m_table.getCheckedElements()));
            return Collections.unmodifiableList(layoutItems);
        }

        private /* synthetic */ void lambda$2(ComboViewer comboViewer, ISelection iSelection, CheckStateChangedEvent event) {
            LayoutDescription layout = (LayoutDescription)event.getElement();
            LayoutsPreferencePage.this.m_layoutPreferences.putBoolean(layout.getLayoutClassName(), event.getChecked());
            List<Object> input = this.getLayoutItems();
            Object selection = comboViewer.getStructuredSelection().getFirstElement();
            comboViewer.setInput(input);
            if (!input.contains(selection)) {
                comboViewer.setSelection(iSelection);
            }
        }
    }
}

