/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.model.property.category;

import org.apache.commons.lang3.StringUtils;
import org.eclipse.wb.internal.core.utils.check.Assert;

public final class PropertyCategory {
    public static final PropertyCategory NORMAL = new PropertyCategory(0, "NORMAL");
    public static final PropertyCategory PREFERRED = new PropertyCategory(-1, "PREFERRED");
    public static final PropertyCategory ADVANCED = new PropertyCategory(1, "ADVANCED");
    public static final PropertyCategory ADVANCED_REALLY = new PropertyCategory(2, "ADVANCED_REALLY");
    public static final PropertyCategory HIDDEN = new PropertyCategory(3, "HIDDEN");
    private static final int SYSTEM_BASE = 1000;
    private final int m_priority;
    private final String m_string;

    public static final PropertyCategory system(int priority) {
        return new PropertyCategory(1000 + priority, "SYSTEM:" + priority);
    }

    public static final PropertyCategory system(PropertyCategory system, int additional) {
        Assert.isTrue(system.isSystem());
        return PropertyCategory.system(system.getPriority() - 1000 + additional);
    }

    public static PropertyCategory get(String text, PropertyCategory defaultCategory) {
        if (StringUtils.equals((CharSequence)text, (CharSequence)"normal")) {
            return NORMAL;
        }
        if (StringUtils.equals((CharSequence)text, (CharSequence)"preferred")) {
            return PREFERRED;
        }
        if (StringUtils.equals((CharSequence)text, (CharSequence)"advanced")) {
            return ADVANCED;
        }
        if (StringUtils.equals((CharSequence)text, (CharSequence)"advanced-really")) {
            return ADVANCED_REALLY;
        }
        if (StringUtils.equals((CharSequence)text, (CharSequence)"hidden")) {
            return HIDDEN;
        }
        if (StringUtils.startsWith((CharSequence)text, (CharSequence)"system(")) {
            String systemText = text;
            systemText = StringUtils.removeStart((String)systemText, (String)"system(");
            systemText = StringUtils.removeEnd((String)systemText, (String)")");
            try {
                int priority = Integer.parseInt(systemText);
                return PropertyCategory.system(priority);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (defaultCategory != null) {
            return defaultCategory;
        }
        throw new IllegalArgumentException("Unknown category " + text);
    }

    private PropertyCategory(int priority, String string) {
        this.m_priority = priority;
        this.m_string = string;
    }

    public String toString() {
        return this.m_string;
    }

    /*
     * WARNING - void declaration
     */
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        Object object = obj;
        if (object instanceof PropertyCategory) {
            void category;
            PropertyCategory propertyCategory = (PropertyCategory)object;
            PropertyCategory cfr_ignored_0 = (PropertyCategory)object;
            return this.m_priority == category.m_priority;
        }
        return false;
    }

    public int hashCode() {
        return this.m_priority;
    }

    public boolean isPreferred() {
        return this == PREFERRED;
    }

    public boolean isAdvanced() {
        return this == ADVANCED;
    }

    public boolean isAdvancedReally() {
        return this == ADVANCED_REALLY;
    }

    public boolean isHidden() {
        return this == HIDDEN;
    }

    public boolean isSystem() {
        return this.m_priority >= 900;
    }

    public int getPriority() {
        return this.m_priority;
    }
}

