/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xwt.internal.utils;

import java.util.HashMap;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.swt.widgets.Event;
import org.eclipse.xwt.IEventGroup;
import org.eclipse.xwt.IObservableValueListener;
import org.eclipse.xwt.XWT;
import org.eclipse.xwt.javabean.metadata.properties.EventProperty;
import org.eclipse.xwt.metadata.IMetaclass;
import org.eclipse.xwt.metadata.IProperty;
import org.eclipse.xwt.metadata.ModelUtils;

public class ObservableValueManager
implements IObservableValueListener {
    protected HashMap<String, IObservableValue> map;
    protected Object host;

    public ObservableValueManager(Object host) {
        this.host = host;
    }

    @Override
    public Object getHost() {
        return this.host;
    }

    @Override
    public void changeValueHandle(Object object, Event event) {
        String eventName;
        IMetaclass metaclass;
        IEventGroup eventGroup;
        EventProperty property = (EventProperty)object;
        IObservableValue value = this.map.get(property.getName());
        if (value != null) {
            Boolean oldValue = (Boolean)value.getValue();
            if (oldValue == null) {
                oldValue = false;
            }
            value.setValue((Object)(oldValue == false ? 1 : 0));
        }
        if ((eventGroup = (metaclass = XWT.getMetaclass(this.host)).getEventGroup(eventName = ModelUtils.normalizePropertyName(property.getEvent().getName()))) != null) {
            eventGroup.fireEvent(this, property);
        }
    }

    @Override
    public void registerValue(IProperty property, IObservableValue observableValue) {
        if (this.map == null) {
            this.map = new HashMap();
        }
        this.map.put(property.getName(), observableValue);
        IMetaclass metaclass = XWT.getMetaclass(this.host);
        EventProperty eventProperty = (EventProperty)property;
        String eventName = ModelUtils.normalizePropertyName(eventProperty.getEvent().getName());
        IEventGroup eventGroup = metaclass.getEventGroup(eventName);
        if (eventGroup != null) {
            eventGroup.registerEvent(this, property);
        }
    }

    @Override
    public IObservableValue getValue(IProperty property) {
        if (this.map == null) {
            return null;
        }
        return this.map.get(property.getName());
    }
}

