/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.oda.util.logging;

import java.io.IOException;
import java.io.OutputStream;
import org.eclipse.datatools.connectivity.oda.util.logging.Handler;
import org.eclipse.datatools.connectivity.oda.util.logging.LogFormatter;
import org.eclipse.datatools.connectivity.oda.util.logging.LogRecord;
import org.eclipse.datatools.connectivity.oda.util.logging.LoggingErrorHandler;
import org.eclipse.datatools.connectivity.oda.util.logging.SimpleFormatter;

public class StreamHandler
extends Handler {
    private OutputStream m_outStream;

    public StreamHandler() {
        this.setFormatter(new SimpleFormatter());
    }

    public StreamHandler(OutputStream output, LogFormatter formatter) {
        this.setOutputStream(output);
        this.setFormatter(formatter);
    }

    @Override
    public void close() {
        try {
            this.flush();
            if (this.m_outStream != null) {
                this.m_outStream.close();
            }
        }
        catch (IOException ex) {
            this.reportError("", ex, LoggingErrorHandler.CLOSE_FAILURE);
        }
    }

    protected void finalize() {
        this.close();
    }

    @Override
    public void flush() {
        try {
            if (this.m_outStream != null) {
                this.m_outStream.flush();
            }
        }
        catch (IOException ex) {
            this.reportError("", ex, LoggingErrorHandler.FLUSH_FAILURE);
        }
    }

    @Override
    public void publish(LogRecord record) {
        if (!this.isLoggable(record)) {
            return;
        }
        try {
            String recordString = this.getFormatter().format(record);
            this.m_outStream.write(recordString.getBytes());
        }
        catch (IOException ex) {
            this.reportError("", ex, LoggingErrorHandler.WRITE_FAILURE);
        }
        catch (Exception ex) {
            this.reportError("", ex, LoggingErrorHandler.FORMAT_FAILURE);
        }
    }

    @Override
    public boolean isLoggable(LogRecord record) {
        return super.isLoggable(record) && this.m_outStream != null;
    }

    @Override
    public void setFormatter(LogFormatter formatter) {
        formatter = formatter != null ? formatter : new SimpleFormatter();
        super.setFormatter(formatter);
    }

    protected void setOutputStream(OutputStream outStream) {
        if (outStream == null) {
            throw new NullPointerException();
        }
        this.flush();
        this.m_outStream = outStream;
    }
}

