/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.oda.ws.ui.wizards;

import org.eclipse.datatools.connectivity.oda.OdaException;
import org.eclipse.datatools.connectivity.oda.design.DataSetDesign;
import org.eclipse.datatools.connectivity.oda.design.ui.wizards.DataSetWizardPage;
import org.eclipse.datatools.enablement.oda.ws.ui.i18n.Messages;
import org.eclipse.datatools.enablement.oda.ws.ui.util.WSConsole;
import org.eclipse.datatools.enablement.oda.ws.ui.util.WSUIUtil;
import org.eclipse.datatools.enablement.oda.ws.ui.wizards.XMLTableMappingPage;
import org.eclipse.datatools.enablement.oda.ws.util.WSUtil;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class SOAPResponsePage
extends DataSetWizardPage {
    private transient Button dftXSDRadio;
    private transient Button resXSDRadio;
    private transient Button extXSDRadio;
    private transient Button dftXMLRadio;
    private transient Button extXMLRadio;
    private Button XSDBrowseBtn;
    private Button connectBtn;
    private Button browseXMLBtn;
    private transient Text xmlFileURI;
    private transient Text xsdFileURI;
    private transient Text soapEndPoint;
    private boolean saved = false;
    private boolean initialized = false;
    private static String DEFAULT_MESSAGE = Messages.getString("soapResponsePage.message.default");

    public SOAPResponsePage(String pageName) {
        super(pageName);
        this.setMessage(DEFAULT_MESSAGE);
    }

    public void createPageCustomControl(Composite parent) {
        this.setControl(this.createPageControl(parent));
        this.initializeControl();
        WSUIUtil.setSystemHelp(this.getControl(), "org.eclipse.datatools.oda.cshelp.Wizard_WS_SOAP_RESPONSE_ID");
        this.initialized = true;
    }

    private Control createPageControl(Composite parent) {
        ScrolledComposite sComposite = new ScrolledComposite(parent, 768);
        sComposite.setLayout((Layout)new GridLayout());
        sComposite.setLayoutData((Object)new GridData(1808));
        sComposite.setMinWidth(600);
        sComposite.setExpandHorizontal(true);
        Composite composite = new Composite((Composite)sComposite, 0);
        GridLayout layout = new GridLayout(1, false);
        layout.verticalSpacing = 20;
        composite.setLayout((Layout)layout);
        GridData layoutData = new GridData(272);
        composite.setLayoutData((Object)layoutData);
        this.setupXSDGroup(composite);
        this.setupXMLGroup(composite);
        Point size = composite.computeSize(-1, -1);
        composite.setSize(size.x, size.y);
        sComposite.setContent((Control)composite);
        this.setControl((Control)sComposite);
        return sComposite;
    }

    private void setupXSDGroup(Composite parent) {
        Group group = new Group(parent, 16);
        group.setText(Messages.getString("soapResponsePage.group.schema"));
        group.setLayout((Layout)new GridLayout(3, false));
        GridData layoutData = new GridData(768);
        group.setLayoutData((Object)layoutData);
        this.setupDFTXSDRadio((Composite)group);
        this.setupRESXSDRadio((Composite)group);
        this.setupEXTXSDRadio((Composite)group);
        this.initXSDGroupStatus();
    }

    private void initXSDGroupStatus() {
        if (this.getInitializationDesign() == null || this.getInitializationDesign().getPrivateProperties() == null) {
            this.setToDefaultXSDSelection();
            return;
        }
        String schema = this.getInitializationDesign().getPrivateProperties().getProperty("ResponseSchema");
        if (schema != null) {
            if ("FromWSServer".equals(schema)) {
                this.resXSDRadio.setSelection(true);
                WSConsole.getInstance().setPropertyValue("ResponseSchema", "FromWSServer");
            } else if ("FromExternalSchema".equals(schema)) {
                this.extXSDRadio.setSelection(true);
                WSConsole.getInstance().setPropertyValue("ResponseSchema", "FromExternalSchema");
            } else {
                this.setToDefaultXSDSelection();
            }
        } else {
            this.setToDefaultXSDSelection();
        }
        this.updateXSDGroupControl();
    }

    private void setToDefaultXSDSelection() {
        this.dftXSDRadio.setSelection(true);
        this.updateXSDGroupControl();
        WSConsole.getInstance().setPropertyValue("ResponseSchema", "FromWSDL");
    }

    private void setupDFTXSDRadio(Composite parent) {
        this.dftXSDRadio = new Button(parent, 16);
        GridData layoutData = new GridData();
        layoutData.horizontalSpan = 3;
        this.dftXSDRadio.setLayoutData((Object)layoutData);
        this.dftXSDRadio.setText(Messages.getString("soapResponsePage.radio.defaultSchema"));
        this.dftXSDRadio.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                WSConsole.getInstance().setPropertyValue("xmlTempFileURI", "");
                WSConsole.getInstance().setPropertyValue("ResponseSchema", "FromWSDL");
                SOAPResponsePage.this.updateXSDGroupControl();
                SOAPResponsePage.this.updatePageStatus();
            }
        });
    }

    private void setupRESXSDRadio(Composite parent) {
        this.resXSDRadio = new Button(parent, 16);
        GridData layoutData = new GridData();
        layoutData.horizontalSpan = 3;
        this.resXSDRadio.setLayoutData((Object)layoutData);
        this.resXSDRadio.setText(Messages.getString("soapResponsePage.radio.reponseSchema"));
        this.resXSDRadio.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                WSConsole.getInstance().setPropertyValue("xmlTempFileURI", "");
                WSConsole.getInstance().setPropertyValue("ResponseSchema", "FromWSServer");
                SOAPResponsePage.this.updateXSDGroupControl();
                SOAPResponsePage.this.updatePageStatus();
            }
        });
    }

    private void setupEXTXSDRadio(Composite parent) {
        this.extXSDRadio = new Button(parent, 16);
        GridData layoutData = new GridData();
        this.extXSDRadio.setLayoutData((Object)layoutData);
        this.extXSDRadio.setText(Messages.getString("soapResponsePage.radio.externalSchema"));
        this.extXSDRadio.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                WSConsole.getInstance().setPropertyValue("ResponseSchema", "FromExternalSchema");
                SOAPResponsePage.this.updatePageStatus();
            }
        });
        this.xsdFileURI = new Text(parent, 2048);
        layoutData = new GridData(768);
        this.xsdFileURI.setLayoutData((Object)layoutData);
        this.xsdFileURI.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SOAPResponsePage.this.updatePageStatus();
            }
        });
        this.XSDBrowseBtn = new Button(parent, 0);
        layoutData = new GridData();
        this.XSDBrowseBtn.setLayoutData((Object)layoutData);
        this.XSDBrowseBtn.setText(Messages.getString("soapResponsePage.button.browse1"));
        this.XSDBrowseBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String selectedLocation;
                FileDialog dialog = new FileDialog(PlatformUI.getWorkbench().getDisplay().getActiveShell(), 4096);
                dialog.setFilterExtensions(new String[]{"*.xsd", "*.*"});
                if (SOAPResponsePage.this.xsdFileURI.getText() != null && SOAPResponsePage.this.xsdFileURI.getText().trim().length() > 0) {
                    dialog.setFilterPath(SOAPResponsePage.this.xsdFileURI.getText());
                }
                if ((selectedLocation = dialog.open()) != null) {
                    SOAPResponsePage.this.xsdFileURI.setText(selectedLocation);
                }
                SOAPResponsePage.this.updateXSDGroupControl();
            }
        });
    }

    private void updateXSDGroupControl() {
        this.xsdFileURI.setEnabled(this.extXSDRadio.getSelection());
        this.XSDBrowseBtn.setEnabled(this.extXSDRadio.getSelection());
    }

    private void setupXMLGroup(Composite parent) {
        Group group = new Group(parent, 16);
        group.setLayout((Layout)new GridLayout(2, false));
        GridData layoutData = new GridData(768);
        group.setLayoutData((Object)layoutData);
        group.setText(Messages.getString("soapResponsePage.group.xml"));
        this.setupDFTXMLRadio((Composite)group);
        this.setupEXTXMLRadio((Composite)group);
        this.initXMLRadioGroupStatus();
    }

    private void initXMLRadioGroupStatus() {
        if (this.getInitializationDesign() == null || this.getInitializationDesign().getPrivateProperties() == null) {
            this.updateSOAPEndPointSelection(true);
            return;
        }
        String useSOAPEndPoint = this.getInitializationDesign().getPrivateProperties().getProperty("useSoapEndPoint");
        if (useSOAPEndPoint != null) {
            this.updateSOAPEndPointSelection(Boolean.valueOf(useSOAPEndPoint));
        } else {
            this.updateSOAPEndPointSelection(true);
        }
    }

    private void updateSOAPEndPointSelection(boolean SOAPEndPointSelected) {
        this.dftXMLRadio.setSelection(SOAPEndPointSelected);
        this.extXMLRadio.setSelection(!SOAPEndPointSelected);
        WSConsole.getInstance().setPropertyValue("useSoapEndPoint", String.valueOf(SOAPEndPointSelected));
    }

    private void setupDFTXMLRadio(Composite parent) {
        this.dftXMLRadio = new Button(parent, 16);
        GridData layoutData = new GridData();
        layoutData.horizontalSpan = 2;
        this.dftXMLRadio.setLayoutData((Object)layoutData);
        this.dftXMLRadio.setText(Messages.getString("soapResponsePage.radio.endPoint"));
        this.dftXMLRadio.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SOAPResponsePage.this.updateXMLControlStatus();
            }
        });
        this.soapEndPoint = new Text(parent, 2048);
        layoutData = new GridData(768);
        this.soapEndPoint.setLayoutData((Object)layoutData);
        this.connectBtn = new Button(parent, 0);
        layoutData = new GridData();
        this.connectBtn.setLayoutData((Object)layoutData);
        this.connectBtn.setText(Messages.getString("soapResponsePage.button.connect"));
        this.connectBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    SOAPResponsePage.this.saveToModel();
                    WSConsole.getInstance().createXMLTempFileURI();
                    SOAPResponsePage.this.setMessage(DEFAULT_MESSAGE);
                }
                catch (OdaException e1) {
                    SOAPResponsePage.this.setMessage(e1.getMessage(), 3);
                }
            }
        });
        this.soapEndPoint.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SOAPResponsePage.this.connectBtn.setEnabled(SOAPResponsePage.this.soapEndPoint.getText().trim().length() > 0);
            }
        });
    }

    private void setupEXTXMLRadio(Composite parent) {
        this.extXMLRadio = new Button(parent, 16);
        GridData layoutData = new GridData();
        layoutData.horizontalSpan = 2;
        this.extXMLRadio.setLayoutData((Object)layoutData);
        this.extXMLRadio.setText(Messages.getString("soapResponsePage.radio.externalXML"));
        this.extXMLRadio.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SOAPResponsePage.this.updateXMLControlStatus();
            }
        });
        this.xmlFileURI = new Text(parent, 2048);
        layoutData = new GridData(768);
        this.xmlFileURI.setLayoutData((Object)layoutData);
        this.browseXMLBtn = new Button(parent, 0);
        layoutData = new GridData();
        this.browseXMLBtn.setLayoutData((Object)layoutData);
        this.browseXMLBtn.setText(Messages.getString("soapResponsePage.button.browse2"));
        this.browseXMLBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String selectedLocation;
                FileDialog dialog = new FileDialog(PlatformUI.getWorkbench().getDisplay().getActiveShell(), 4096);
                dialog.setFilterExtensions(new String[]{"*.xml", "*.*"});
                if (SOAPResponsePage.this.xmlFileURI.getText() != null && SOAPResponsePage.this.xmlFileURI.getText().trim().length() > 0) {
                    dialog.setFilterPath(SOAPResponsePage.this.xmlFileURI.getText());
                }
                if ((selectedLocation = dialog.open()) != null) {
                    SOAPResponsePage.this.xmlFileURI.setText(selectedLocation);
                }
            }
        });
    }

    private void updateXMLControlStatus() {
        boolean defaultXMLSelection = this.dftXMLRadio.getSelection();
        this.soapEndPoint.setEnabled(defaultXMLSelection);
        this.connectBtn.setEnabled(defaultXMLSelection && this.soapEndPoint.getText().trim().length() > 0);
        this.xmlFileURI.setEnabled(!defaultXMLSelection);
        this.browseXMLBtn.setEnabled(!defaultXMLSelection);
    }

    private void initializeControl() {
        this.initWSConsole();
        this.initFromModel();
    }

    private void initWSConsole() {
        if (!WSConsole.getInstance().isSessionOK()) {
            WSConsole.getInstance().start(this.getInitializationDesign());
        }
    }

    private void initFromModel() {
        String value;
        String xml;
        String xsd = WSConsole.getInstance().getPropertyValue("xsdFileURI");
        if (!WSUtil.isNull((Object)xsd)) {
            this.dftXSDRadio.setSelection(false);
            this.extXSDRadio.setSelection(true);
            this.xsdFileURI.setText(xsd);
        }
        if (!WSUtil.isNull((Object)(xml = WSConsole.getInstance().getPropertyValue("xmlFileURI")))) {
            this.xmlFileURI.setText(xml);
        }
        if ((value = WSConsole.getInstance().getPropertyValue("soapEndPoint")) != null) {
            this.soapEndPoint.setText(value);
        }
        this.updateXMLControlStatus();
        this.saved = false;
    }

    protected DataSetDesign collectDataSetDesign(DataSetDesign design) {
        this.savePage(design);
        return design;
    }

    private void savePage(DataSetDesign design) {
        if (!this.initialized || this.dftXMLRadio == null || !WSConsole.getInstance().isSessionOK()) {
            return;
        }
        if (this.isControlCreated() && !this.saved) {
            this.saveToModel();
        }
        design.getPrivateProperties().setProperty("xmlFileURI", WSConsole.getInstance().getPropertyValue("xmlFileURI"));
        design.getPrivateProperties().setProperty("xsdFileURI", WSConsole.getInstance().getPropertyValue("xsdFileURI"));
        design.getPrivateProperties().setProperty("ResponseSchema", WSConsole.getInstance().getPropertyValue("ResponseSchema"));
        design.getPrivateProperties().setProperty("useSoapEndPoint", String.valueOf(this.dftXMLRadio.getSelection()));
        design.getDataSourceDesign().getPublicProperties().setProperty("soapEndPoint", WSConsole.getInstance().getPropertyValue("soapEndPoint"));
    }

    protected void refresh(DataSetDesign dataSetDesign) {
        super.refresh(dataSetDesign);
        if (this.isDirty(dataSetDesign)) {
            this.refresh();
        }
    }

    private boolean isDirty(DataSetDesign dataSetDesign) {
        return false;
    }

    void refresh() {
    }

    protected boolean canLeave() {
        this.saveToModel();
        return super.canLeave();
    }

    public boolean canFlipToNextPage() {
        if (this.extXSDRadio.getSelection() && WSUtil.isNull((Object)this.xsdFileURI.getText())) {
            return false;
        }
        return this.isPageComplete();
    }

    public void updatePageStatus() {
        if (this.extXSDRadio.getSelection() && WSUtil.isNull((Object)this.xsdFileURI.getText())) {
            this.setPageComplete(false);
        }
        this.setPageComplete(true);
    }

    public IWizardPage getNextPage() {
        this.saveToModel();
        IWizardPage page = super.getNextPage();
        if (page instanceof XMLTableMappingPage) {
            ((XMLTableMappingPage)page).refresh();
        }
        return page;
    }

    private void saveToModel() {
        if (!this.initialized || this.extXSDRadio == null || this.extXSDRadio.isDisposed()) {
            return;
        }
        if (this.extXSDRadio.getSelection() && this.xsdFileURI != null) {
            WSConsole.getInstance().setPropertyValue("xsdFileURI", this.xsdFileURI.getText());
        } else {
            WSConsole.getInstance().setPropertyValue("xsdFileURI", "");
        }
        if (this.soapEndPoint != null) {
            WSConsole.getInstance().setPropertyValue("soapEndPoint", this.soapEndPoint.getText());
        }
        if (this.xmlFileURI != null) {
            WSConsole.getInstance().setPropertyValue("xmlFileURI", this.xmlFileURI.getText());
        }
    }

    protected void cleanup() {
        WSConsole.getInstance().terminateSession();
    }
}

