package org.eclipse.gef.dot.internal.ide.language.contentassist.antlr.internal;
import java.util.Map;
import java.util.HashMap;

import java.io.InputStream;
import org.eclipse.xtext.*;
import org.eclipse.xtext.parser.*;
import org.eclipse.xtext.parser.impl.*;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.parser.antlr.XtextTokenStream;
import org.eclipse.xtext.parser.antlr.XtextTokenStream.HiddenTokens;
import org.eclipse.xtext.ide.editor.contentassist.antlr.internal.AbstractInternalContentAssistParser;
import org.eclipse.xtext.ide.editor.contentassist.antlr.internal.DFA;
import org.eclipse.gef.dot.internal.language.services.DotStyleGrammarAccess;



import org.antlr.runtime.*;
import java.util.Stack;
import java.util.List;
import java.util.ArrayList;

@SuppressWarnings("all")
public class InternalDotStyleParser extends AbstractInternalContentAssistParser {
    public static final String[] tokenNames = new String[] {
        "<invalid>", "<EOR>", "<DOWN>", "<UP>", "LeftParenthesis", "RightParenthesis", "Comma", "RULE_WS", "RULE_NAME"
    };
    public static final int RULE_WS=7;
    public static final int RightParenthesis=5;
    public static final int RULE_NAME=8;
    public static final int Comma=6;
    public static final int LeftParenthesis=4;
    public static final int EOF=-1;

    // delegates
    // delegators


        public InternalDotStyleParser(TokenStream input) {
            this(input, new RecognizerSharedState());
        }
        public InternalDotStyleParser(TokenStream input, RecognizerSharedState state) {
            super(input, state);
             
        }
        

    public String[] getTokenNames() { return InternalDotStyleParser.tokenNames; }
    public String getGrammarFileName() { return "InternalDotStyleParser.g"; }


    	private DotStyleGrammarAccess grammarAccess;
    	private final Map<String, String> tokenNameToValue = new HashMap<String, String>();
    	
    	{
    		tokenNameToValue.put("LeftParenthesis", "'('");
    		tokenNameToValue.put("RightParenthesis", "')'");
    		tokenNameToValue.put("Comma", "','");
    	}

    	public void setGrammarAccess(DotStyleGrammarAccess grammarAccess) {
    		this.grammarAccess = grammarAccess;
    	}

    	@Override
    	protected Grammar getGrammar() {
    		return grammarAccess.getGrammar();
    	}

    	@Override
    	protected String getValueForTokenName(String tokenName) {
    		String result = tokenNameToValue.get(tokenName);
    		if (result == null)
    			result = tokenName;
    		return result;
    	}



    // $ANTLR start "entryRuleStyle"
    // InternalDotStyleParser.g:58:1: entryRuleStyle : ruleStyle EOF ;
    public final void entryRuleStyle() throws RecognitionException {
        try {
            // InternalDotStyleParser.g:59:1: ( ruleStyle EOF )
            // InternalDotStyleParser.g:60:1: ruleStyle EOF
            {
             before(grammarAccess.getStyleRule()); 
            pushFollow(FOLLOW_1);
            ruleStyle();

            state._fsp--;

             after(grammarAccess.getStyleRule()); 
            match(input,EOF,FOLLOW_2); 

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return ;
    }
    // $ANTLR end "entryRuleStyle"


    // $ANTLR start "ruleStyle"
    // InternalDotStyleParser.g:67:1: ruleStyle : ( ( rule__Style__Group__0 ) ) ;
    public final void ruleStyle() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotStyleParser.g:71:2: ( ( ( rule__Style__Group__0 ) ) )
            // InternalDotStyleParser.g:72:2: ( ( rule__Style__Group__0 ) )
            {
            // InternalDotStyleParser.g:72:2: ( ( rule__Style__Group__0 ) )
            // InternalDotStyleParser.g:73:3: ( rule__Style__Group__0 )
            {
             before(grammarAccess.getStyleAccess().getGroup()); 
            // InternalDotStyleParser.g:74:3: ( rule__Style__Group__0 )
            // InternalDotStyleParser.g:74:4: rule__Style__Group__0
            {
            pushFollow(FOLLOW_2);
            rule__Style__Group__0();

            state._fsp--;


            }

             after(grammarAccess.getStyleAccess().getGroup()); 

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "ruleStyle"


    // $ANTLR start "entryRuleStyleItem"
    // InternalDotStyleParser.g:83:1: entryRuleStyleItem : ruleStyleItem EOF ;
    public final void entryRuleStyleItem() throws RecognitionException {
        try {
            // InternalDotStyleParser.g:84:1: ( ruleStyleItem EOF )
            // InternalDotStyleParser.g:85:1: ruleStyleItem EOF
            {
             before(grammarAccess.getStyleItemRule()); 
            pushFollow(FOLLOW_1);
            ruleStyleItem();

            state._fsp--;

             after(grammarAccess.getStyleItemRule()); 
            match(input,EOF,FOLLOW_2); 

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return ;
    }
    // $ANTLR end "entryRuleStyleItem"


    // $ANTLR start "ruleStyleItem"
    // InternalDotStyleParser.g:92:1: ruleStyleItem : ( ( rule__StyleItem__Group__0 ) ) ;
    public final void ruleStyleItem() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotStyleParser.g:96:2: ( ( ( rule__StyleItem__Group__0 ) ) )
            // InternalDotStyleParser.g:97:2: ( ( rule__StyleItem__Group__0 ) )
            {
            // InternalDotStyleParser.g:97:2: ( ( rule__StyleItem__Group__0 ) )
            // InternalDotStyleParser.g:98:3: ( rule__StyleItem__Group__0 )
            {
             before(grammarAccess.getStyleItemAccess().getGroup()); 
            // InternalDotStyleParser.g:99:3: ( rule__StyleItem__Group__0 )
            // InternalDotStyleParser.g:99:4: rule__StyleItem__Group__0
            {
            pushFollow(FOLLOW_2);
            rule__StyleItem__Group__0();

            state._fsp--;


            }

             after(grammarAccess.getStyleItemAccess().getGroup()); 

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "ruleStyleItem"


    // $ANTLR start "rule__Style__Group__0"
    // InternalDotStyleParser.g:107:1: rule__Style__Group__0 : rule__Style__Group__0__Impl rule__Style__Group__1 ;
    public final void rule__Style__Group__0() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotStyleParser.g:111:1: ( rule__Style__Group__0__Impl rule__Style__Group__1 )
            // InternalDotStyleParser.g:112:2: rule__Style__Group__0__Impl rule__Style__Group__1
            {
            pushFollow(FOLLOW_3);
            rule__Style__Group__0__Impl();

            state._fsp--;

            pushFollow(FOLLOW_2);
            rule__Style__Group__1();

            state._fsp--;


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__Style__Group__0"


    // $ANTLR start "rule__Style__Group__0__Impl"
    // InternalDotStyleParser.g:119:1: rule__Style__Group__0__Impl : ( () ) ;
    public final void rule__Style__Group__0__Impl() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotStyleParser.g:123:1: ( ( () ) )
            // InternalDotStyleParser.g:124:1: ( () )
            {
            // InternalDotStyleParser.g:124:1: ( () )
            // InternalDotStyleParser.g:125:2: ()
            {
             before(grammarAccess.getStyleAccess().getStyleAction_0()); 
            // InternalDotStyleParser.g:126:2: ()
            // InternalDotStyleParser.g:126:3: 
            {
            }

             after(grammarAccess.getStyleAccess().getStyleAction_0()); 

            }


            }

        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__Style__Group__0__Impl"


    // $ANTLR start "rule__Style__Group__1"
    // InternalDotStyleParser.g:134:1: rule__Style__Group__1 : rule__Style__Group__1__Impl ;
    public final void rule__Style__Group__1() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotStyleParser.g:138:1: ( rule__Style__Group__1__Impl )
            // InternalDotStyleParser.g:139:2: rule__Style__Group__1__Impl
            {
            pushFollow(FOLLOW_2);
            rule__Style__Group__1__Impl();

            state._fsp--;


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__Style__Group__1"


    // $ANTLR start "rule__Style__Group__1__Impl"
    // InternalDotStyleParser.g:145:1: rule__Style__Group__1__Impl : ( ( rule__Style__Group_1__0 )? ) ;
    public final void rule__Style__Group__1__Impl() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotStyleParser.g:149:1: ( ( ( rule__Style__Group_1__0 )? ) )
            // InternalDotStyleParser.g:150:1: ( ( rule__Style__Group_1__0 )? )
            {
            // InternalDotStyleParser.g:150:1: ( ( rule__Style__Group_1__0 )? )
            // InternalDotStyleParser.g:151:2: ( rule__Style__Group_1__0 )?
            {
             before(grammarAccess.getStyleAccess().getGroup_1()); 
            // InternalDotStyleParser.g:152:2: ( rule__Style__Group_1__0 )?
            int alt1=2;
            int LA1_0 = input.LA(1);

            if ( (LA1_0==RULE_NAME) ) {
                alt1=1;
            }
            switch (alt1) {
                case 1 :
                    // InternalDotStyleParser.g:152:3: rule__Style__Group_1__0
                    {
                    pushFollow(FOLLOW_2);
                    rule__Style__Group_1__0();

                    state._fsp--;


                    }
                    break;

            }

             after(grammarAccess.getStyleAccess().getGroup_1()); 

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__Style__Group__1__Impl"


    // $ANTLR start "rule__Style__Group_1__0"
    // InternalDotStyleParser.g:161:1: rule__Style__Group_1__0 : rule__Style__Group_1__0__Impl rule__Style__Group_1__1 ;
    public final void rule__Style__Group_1__0() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotStyleParser.g:165:1: ( rule__Style__Group_1__0__Impl rule__Style__Group_1__1 )
            // InternalDotStyleParser.g:166:2: rule__Style__Group_1__0__Impl rule__Style__Group_1__1
            {
            pushFollow(FOLLOW_4);
            rule__Style__Group_1__0__Impl();

            state._fsp--;

            pushFollow(FOLLOW_2);
            rule__Style__Group_1__1();

            state._fsp--;


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__Style__Group_1__0"


    // $ANTLR start "rule__Style__Group_1__0__Impl"
    // InternalDotStyleParser.g:173:1: rule__Style__Group_1__0__Impl : ( ( rule__Style__StyleItemsAssignment_1_0 ) ) ;
    public final void rule__Style__Group_1__0__Impl() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotStyleParser.g:177:1: ( ( ( rule__Style__StyleItemsAssignment_1_0 ) ) )
            // InternalDotStyleParser.g:178:1: ( ( rule__Style__StyleItemsAssignment_1_0 ) )
            {
            // InternalDotStyleParser.g:178:1: ( ( rule__Style__StyleItemsAssignment_1_0 ) )
            // InternalDotStyleParser.g:179:2: ( rule__Style__StyleItemsAssignment_1_0 )
            {
             before(grammarAccess.getStyleAccess().getStyleItemsAssignment_1_0()); 
            // InternalDotStyleParser.g:180:2: ( rule__Style__StyleItemsAssignment_1_0 )
            // InternalDotStyleParser.g:180:3: rule__Style__StyleItemsAssignment_1_0
            {
            pushFollow(FOLLOW_2);
            rule__Style__StyleItemsAssignment_1_0();

            state._fsp--;


            }

             after(grammarAccess.getStyleAccess().getStyleItemsAssignment_1_0()); 

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__Style__Group_1__0__Impl"


    // $ANTLR start "rule__Style__Group_1__1"
    // InternalDotStyleParser.g:188:1: rule__Style__Group_1__1 : rule__Style__Group_1__1__Impl ;
    public final void rule__Style__Group_1__1() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotStyleParser.g:192:1: ( rule__Style__Group_1__1__Impl )
            // InternalDotStyleParser.g:193:2: rule__Style__Group_1__1__Impl
            {
            pushFollow(FOLLOW_2);
            rule__Style__Group_1__1__Impl();

            state._fsp--;


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__Style__Group_1__1"


    // $ANTLR start "rule__Style__Group_1__1__Impl"
    // InternalDotStyleParser.g:199:1: rule__Style__Group_1__1__Impl : ( ( rule__Style__Group_1_1__0 )* ) ;
    public final void rule__Style__Group_1__1__Impl() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotStyleParser.g:203:1: ( ( ( rule__Style__Group_1_1__0 )* ) )
            // InternalDotStyleParser.g:204:1: ( ( rule__Style__Group_1_1__0 )* )
            {
            // InternalDotStyleParser.g:204:1: ( ( rule__Style__Group_1_1__0 )* )
            // InternalDotStyleParser.g:205:2: ( rule__Style__Group_1_1__0 )*
            {
             before(grammarAccess.getStyleAccess().getGroup_1_1()); 
            // InternalDotStyleParser.g:206:2: ( rule__Style__Group_1_1__0 )*
            loop2:
            do {
                int alt2=2;
                int LA2_0 = input.LA(1);

                if ( (LA2_0==Comma) ) {
                    alt2=1;
                }


                switch (alt2) {
            	case 1 :
            	    // InternalDotStyleParser.g:206:3: rule__Style__Group_1_1__0
            	    {
            	    pushFollow(FOLLOW_5);
            	    rule__Style__Group_1_1__0();

            	    state._fsp--;


            	    }
            	    break;

            	default :
            	    break loop2;
                }
            } while (true);

             after(grammarAccess.getStyleAccess().getGroup_1_1()); 

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__Style__Group_1__1__Impl"


    // $ANTLR start "rule__Style__Group_1_1__0"
    // InternalDotStyleParser.g:215:1: rule__Style__Group_1_1__0 : rule__Style__Group_1_1__0__Impl rule__Style__Group_1_1__1 ;
    public final void rule__Style__Group_1_1__0() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotStyleParser.g:219:1: ( rule__Style__Group_1_1__0__Impl rule__Style__Group_1_1__1 )
            // InternalDotStyleParser.g:220:2: rule__Style__Group_1_1__0__Impl rule__Style__Group_1_1__1
            {
            pushFollow(FOLLOW_3);
            rule__Style__Group_1_1__0__Impl();

            state._fsp--;

            pushFollow(FOLLOW_2);
            rule__Style__Group_1_1__1();

            state._fsp--;


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__Style__Group_1_1__0"


    // $ANTLR start "rule__Style__Group_1_1__0__Impl"
    // InternalDotStyleParser.g:227:1: rule__Style__Group_1_1__0__Impl : ( Comma ) ;
    public final void rule__Style__Group_1_1__0__Impl() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotStyleParser.g:231:1: ( ( Comma ) )
            // InternalDotStyleParser.g:232:1: ( Comma )
            {
            // InternalDotStyleParser.g:232:1: ( Comma )
            // InternalDotStyleParser.g:233:2: Comma
            {
             before(grammarAccess.getStyleAccess().getCommaKeyword_1_1_0()); 
            match(input,Comma,FOLLOW_2); 
             after(grammarAccess.getStyleAccess().getCommaKeyword_1_1_0()); 

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__Style__Group_1_1__0__Impl"


    // $ANTLR start "rule__Style__Group_1_1__1"
    // InternalDotStyleParser.g:242:1: rule__Style__Group_1_1__1 : rule__Style__Group_1_1__1__Impl ;
    public final void rule__Style__Group_1_1__1() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotStyleParser.g:246:1: ( rule__Style__Group_1_1__1__Impl )
            // InternalDotStyleParser.g:247:2: rule__Style__Group_1_1__1__Impl
            {
            pushFollow(FOLLOW_2);
            rule__Style__Group_1_1__1__Impl();

            state._fsp--;


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__Style__Group_1_1__1"


    // $ANTLR start "rule__Style__Group_1_1__1__Impl"
    // InternalDotStyleParser.g:253:1: rule__Style__Group_1_1__1__Impl : ( ( rule__Style__StyleItemsAssignment_1_1_1 ) ) ;
    public final void rule__Style__Group_1_1__1__Impl() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotStyleParser.g:257:1: ( ( ( rule__Style__StyleItemsAssignment_1_1_1 ) ) )
            // InternalDotStyleParser.g:258:1: ( ( rule__Style__StyleItemsAssignment_1_1_1 ) )
            {
            // InternalDotStyleParser.g:258:1: ( ( rule__Style__StyleItemsAssignment_1_1_1 ) )
            // InternalDotStyleParser.g:259:2: ( rule__Style__StyleItemsAssignment_1_1_1 )
            {
             before(grammarAccess.getStyleAccess().getStyleItemsAssignment_1_1_1()); 
            // InternalDotStyleParser.g:260:2: ( rule__Style__StyleItemsAssignment_1_1_1 )
            // InternalDotStyleParser.g:260:3: rule__Style__StyleItemsAssignment_1_1_1
            {
            pushFollow(FOLLOW_2);
            rule__Style__StyleItemsAssignment_1_1_1();

            state._fsp--;


            }

             after(grammarAccess.getStyleAccess().getStyleItemsAssignment_1_1_1()); 

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__Style__Group_1_1__1__Impl"


    // $ANTLR start "rule__StyleItem__Group__0"
    // InternalDotStyleParser.g:269:1: rule__StyleItem__Group__0 : rule__StyleItem__Group__0__Impl rule__StyleItem__Group__1 ;
    public final void rule__StyleItem__Group__0() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotStyleParser.g:273:1: ( rule__StyleItem__Group__0__Impl rule__StyleItem__Group__1 )
            // InternalDotStyleParser.g:274:2: rule__StyleItem__Group__0__Impl rule__StyleItem__Group__1
            {
            pushFollow(FOLLOW_6);
            rule__StyleItem__Group__0__Impl();

            state._fsp--;

            pushFollow(FOLLOW_2);
            rule__StyleItem__Group__1();

            state._fsp--;


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__StyleItem__Group__0"


    // $ANTLR start "rule__StyleItem__Group__0__Impl"
    // InternalDotStyleParser.g:281:1: rule__StyleItem__Group__0__Impl : ( ( rule__StyleItem__NameAssignment_0 ) ) ;
    public final void rule__StyleItem__Group__0__Impl() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotStyleParser.g:285:1: ( ( ( rule__StyleItem__NameAssignment_0 ) ) )
            // InternalDotStyleParser.g:286:1: ( ( rule__StyleItem__NameAssignment_0 ) )
            {
            // InternalDotStyleParser.g:286:1: ( ( rule__StyleItem__NameAssignment_0 ) )
            // InternalDotStyleParser.g:287:2: ( rule__StyleItem__NameAssignment_0 )
            {
             before(grammarAccess.getStyleItemAccess().getNameAssignment_0()); 
            // InternalDotStyleParser.g:288:2: ( rule__StyleItem__NameAssignment_0 )
            // InternalDotStyleParser.g:288:3: rule__StyleItem__NameAssignment_0
            {
            pushFollow(FOLLOW_2);
            rule__StyleItem__NameAssignment_0();

            state._fsp--;


            }

             after(grammarAccess.getStyleItemAccess().getNameAssignment_0()); 

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__StyleItem__Group__0__Impl"


    // $ANTLR start "rule__StyleItem__Group__1"
    // InternalDotStyleParser.g:296:1: rule__StyleItem__Group__1 : rule__StyleItem__Group__1__Impl ;
    public final void rule__StyleItem__Group__1() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotStyleParser.g:300:1: ( rule__StyleItem__Group__1__Impl )
            // InternalDotStyleParser.g:301:2: rule__StyleItem__Group__1__Impl
            {
            pushFollow(FOLLOW_2);
            rule__StyleItem__Group__1__Impl();

            state._fsp--;


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__StyleItem__Group__1"


    // $ANTLR start "rule__StyleItem__Group__1__Impl"
    // InternalDotStyleParser.g:307:1: rule__StyleItem__Group__1__Impl : ( ( rule__StyleItem__Group_1__0 )? ) ;
    public final void rule__StyleItem__Group__1__Impl() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotStyleParser.g:311:1: ( ( ( rule__StyleItem__Group_1__0 )? ) )
            // InternalDotStyleParser.g:312:1: ( ( rule__StyleItem__Group_1__0 )? )
            {
            // InternalDotStyleParser.g:312:1: ( ( rule__StyleItem__Group_1__0 )? )
            // InternalDotStyleParser.g:313:2: ( rule__StyleItem__Group_1__0 )?
            {
             before(grammarAccess.getStyleItemAccess().getGroup_1()); 
            // InternalDotStyleParser.g:314:2: ( rule__StyleItem__Group_1__0 )?
            int alt3=2;
            int LA3_0 = input.LA(1);

            if ( (LA3_0==LeftParenthesis) ) {
                alt3=1;
            }
            switch (alt3) {
                case 1 :
                    // InternalDotStyleParser.g:314:3: rule__StyleItem__Group_1__0
                    {
                    pushFollow(FOLLOW_2);
                    rule__StyleItem__Group_1__0();

                    state._fsp--;


                    }
                    break;

            }

             after(grammarAccess.getStyleItemAccess().getGroup_1()); 

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__StyleItem__Group__1__Impl"


    // $ANTLR start "rule__StyleItem__Group_1__0"
    // InternalDotStyleParser.g:323:1: rule__StyleItem__Group_1__0 : rule__StyleItem__Group_1__0__Impl rule__StyleItem__Group_1__1 ;
    public final void rule__StyleItem__Group_1__0() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotStyleParser.g:327:1: ( rule__StyleItem__Group_1__0__Impl rule__StyleItem__Group_1__1 )
            // InternalDotStyleParser.g:328:2: rule__StyleItem__Group_1__0__Impl rule__StyleItem__Group_1__1
            {
            pushFollow(FOLLOW_3);
            rule__StyleItem__Group_1__0__Impl();

            state._fsp--;

            pushFollow(FOLLOW_2);
            rule__StyleItem__Group_1__1();

            state._fsp--;


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__StyleItem__Group_1__0"


    // $ANTLR start "rule__StyleItem__Group_1__0__Impl"
    // InternalDotStyleParser.g:335:1: rule__StyleItem__Group_1__0__Impl : ( LeftParenthesis ) ;
    public final void rule__StyleItem__Group_1__0__Impl() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotStyleParser.g:339:1: ( ( LeftParenthesis ) )
            // InternalDotStyleParser.g:340:1: ( LeftParenthesis )
            {
            // InternalDotStyleParser.g:340:1: ( LeftParenthesis )
            // InternalDotStyleParser.g:341:2: LeftParenthesis
            {
             before(grammarAccess.getStyleItemAccess().getLeftParenthesisKeyword_1_0()); 
            match(input,LeftParenthesis,FOLLOW_2); 
             after(grammarAccess.getStyleItemAccess().getLeftParenthesisKeyword_1_0()); 

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__StyleItem__Group_1__0__Impl"


    // $ANTLR start "rule__StyleItem__Group_1__1"
    // InternalDotStyleParser.g:350:1: rule__StyleItem__Group_1__1 : rule__StyleItem__Group_1__1__Impl rule__StyleItem__Group_1__2 ;
    public final void rule__StyleItem__Group_1__1() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotStyleParser.g:354:1: ( rule__StyleItem__Group_1__1__Impl rule__StyleItem__Group_1__2 )
            // InternalDotStyleParser.g:355:2: rule__StyleItem__Group_1__1__Impl rule__StyleItem__Group_1__2
            {
            pushFollow(FOLLOW_7);
            rule__StyleItem__Group_1__1__Impl();

            state._fsp--;

            pushFollow(FOLLOW_2);
            rule__StyleItem__Group_1__2();

            state._fsp--;


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__StyleItem__Group_1__1"


    // $ANTLR start "rule__StyleItem__Group_1__1__Impl"
    // InternalDotStyleParser.g:362:1: rule__StyleItem__Group_1__1__Impl : ( ( rule__StyleItem__ArgsAssignment_1_1 ) ) ;
    public final void rule__StyleItem__Group_1__1__Impl() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotStyleParser.g:366:1: ( ( ( rule__StyleItem__ArgsAssignment_1_1 ) ) )
            // InternalDotStyleParser.g:367:1: ( ( rule__StyleItem__ArgsAssignment_1_1 ) )
            {
            // InternalDotStyleParser.g:367:1: ( ( rule__StyleItem__ArgsAssignment_1_1 ) )
            // InternalDotStyleParser.g:368:2: ( rule__StyleItem__ArgsAssignment_1_1 )
            {
             before(grammarAccess.getStyleItemAccess().getArgsAssignment_1_1()); 
            // InternalDotStyleParser.g:369:2: ( rule__StyleItem__ArgsAssignment_1_1 )
            // InternalDotStyleParser.g:369:3: rule__StyleItem__ArgsAssignment_1_1
            {
            pushFollow(FOLLOW_2);
            rule__StyleItem__ArgsAssignment_1_1();

            state._fsp--;


            }

             after(grammarAccess.getStyleItemAccess().getArgsAssignment_1_1()); 

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__StyleItem__Group_1__1__Impl"


    // $ANTLR start "rule__StyleItem__Group_1__2"
    // InternalDotStyleParser.g:377:1: rule__StyleItem__Group_1__2 : rule__StyleItem__Group_1__2__Impl rule__StyleItem__Group_1__3 ;
    public final void rule__StyleItem__Group_1__2() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotStyleParser.g:381:1: ( rule__StyleItem__Group_1__2__Impl rule__StyleItem__Group_1__3 )
            // InternalDotStyleParser.g:382:2: rule__StyleItem__Group_1__2__Impl rule__StyleItem__Group_1__3
            {
            pushFollow(FOLLOW_7);
            rule__StyleItem__Group_1__2__Impl();

            state._fsp--;

            pushFollow(FOLLOW_2);
            rule__StyleItem__Group_1__3();

            state._fsp--;


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__StyleItem__Group_1__2"


    // $ANTLR start "rule__StyleItem__Group_1__2__Impl"
    // InternalDotStyleParser.g:389:1: rule__StyleItem__Group_1__2__Impl : ( ( rule__StyleItem__Group_1_2__0 )* ) ;
    public final void rule__StyleItem__Group_1__2__Impl() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotStyleParser.g:393:1: ( ( ( rule__StyleItem__Group_1_2__0 )* ) )
            // InternalDotStyleParser.g:394:1: ( ( rule__StyleItem__Group_1_2__0 )* )
            {
            // InternalDotStyleParser.g:394:1: ( ( rule__StyleItem__Group_1_2__0 )* )
            // InternalDotStyleParser.g:395:2: ( rule__StyleItem__Group_1_2__0 )*
            {
             before(grammarAccess.getStyleItemAccess().getGroup_1_2()); 
            // InternalDotStyleParser.g:396:2: ( rule__StyleItem__Group_1_2__0 )*
            loop4:
            do {
                int alt4=2;
                int LA4_0 = input.LA(1);

                if ( (LA4_0==Comma) ) {
                    alt4=1;
                }


                switch (alt4) {
            	case 1 :
            	    // InternalDotStyleParser.g:396:3: rule__StyleItem__Group_1_2__0
            	    {
            	    pushFollow(FOLLOW_5);
            	    rule__StyleItem__Group_1_2__0();

            	    state._fsp--;


            	    }
            	    break;

            	default :
            	    break loop4;
                }
            } while (true);

             after(grammarAccess.getStyleItemAccess().getGroup_1_2()); 

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__StyleItem__Group_1__2__Impl"


    // $ANTLR start "rule__StyleItem__Group_1__3"
    // InternalDotStyleParser.g:404:1: rule__StyleItem__Group_1__3 : rule__StyleItem__Group_1__3__Impl ;
    public final void rule__StyleItem__Group_1__3() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotStyleParser.g:408:1: ( rule__StyleItem__Group_1__3__Impl )
            // InternalDotStyleParser.g:409:2: rule__StyleItem__Group_1__3__Impl
            {
            pushFollow(FOLLOW_2);
            rule__StyleItem__Group_1__3__Impl();

            state._fsp--;


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__StyleItem__Group_1__3"


    // $ANTLR start "rule__StyleItem__Group_1__3__Impl"
    // InternalDotStyleParser.g:415:1: rule__StyleItem__Group_1__3__Impl : ( RightParenthesis ) ;
    public final void rule__StyleItem__Group_1__3__Impl() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotStyleParser.g:419:1: ( ( RightParenthesis ) )
            // InternalDotStyleParser.g:420:1: ( RightParenthesis )
            {
            // InternalDotStyleParser.g:420:1: ( RightParenthesis )
            // InternalDotStyleParser.g:421:2: RightParenthesis
            {
             before(grammarAccess.getStyleItemAccess().getRightParenthesisKeyword_1_3()); 
            match(input,RightParenthesis,FOLLOW_2); 
             after(grammarAccess.getStyleItemAccess().getRightParenthesisKeyword_1_3()); 

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__StyleItem__Group_1__3__Impl"


    // $ANTLR start "rule__StyleItem__Group_1_2__0"
    // InternalDotStyleParser.g:431:1: rule__StyleItem__Group_1_2__0 : rule__StyleItem__Group_1_2__0__Impl rule__StyleItem__Group_1_2__1 ;
    public final void rule__StyleItem__Group_1_2__0() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotStyleParser.g:435:1: ( rule__StyleItem__Group_1_2__0__Impl rule__StyleItem__Group_1_2__1 )
            // InternalDotStyleParser.g:436:2: rule__StyleItem__Group_1_2__0__Impl rule__StyleItem__Group_1_2__1
            {
            pushFollow(FOLLOW_3);
            rule__StyleItem__Group_1_2__0__Impl();

            state._fsp--;

            pushFollow(FOLLOW_2);
            rule__StyleItem__Group_1_2__1();

            state._fsp--;


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__StyleItem__Group_1_2__0"


    // $ANTLR start "rule__StyleItem__Group_1_2__0__Impl"
    // InternalDotStyleParser.g:443:1: rule__StyleItem__Group_1_2__0__Impl : ( Comma ) ;
    public final void rule__StyleItem__Group_1_2__0__Impl() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotStyleParser.g:447:1: ( ( Comma ) )
            // InternalDotStyleParser.g:448:1: ( Comma )
            {
            // InternalDotStyleParser.g:448:1: ( Comma )
            // InternalDotStyleParser.g:449:2: Comma
            {
             before(grammarAccess.getStyleItemAccess().getCommaKeyword_1_2_0()); 
            match(input,Comma,FOLLOW_2); 
             after(grammarAccess.getStyleItemAccess().getCommaKeyword_1_2_0()); 

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__StyleItem__Group_1_2__0__Impl"


    // $ANTLR start "rule__StyleItem__Group_1_2__1"
    // InternalDotStyleParser.g:458:1: rule__StyleItem__Group_1_2__1 : rule__StyleItem__Group_1_2__1__Impl ;
    public final void rule__StyleItem__Group_1_2__1() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotStyleParser.g:462:1: ( rule__StyleItem__Group_1_2__1__Impl )
            // InternalDotStyleParser.g:463:2: rule__StyleItem__Group_1_2__1__Impl
            {
            pushFollow(FOLLOW_2);
            rule__StyleItem__Group_1_2__1__Impl();

            state._fsp--;


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__StyleItem__Group_1_2__1"


    // $ANTLR start "rule__StyleItem__Group_1_2__1__Impl"
    // InternalDotStyleParser.g:469:1: rule__StyleItem__Group_1_2__1__Impl : ( ( rule__StyleItem__ArgsAssignment_1_2_1 ) ) ;
    public final void rule__StyleItem__Group_1_2__1__Impl() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotStyleParser.g:473:1: ( ( ( rule__StyleItem__ArgsAssignment_1_2_1 ) ) )
            // InternalDotStyleParser.g:474:1: ( ( rule__StyleItem__ArgsAssignment_1_2_1 ) )
            {
            // InternalDotStyleParser.g:474:1: ( ( rule__StyleItem__ArgsAssignment_1_2_1 ) )
            // InternalDotStyleParser.g:475:2: ( rule__StyleItem__ArgsAssignment_1_2_1 )
            {
             before(grammarAccess.getStyleItemAccess().getArgsAssignment_1_2_1()); 
            // InternalDotStyleParser.g:476:2: ( rule__StyleItem__ArgsAssignment_1_2_1 )
            // InternalDotStyleParser.g:476:3: rule__StyleItem__ArgsAssignment_1_2_1
            {
            pushFollow(FOLLOW_2);
            rule__StyleItem__ArgsAssignment_1_2_1();

            state._fsp--;


            }

             after(grammarAccess.getStyleItemAccess().getArgsAssignment_1_2_1()); 

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__StyleItem__Group_1_2__1__Impl"


    // $ANTLR start "rule__Style__StyleItemsAssignment_1_0"
    // InternalDotStyleParser.g:485:1: rule__Style__StyleItemsAssignment_1_0 : ( ruleStyleItem ) ;
    public final void rule__Style__StyleItemsAssignment_1_0() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotStyleParser.g:489:1: ( ( ruleStyleItem ) )
            // InternalDotStyleParser.g:490:2: ( ruleStyleItem )
            {
            // InternalDotStyleParser.g:490:2: ( ruleStyleItem )
            // InternalDotStyleParser.g:491:3: ruleStyleItem
            {
             before(grammarAccess.getStyleAccess().getStyleItemsStyleItemParserRuleCall_1_0_0()); 
            pushFollow(FOLLOW_2);
            ruleStyleItem();

            state._fsp--;

             after(grammarAccess.getStyleAccess().getStyleItemsStyleItemParserRuleCall_1_0_0()); 

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__Style__StyleItemsAssignment_1_0"


    // $ANTLR start "rule__Style__StyleItemsAssignment_1_1_1"
    // InternalDotStyleParser.g:500:1: rule__Style__StyleItemsAssignment_1_1_1 : ( ruleStyleItem ) ;
    public final void rule__Style__StyleItemsAssignment_1_1_1() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotStyleParser.g:504:1: ( ( ruleStyleItem ) )
            // InternalDotStyleParser.g:505:2: ( ruleStyleItem )
            {
            // InternalDotStyleParser.g:505:2: ( ruleStyleItem )
            // InternalDotStyleParser.g:506:3: ruleStyleItem
            {
             before(grammarAccess.getStyleAccess().getStyleItemsStyleItemParserRuleCall_1_1_1_0()); 
            pushFollow(FOLLOW_2);
            ruleStyleItem();

            state._fsp--;

             after(grammarAccess.getStyleAccess().getStyleItemsStyleItemParserRuleCall_1_1_1_0()); 

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__Style__StyleItemsAssignment_1_1_1"


    // $ANTLR start "rule__StyleItem__NameAssignment_0"
    // InternalDotStyleParser.g:515:1: rule__StyleItem__NameAssignment_0 : ( RULE_NAME ) ;
    public final void rule__StyleItem__NameAssignment_0() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotStyleParser.g:519:1: ( ( RULE_NAME ) )
            // InternalDotStyleParser.g:520:2: ( RULE_NAME )
            {
            // InternalDotStyleParser.g:520:2: ( RULE_NAME )
            // InternalDotStyleParser.g:521:3: RULE_NAME
            {
             before(grammarAccess.getStyleItemAccess().getNameNAMETerminalRuleCall_0_0()); 
            match(input,RULE_NAME,FOLLOW_2); 
             after(grammarAccess.getStyleItemAccess().getNameNAMETerminalRuleCall_0_0()); 

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__StyleItem__NameAssignment_0"


    // $ANTLR start "rule__StyleItem__ArgsAssignment_1_1"
    // InternalDotStyleParser.g:530:1: rule__StyleItem__ArgsAssignment_1_1 : ( RULE_NAME ) ;
    public final void rule__StyleItem__ArgsAssignment_1_1() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotStyleParser.g:534:1: ( ( RULE_NAME ) )
            // InternalDotStyleParser.g:535:2: ( RULE_NAME )
            {
            // InternalDotStyleParser.g:535:2: ( RULE_NAME )
            // InternalDotStyleParser.g:536:3: RULE_NAME
            {
             before(grammarAccess.getStyleItemAccess().getArgsNAMETerminalRuleCall_1_1_0()); 
            match(input,RULE_NAME,FOLLOW_2); 
             after(grammarAccess.getStyleItemAccess().getArgsNAMETerminalRuleCall_1_1_0()); 

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__StyleItem__ArgsAssignment_1_1"


    // $ANTLR start "rule__StyleItem__ArgsAssignment_1_2_1"
    // InternalDotStyleParser.g:545:1: rule__StyleItem__ArgsAssignment_1_2_1 : ( RULE_NAME ) ;
    public final void rule__StyleItem__ArgsAssignment_1_2_1() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotStyleParser.g:549:1: ( ( RULE_NAME ) )
            // InternalDotStyleParser.g:550:2: ( RULE_NAME )
            {
            // InternalDotStyleParser.g:550:2: ( RULE_NAME )
            // InternalDotStyleParser.g:551:3: RULE_NAME
            {
             before(grammarAccess.getStyleItemAccess().getArgsNAMETerminalRuleCall_1_2_1_0()); 
            match(input,RULE_NAME,FOLLOW_2); 
             after(grammarAccess.getStyleItemAccess().getArgsNAMETerminalRuleCall_1_2_1_0()); 

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__StyleItem__ArgsAssignment_1_2_1"

    // Delegated rules


 

    public static final BitSet FOLLOW_1 = new BitSet(new long[]{0x0000000000000000L});
    public static final BitSet FOLLOW_2 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_3 = new BitSet(new long[]{0x0000000000000100L});
    public static final BitSet FOLLOW_4 = new BitSet(new long[]{0x0000000000000040L});
    public static final BitSet FOLLOW_5 = new BitSet(new long[]{0x0000000000000042L});
    public static final BitSet FOLLOW_6 = new BitSet(new long[]{0x0000000000000010L});
    public static final BitSet FOLLOW_7 = new BitSet(new long[]{0x0000000000000060L});

}