/*********************************************************************
* Copyright (c) 2005, 2019 SAP SE
*
* This program and the accompanying materials are made
* available under the terms of the Eclipse Public License 2.0
* which is available at https://www.eclipse.org/legal/epl-2.0/
*
* Contributors:
*    SAP SE - initial API, implementation and documentation
*
* SPDX-License-Identifier: EPL-2.0
**********************************************************************/
package org.eclipse.graphiti.examples.common.outline.tree;

import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartFactory;
import org.eclipse.graphiti.mm.algorithms.GraphicsAlgorithm;
import org.eclipse.graphiti.mm.algorithms.styles.Color;
import org.eclipse.graphiti.mm.algorithms.styles.Point;
import org.eclipse.graphiti.mm.algorithms.styles.Style;
import org.eclipse.graphiti.mm.pictograms.ConnectionDecorator;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;

/**
 * A concrete implementation of the interface IEditPartFactory for Trees, which
 * works on a pictogram model.
 */
public class PictogramsTreeEditPartFactory implements EditPartFactory {

	/**
	 * Creates a new PictogramsEditPartFactory.
	 */
	public PictogramsTreeEditPartFactory() {
		super();
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see
	 * org.eclipse.gef.EditPartFactory#createEditPart(org.eclipse.gef.EditPart,
	 * java.lang.Object)
	 */
	public EditPart createEditPart(EditPart context, Object model) {
		EditPart ret = null;
		if (model instanceof PictogramElement) {
			ret = new PictogramElementTreeEditPart((PictogramElement) model);
		} else if (model instanceof GraphicsAlgorithm) {
			ret = new GraphicsAlgorithmTreeEditPart((GraphicsAlgorithm) model);
		} else if (model instanceof ConnectionDecorator) {
			ret = new ConnectionDecoratorTreeEditPart((ConnectionDecorator) model);
		} else if (model instanceof Point) {
			ret = new PointTreeEditPart((Point) model);
		} else if (model instanceof Color) {
			ret = new ColorTreeEditPart((Color) model);
		} else if (model instanceof Style) {
			ret = new StyleTreeEditPart((Style) model);
		}
		return ret;
	}
}