/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.runtime.rete.index;

import java.util.Collection;
import java.util.Map;
import org.eclipse.viatra.query.runtime.matchers.tuple.Tuple;
import org.eclipse.viatra.query.runtime.matchers.util.Direction;
import org.eclipse.viatra.query.runtime.matchers.util.Signed;
import org.eclipse.viatra.query.runtime.matchers.util.timeline.Timeline;
import org.eclipse.viatra.query.runtime.rete.index.DualInputNode;
import org.eclipse.viatra.query.runtime.rete.network.ReteContainer;
import org.eclipse.viatra.query.runtime.rete.network.communication.Timestamp;

public class ExistenceNode
extends DualInputNode {
    protected boolean negative;
    private final DualInputNode.NetworkStructureChangeSensitiveLogic TIMELESS = new DualInputNode.NetworkStructureChangeSensitiveLogic(){

        @Override
        public void pullIntoWithTimeline(Map<Tuple, Timeline<Timestamp>> collector, boolean flush) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void pullInto(Collection<Tuple> collector, boolean flush) {
            if (ExistenceNode.this.primarySlot == null || ExistenceNode.this.secondarySlot == null) {
                return;
            }
            if (flush) {
                ExistenceNode.this.reteContainer.flushUpdates();
            }
            for (Tuple signature : ExistenceNode.this.primarySlot.getSignatures()) {
                Collection<Tuple> primaries = ExistenceNode.this.primarySlot.get(signature);
                Collection<Tuple> opposites = ExistenceNode.this.secondarySlot.get(signature);
                if (!(opposites != null ^ ExistenceNode.this.negative)) continue;
                collector.addAll(primaries);
            }
        }

        @Override
        public void notifyUpdate(DualInputNode.Side side, Direction direction, Tuple updateElement, Tuple signature, boolean change, Timestamp timestamp) {
            if (!$assertionsDisabled && !Timestamp.ZERO.equals(timestamp)) {
                throw new AssertionError();
            }
            switch (side) {
                case PRIMARY: {
                    if (!(ExistenceNode.this.retrieveOpposites(side, signature) != null ^ ExistenceNode.this.negative)) break;
                    ExistenceNode.this.propagateUpdate(direction, updateElement, timestamp);
                    break;
                }
                case SECONDARY: {
                    Collection<Tuple> opposites;
                    if (!change || (opposites = ExistenceNode.this.retrieveOpposites(side, signature)) == null) break;
                    for (Tuple opposite : opposites) {
                        ExistenceNode.this.propagateUpdate(ExistenceNode.this.negative ? direction.opposite() : direction, opposite, timestamp);
                    }
                    break;
                }
                case BOTH: {
                    if (ExistenceNode.this.negative) break;
                    ExistenceNode.this.propagateUpdate(direction, updateElement, timestamp);
                }
            }
        }
    };
    private final DualInputNode.NetworkStructureChangeSensitiveLogic TIMELY = new DualInputNode.NetworkStructureChangeSensitiveLogic(){

        @Override
        public void pullIntoWithTimeline(Map<Tuple, Timeline<Timestamp>> collector, boolean flush) {
            if (ExistenceNode.this.primarySlot == null || ExistenceNode.this.secondarySlot == null) {
                return;
            }
            if (flush) {
                ExistenceNode.this.reteContainer.flushUpdates();
            }
            for (Tuple signature : ExistenceNode.this.primarySlot.getSignatures()) {
                Map<Tuple, Timeline<Timestamp>> primaries = ExistenceNode.this.getTimeline(signature, ExistenceNode.this.primarySlot);
                Collection<Tuple> opposites = ExistenceNode.this.secondarySlot.get(signature);
                if (!(opposites != null ^ ExistenceNode.this.negative)) continue;
                for (Tuple primary : primaries.keySet()) {
                    collector.put(primary, primaries.get(primary));
                }
            }
        }

        @Override
        public void pullInto(Collection<Tuple> collector, boolean flush) {
            ExistenceNode.this.TIMELESS.pullInto(collector, flush);
        }

        @Override
        public void notifyUpdate(DualInputNode.Side side, Direction direction, Tuple updateElement, Tuple signature, boolean change, Timestamp timestamp) {
            switch (side) {
                case PRIMARY: {
                    Collection<Tuple> opposites = ExistenceNode.this.secondarySlot.get(signature);
                    if (!(opposites != null ^ ExistenceNode.this.negative)) break;
                    ExistenceNode.this.propagateUpdate(direction, updateElement, timestamp);
                    break;
                }
                case SECONDARY: {
                    Map<Tuple, Timeline<Timestamp>> opposites = ExistenceNode.this.primarySlot.getTimeline(signature);
                    if (!change || opposites == null) break;
                    for (Tuple opposite : opposites.keySet()) {
                        for (Signed oppositeSigned : opposites.get(opposite).asChangeSequence()) {
                            Direction product = direction.multiply(oppositeSigned.getDirection());
                            ExistenceNode.this.propagateUpdate(ExistenceNode.this.negative ? product.opposite() : product, opposite, (Timestamp)oppositeSigned.getPayload());
                        }
                    }
                    break;
                }
                case BOTH: {
                    if (ExistenceNode.this.negative) break;
                    ExistenceNode.this.propagateUpdate(direction, updateElement, timestamp);
                }
            }
        }
    };

    public ExistenceNode(ReteContainer reteContainer, boolean negative) {
        super(reteContainer, null);
        this.negative = negative;
        this.logic = this.createLogic();
    }

    @Override
    public Tuple calibrate(Tuple primary, Tuple secondary) {
        return primary;
    }

    @Override
    public void networkStructureChanged() {
        if (this.reteContainer.isTimelyEvaluation() && this.secondarySlot != null && this.reteContainer.getCommunicationTracker().areInSameGroup(this, this.secondarySlot)) {
            throw new IllegalStateException("Secondary parent must be in an upstream dependency component!");
        }
        super.networkStructureChanged();
    }

    @Override
    protected DualInputNode.NetworkStructureChangeSensitiveLogic createTimelessLogic() {
        return this.TIMELESS;
    }

    @Override
    protected DualInputNode.NetworkStructureChangeSensitiveLogic createTimelyLogic() {
        return this.TIMELY;
    }
}

